
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <limits.h>
#include <time.h>
#include <string.h>

/****************** Defines ***********************************************/

enum ACTS { ACT_NORMAL, ACT_ONCLICK };
#define IDM_CLS  	1
#define IDM_PREFS 2
#define IDM_HELP  3
#define TIME() time( NULL)
/*#define TIME() (timer_Read()/1193181)*/
		/* This version does not use this accurate timer, so it is not included*/ 

#define MAXTBL 512

#define FLAG_SAVECONFIG	1
#define FLAG_KEEPSCALE	2

#define PD_RESET	101
#define PD_CANCEL	102
#define PD_SAVE		103
#define PD_OK			104
#define PDF_GRID	108
#define PDF_KEEP	109
#define PDF_SAVE	110
#define PDE_IDLE	120
#define PDE_SCALE	121
#define PDE_SPEED	122

/****************** Funtion Declarations **********************************/

#pragma argsused
long FAR PASCAL _export WndProc( HWND, unsigned, unsigned int, LONG);
#pragma argsused
BOOL FAR PASCAL _export DlgProc( HWND, unsigned, unsigned int, LONG);
void						InvaFrom( RECT *rc, int, int);
void 						DeActivateMe( HWND );
void 						ActivateMe( HWND );
void						SaveConfigs( HWND);
BOOL						DialogConfigs( HWND);
void						AddTime( HWND);

/****************** Variables *********************************************/

HANDLE			hWinstance;
int					current, px;
long				tbl[MAXTBL+1], tbl_erase[MAXTBL+1];
WORD				tbl_flag[MAXTBL+1];
char				thispas;
int					xChar, yChar;
long				tb_max, new_max;
time_t			timenow, timecur;
char				act;
enum ACTS		TypeOfAct;
int					Grid;
HPEN				hGrayPen, hBlackPen, hDotPen;
int					xs, xe, ys, ye;
WORD				DisplayTime, DispLen;
HMENU				hMenu;
char				szDialogCaption[]="PeekMessager V1.0";
char				szAppName[]="Messager";
char				szSection[]="PeekMessager1.0";
char				szProfile[]="messager.ini";
char				str[64];
int					xWidow, yWidow, xClient, yClient;
int					Flags;
HWND				hMainWnd;
char				AboutText[]="PeekMessager V1.0 4-1994\n"
												" Bug reports etc Welcome\n"
												" See file 'met.txt' for help\n"
                        "TPR <tronkko@dakota.pspt.fi>";
char				szMem[30]="\0";


/****************** Main **************************************************/

#pragma arsused
int PASCAL _export WinMain( HANDLE	hInstance,
										HANDLE	hPrevInstance,
										LPSTR		lpszCmdLine,
										int			nCmdShow)
{
	HWND				hWnd;
	WNDCLASS		wndclass;
  MSG					msg;
	int					l;
  char				*p;
 
	if( hPrevInstance)
	{
		if( GetInstanceData( hPrevInstance, (BYTE*)&hWinstance, sizeof( HANDLE))
			!=sizeof( HANDLE)) ShowWindow( hWinstance, SW_SHOWNORMAL);
		return FALSE;
  }

/*** Load Configs here ***/

	GetPrivateProfileString( szSection, "DispTime", "1100",
					str, sizeof( str), szProfile);
	DisplayTime=(WORD) atol( str);

	GetPrivateProfileString( szSection, "Idle", "0",
					str, sizeof( str), szProfile);
	tb_max=new_max=atol( str);

	DispLen=GetPrivateProfileInt( szSection, "DispLen",	 256, szProfile)%512;
	Grid	 =GetPrivateProfileInt( szSection, "Grid",	 	 1, 	szProfile);
	Flags	 =GetPrivateProfileInt( szSection, "Flags",  	 0, 	szProfile);

	GetPrivateProfileString( szSection, "Size", "0,0,640,100,0",
					str, sizeof( str), szProfile);

	p=strtok( str, ",");
	xWidow =atoi( p);
	p=strtok( NULL, ",");
  yWidow =atoi( p);
	p=strtok( NULL, ",");
  xClient=atoi( p);
	p=strtok( NULL, ",");
  yClient=atoi( p);
	p=strtok( NULL, ",");
	l=atoi( p);
  if(l) nCmdShow=l; 

/*** End of Configs ***/

  if( DispLen<20) DispLen=20;
	TypeOfAct=ACT_NORMAL;    /* Type of activation ( timer, click)*/
	act=0;
	current=px=0;
	thispas=1;
	for( l=0; l<MAXTBL; l++)
	{
		tbl[l]=LONG_MAX;
		tbl_erase[l]=LONG_MAX;
		tbl_flag[l]=0;
	}

	if( !hPrevInstance)
	{
		wndclass.style				=CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
		wndclass.lpfnWndProc	=WndProc;
		wndclass.cbClsExtra		=0;
		wndclass.cbWndExtra		=0;
		wndclass.hInstance		=hInstance;
		wndclass.hIcon				=LoadIcon( hInstance, "ICON_2");
		wndclass.hCursor			=LoadCursor( NULL, IDC_ARROW);
		wndclass.hbrBackground=COLOR_WINDOW+1;
		wndclass.lpszMenuName	=NULL;
		wndclass.lpszClassName=szAppName;

    if( !RegisterClass( &wndclass)) return FALSE;
	}

	hWnd=CreateWindow(	szAppName,
											"PeekMessager",
											WS_OVERLAPPEDWINDOW,
											xWidow,					yWidow,
											xClient,				yClient,
											NULL,           NULL,
											hInstance,
											NULL);

	do{
  	l=IDABORT;
		if( !SetTimer( hWnd, 1, DisplayTime, NULL))
		{
			l=MessageBox( hWnd,
				"Too many timers!\n Please close at least one program using timers (such as clock)",
				szDialogCaption, MB_ICONEXCLAMATION|MB_RETRYCANCEL);
		}
	}while( l==IDRETRY);
	if( l==IDCANCEL) return FALSE;

  hMainWnd=hWnd;
	hMenu=GetSystemMenu( hWnd, FALSE);

  ChangeMenu( hMenu, NULL, NULL,					 0,					MF_APPEND);
	ChangeMenu( hMenu, NULL, "Clear Screen", IDM_CLS,		MF_APPEND);
	ChangeMenu( hMenu, NULL, "Prefs ...",		 IDM_PREFS,	MF_APPEND);
	ChangeMenu( hMenu, NULL, "About",				 IDM_HELP,	MF_APPEND);


	ShowWindow( hWnd, nCmdShow);
	UpdateWindow( hWnd);
	if( IsWindowVisible( hWnd)) ActivateMe( hWnd);

	for(;;){
		l=PeekMessage( &msg, NULL, 0, 0, PM_REMOVE);
    if( l)
    {
			if( msg.message==WM_QUIT) break;

			TranslateMessage( &msg);
			DispatchMessage( &msg);
    }
  	AddTime( hWnd);
	}
  return msg.wParam;     
}

long FAR PASCAL _export WndProc( HWND					  hWnd,
												 unsigned  		  iMessage,
												 unsigned int		wParam,
												 LONG					  lParam)
{
	static HINSTANCE	hInstance;
  static FARPROC  	lpfnDlgProc;
	HDC			 					hDC;
	PAINTSTRUCT				ps;
	static HRSRC			hDialog;
	HGLOBAL						hGlobal;
	int								x, y, xinc, l, temp, t2;
	RECT							rect, inva, temprc, rc;
	int								size;
	static char				txt[8];
	TEXTMETRIC				tm;

	switch( iMessage)
	{
		case WM_SYSCOLORCHANGE:
			DeleteObject( hBlackPen);
			DeleteObject( hGrayPen);
			DeleteObject( hDotPen);
			hGrayPen =CreatePen( PS_SOLID, 1, GetSysColor( COLOR_GRAYTEXT));
			hDotPen  =CreatePen( PS_DOT,   1, GetSysColor( COLOR_GRAYTEXT));
			hBlackPen=CreatePen( PS_SOLID, 1, GetSysColor( COLOR_WINDOWTEXT));
			InvalidateRect( hWinstance, NULL, TRUE);
			break;
		case WM_CREATE:
			xs=xe=ys=ye=0;
			timenow=TIME();
			timecur=timenow;
			hGrayPen =CreatePen( PS_SOLID, 1, GetSysColor( COLOR_GRAYTEXT));
			hDotPen  =CreatePen( PS_DOT,   1, GetSysColor( COLOR_GRAYTEXT));
			hBlackPen=CreatePen( PS_SOLID, 1, GetSysColor( COLOR_WINDOWTEXT));
			hDC=GetDC( hWnd);
			GetTextMetrics( hDC, &tm);
			xChar=tm.tmAveCharWidth;
			yChar=tm.tmAscent;
			ReleaseDC( hWnd, hDC);
			hWinstance=hWnd;
			hInstance=(( LPCREATESTRUCT)lParam)->hInstance;
			lpfnDlgProc=MakeProcInstance( (DLGPROC)DlgProc, hInstance);
			break;
    case WM_LBUTTONDOWN:      /* Update screen when clicked */
		case WM_MOUSEACTIVATE:
			PostMessage( hWnd, WM_TIMER, 0, 0L);
			break;
		case WM_ACTIVATE:          /* Update screen when activated */
			switch( wParam)
			{
			case WA_ACTIVE:
			case WA_CLICKACTIVE:
				PostMessage( hWnd, WM_TIMER, 0, 0L);
				break;
			}
      break;
		case WM_SIZE:
			switch( wParam)
			{
			case SIZE_MAXIMIZED:
			case SIZE_RESTORED:
      case SIZE_MAXSHOW:
				ActivateMe( hWnd);
				if( (Flags&FLAG_KEEPSCALE)!=0)
				{
					DispLen=((long)DispLen*LOWORD( lParam))/xClient;
					if( DispLen<current)
					{
						for( l=0; l<=DispLen; l++)
						{
							x=l+(current-DispLen);
							tbl_erase[l]=tbl_erase[x];
							tbl[l]			=tbl[x];
							tbl_flag[l] =tbl_flag[x];
						}
						current=0;
            thispas++;
						timecur=timenow;
					}
        }
				break;
      case SIZE_MAXHIDE:
			case SIZE_MINIMIZED:
				DeActivateMe( hWnd);
        break;
			}
			xClient=LOWORD( lParam);
      yClient=HIWORD( lParam);
			break;
		case WM_SYSCOMMAND:
			switch( wParam)
			{
			case IDM_CLS:
				temprc.left  =xs;
				temprc.right =xe;
        InvaFrom( &temprc, 0, DispLen);
				if( act>0) InvalidateRect( hWnd, &temprc, TRUE);
				thispas++;
				current=px=0;
				break;
			case IDM_PREFS:
				KillTimer( hWnd, 1);

        hDialog=FindResource( hInstance, "DIALOG_1", RT_DIALOG);
				hGlobal=LoadResource( hInstance, hDialog);
				if( hGlobal)
				{
          LockResource( hGlobal);
					if( DialogBoxIndirect( hInstance, hGlobal, hWinstance, lpfnDlgProc)!=-1)
							InvalidateRect( hWinstance, NULL, TRUE);
					UnlockResource( hGlobal);
					FreeResource( hGlobal);
				}
				SetTimer( hWnd, 1, DisplayTime, NULL);
				break;
			case IDM_HELP:
				MessageBox( hWnd, AboutText, szAppName, MB_OK);
				break;
			default:
				AddTime( hWnd);
				return DefWindowProc( hWnd, iMessage, wParam, lParam);
      }
    	break;
		case WM_TIMER:
			temp=(int)(timenow-timecur);
      if( !temp) break;
			for( x=0; x<=temp; x++)
			{
				l=(x+current)%DispLen;
				if( (tbl_flag[l]>>9)!=thispas)
				{
					tbl_erase[l]=tbl[l];
					tbl[	    l]=0;
					tbl_flag[ l]=thispas<<9;
				}
			}

			x=(current+temp)%DispLen;
			if( x<current) thispas++;

			temprc.top=temprc.bottom=0;
			if( px <x)
			{
				px=x;
        l =FALSE;
			}else l=TRUE;
			if( new_max>tb_max)
			{
      	tb_max=new_max;
				temprc.left  =xs;
				temprc.right =(int)(((long)(xe-xs)*px)/DispLen)+xs;
        InvaFrom( &temprc, 0, px+1);
				if( act>0) InvalidateRect( hWnd, &temprc, TRUE);
				current=x;
				timecur=timenow;
				break;
			}
			y     		   =(int)(((long)(xe-xs)*(current-1))/DispLen);
			temprc.left	 =xs+y;
			y    		     =(int)(((long)(y    )*DispLen)    /(xe-xs));
			temprc.right =(int)(((long)(xe-xs)*(current+temp))/DispLen)+xs+1;
			if( (current-1)>x)
			{
				temprc.top	 =ys;
				temprc.bottom=ye;
				if( act>0) InvalidateRect( hWnd, &temprc, l);
				temprc.left	 =xs;
				temprc.right =(int)(((long)(xe-xs)*x)/DispLen)+xs+1;
			}
			else InvaFrom( &temprc, y, x);
			if( act>0) InvalidateRect( hWnd, &temprc, l);
			current=x;
			timecur=timenow;
			break;
		case WM_PAINT:
			temp=(int)GetUpdateRect( hWnd, &inva, TRUE);
			hDC=BeginPaint( hWnd, &ps);
			if( temp!=0 && act>0)
			{
				GetClientRect( hWnd, &rect);
				size =rect.bottom/20;					/* Auto-size graphics */
				if( size>5) size=5;
				ys=size*4;
        if( ys>yChar/2) ys=yChar/2;
        ye=rect.bottom-size*2;
 				temprc.left  =size;
				temprc.top   =ys;
				temprc.right =size*2+2;
				temprc.bottom=ye;
				if( IntersectRect( &rc, &inva, &temprc))
				{
					SelectObject( hDC, hGrayPen);
					for( l=0; l<10; l++)
					{
						y=ys+(ye-ys)*l/10;
						if( inva.top<=y && inva.bottom>=y)
            {
							MoveTo( hDC, size, y);
	 		    		LineTo( hDC, size*2, y);
						}
					}
					MoveTo( hDC, size*2, ys);
					LineTo( hDC, size*2, ye);
				}

 				xs=size*2;
				size=rect.right/40;
				if( size>5) size=5;
				xe=rect.right-size*2;
				temprc.left  =xs;
				temprc.top   =ye-yChar/2;
				temprc.right =xe+1;
				temprc.bottom=ye+size;
				if( IntersectRect( &rc, &inva, &temprc))
 	    	{
					SelectObject( hDC, hGrayPen);
          x=xs;
					for( l=0; l<DispLen; l+=10)
					{
						x=(int)(((long)(xe-xs)*l)/DispLen +xs);
						MoveTo( hDC, x, ye);
						LineTo( hDC, x, ye+size);
					}
					MoveTo( hDC, xs, ye);
					LineTo( hDC, xe, ye);
 	    	}

				temprc.left  =xs;
				temprc.top   =ys;
				temprc.right =xe+1;
				temprc.bottom=ye;
				if( IntersectRect( &rc, &inva, &temprc))
				{
					if( Grid!=FALSE)
          {
						temp=(ye-ys)/10;
						SelectObject( hDC, hDotPen);
						SetTextColor( hDC, RGB( 0xc0, 0xc8, 0xd0));
						SetBkMode( hDC, TRANSPARENT);
						for( l=xinc=x=size=0; l<10; l++)
						{
							y		 =ys+(ye-ys)*l/10;
							size =y-size;
							xinc+=size;
							x		+=size;
							size=y;
							if( xinc>2)
	            {
								xinc=0;
								if( y>=inva.top && y<=inva.bottom)
								{
									MoveTo( hDC, xs, y);
									if( x>=(yChar>>1)) LineTo( hDC, xe-xChar, y);
									else LineTo( hDC, xe-xChar*3, y);
								}
								if( x>=(yChar>>1))
		            {
									x=-(yChar>>1);
									if( inva.right>=xe-xChar*2 && inva.top<=y+(yChar>>1) && inva.bottom>=y-(yChar>>1))
									{
										sprintf( txt, "%2d", (int)(10-l));
										TextOut( hDC, xe-xChar*2, y-(yChar>>1), txt, 2);
		            	}
								}
		          }
						}
					}
        	SelectObject( hDC, hBlackPen);
					xinc=0;
					l   =(int)(((long)(inva.left -xs-1)*DispLen)/(xe-xs));
					temp=(int)(((long)(inva.right-xs  )*DispLen)/(xe-xs)+1);
					if( temp>px) temp=px;
					if( l<0) l=0;
          size=l-current;
					t2	=(int)(timenow&0x1ff);
					for(; l<temp; l++)
					{
						x=(int)(((long)(xe-xs)*l)/DispLen)+xs;
						y=(int)(((long)(ye-ys)*tbl[l])/tb_max)+ys;
						if( y>ye) y=ye;
						if( (tbl_flag[l]&0x1ff)==t2 || l==current) size=0;
						if( size>=0)
						{
							size++;
							if( size>3) size=-1000;
              xinc=1;
							MoveTo( hDC, x, y);
							continue;
						} 
						if( !xinc)
						{
							MoveTo( hDC, x, y);
							xinc=1;
						}
						else LineTo( hDC, x, y);
					}
				}
				SelectObject( hDC, hBlackPen);
			}
			EndPaint( hWnd, &ps);
    	break;
		case WM_DESTROY:
			if( (Flags&FLAG_SAVECONFIG)!=0) SaveConfigs( hWnd);
			KillTimer( hWnd, 1);
			PostQuitMessage( 0);
			DeleteObject( hBlackPen);
			DeleteObject( hGrayPen);
			DeleteObject( hDotPen);
			break;
		case WM_ENDSESSION:							/* User exiting windows */
      if( wParam!=FALSE) break;
			if( (Flags&FLAG_SAVECONFIG)!=0) SaveConfigs( hWnd);
			break;
		default:
			return DefWindowProc( hWnd, iMessage, wParam, lParam);
	}                      
	return 0L;
}

void DeActivateMe( HWND hWnd)			/* Timer deactivated when iconised */
{
	act=0;
	KillTimer( hWnd, 1);
	SetTimer( hWnd, 1, (unsigned int)65000, NULL);
}

void ActivateMe( HWND hWnd)
{
	if( act==0)
  {
		act=1;
		KillTimer( hWnd, 1);
		switch( TypeOfAct)
		{
		case ACT_NORMAL:
			SetTimer( hWnd, 1, DisplayTime, NULL);
  		break;
		case ACT_ONCLICK:
			SetTimer( hWnd, 1, 10000U, NULL);
			break;
    }
	}
}

void InvaFrom( RECT *rc, int sta, int end) /*Smallest possible rect invalidated*/
{
	long	low, hi, temp;
	int		l, x;

	hi =0;
	low=tb_max;
	if( sta<0) sta=0;
	if( end>DispLen) end=DispLen;
  if( end>px)			 end=px;

	x=(int)(timenow&0x1ff);
	for( l=sta; l<=end; l++)
	{
		if( (tbl_flag[l]&0x1ff)!=x)
    {
			temp=tbl[l];
			if( temp>=0 && temp<=tb_max)
	    {
				if( temp<low) low=temp;
	    	if( temp>hi ) hi =temp;
			}
    }
		temp=tbl_erase[l];
		if( temp>=0 && temp<=tb_max)
    {
			if( temp<low) low=temp;
			if( temp>hi ) hi =temp;
  	}
	}
	rc->top   =(int)(((long)(ye-ys)*low)/tb_max)+ys;
	rc->bottom=(int)(((long)(ye-ys)*hi )/tb_max)+ys+1;

	if( rc->top   <ys	 ) rc->top=ys;
  if( rc->bottom>ye+1) rc->top=ye+1;
}

void AddTime( HWND hWnd)
{
  int			temp, l;

	timenow=TIME();
	temp=(current+(WORD)(timenow-timecur))%DispLen;
	if( temp<current) SendMessage( hWnd, WM_TIMER, 0, 0L);

	timenow=TIME();
	temp=(current+(WORD)(timenow-timecur))%DispLen;
	l=(int)(timenow&0x1ff);
	if( tbl_flag[temp]!=((thispas<<9)|l))
	{
   	tbl_erase[temp]=tbl[temp];
		tbl[temp]=0;
		tbl_flag[temp]=(thispas<<9)|l;
	}
	tbl[temp]+=1;
	if( tbl[temp]>new_max) new_max=tbl[temp];
}

void SaveConfigs( HWND hWnd)
{
	static WINDOWPLACEMENT wp;

  ltoa( (long)DisplayTime, str, 10); 
	WritePrivateProfileString( szSection, "DispTime",str, szProfile);
	ltoa( (long)new_max, str, 10);
	WritePrivateProfileString( szSection, "Idle", 	 str, szProfile);
  itoa( DispLen, str, 10);
	WritePrivateProfileString( szSection, "DispLen", str, szProfile);
	itoa( Grid   , str, 10);
	WritePrivateProfileString( szSection, "Grid",		 str, szProfile);
	itoa( Flags  , str, 10);
	WritePrivateProfileString( szSection, "Flags",	 str, szProfile);

	wp.length=sizeof( struct tagWINDOWPLACEMENT);
	if( !GetWindowPlacement( hWnd, &wp))
		strcpy( str, "0,0,640,100,0");
  else
		sprintf( str, "%i,%i,%i,%i,%i", wp.rcNormalPosition.left,
																	wp.rcNormalPosition.top,
																	wp.rcNormalPosition.right-wp.rcNormalPosition.left,
																	wp.rcNormalPosition.bottom-wp.rcNormalPosition.top,
																	wp.showCmd);

	WritePrivateProfileString( szSection, "Size", str, szProfile);
	WritePrivateProfileString( NULL, NULL, NULL, szProfile);
}

BOOL DialogConfigs( HWND hWnd)
{
	BOOL	flag;
	WORD	dtime;
	int		len;
	long	t;
  char  str[20];

	dtime=( WORD)GetDlgItemInt(  hWnd, PDE_SPEED, &flag, TRUE);
	if( flag==FALSE)
	{ 
		MessageBox( hWinstance,
				"Illegal Speed value!!",
				szDialogCaption, MB_ICONEXCLAMATION|MB_OK);
  	return FALSE;
	}
	len =GetDlgItemInt(  hWnd, PDE_SCALE, &flag, FALSE);
	if( flag==FALSE || len<20 || len>MAXTBL)
	{
		sprintf( str,"Scale must be 20-%i !!", MAXTBL);
		MessageBox( hWinstance,
				str, szDialogCaption, MB_ICONEXCLAMATION|MB_OK);
  	return FALSE;
	}

	GetDlgItemText(  hWnd, PDE_IDLE,  str, 19);
	t=atol( str);
	if( t<0)
	{ 
		MessageBox( hWinstance,
				"Legal values for idle are above zero!!",
				szAppName, MB_ICONEXCLAMATION|MB_OK);
  	return FALSE;
	}

	DisplayTime=dtime;
  DispLen=len;
	new_max=tb_max=t;
	Flags		=0;
	Grid    =IsDlgButtonChecked( hWnd, PDF_GRID);
	Flags  |=IsDlgButtonChecked( hWnd, PDF_SAVE)?FLAG_SAVECONFIG:0;
	Flags  |=IsDlgButtonChecked( hWnd, PDF_KEEP)?FLAG_KEEPSCALE :0;

  return TRUE;
}

#pragma argsused
int FAR PASCAL _export DlgProc( HWND 					hWnd,
												unsigned			iMessage,
												unsigned int	wParam,
												LONG					lParam)
{
	
	switch( iMessage)
	{
	case WM_INITDIALOG:
		SetTimer( hMainWnd, 1, DisplayTime, NULL);
		CheckDlgButton( hWnd, PDF_SAVE,  (Flags&FLAG_SAVECONFIG)?TRUE:FALSE);
		CheckDlgButton( hWnd, PDF_KEEP,  (Flags&FLAG_KEEPSCALE ));
    SetDlgItemInt(  hWnd, PDE_SPEED, DisplayTime, FALSE);
		SetDlgItemInt(  hWnd, PDE_SCALE, DispLen,  FALSE);
		SetDlgItemInt(  hWnd, PDE_IDLE,  new_max,  FALSE);
		CheckDlgButton( hWnd, PDF_GRID,  Grid);
		break;
	case WM_COMMAND:
		switch( wParam)
		{
		case PD_CANCEL:
			KillTimer( hMainWnd, 1);
			EndDialog( hWnd, 0);
			break;
		case PD_RESET:
			CheckDlgButton( hWnd, PDF_GRID,  TRUE);
			CheckDlgButton( hWnd, PDF_SAVE,  FALSE);
			CheckDlgButton( hWnd, PDF_KEEP,  FALSE);
	    SetDlgItemInt(  hWnd, PDE_SPEED, 1100, FALSE);
			SetDlgItemInt(  hWnd, PDE_SCALE, 256,  FALSE);
			SetDlgItemInt(  hWnd, PDE_IDLE,  1,    FALSE);
			break;
		case PD_OK:
			if( DialogConfigs( hWnd)==FALSE) break;
			KillTimer( hMainWnd, 1);
			EndDialog( hWnd, 0);
			break;
		case PD_SAVE:
    	if( DialogConfigs( hWnd)==FALSE) break;
			SaveConfigs( hMainWnd);
			KillTimer( hMainWnd, 1);
			EndDialog( hWnd, 0);
			break;
		default:
			AddTime( hMainWnd);
			return FALSE;
		}
  	break;
	default:
		AddTime( hMainWnd);
		return FALSE;
	}
  AddTime( hMainWnd);
	return TRUE;
}

