/* //////////////////////////////////////////////////////////////////////

  Module:   Xwinsave.h   - A Microsoft Windows screen saver using the
                           screen savers from the X11 program Xlock.c

  Author:   Perry K. Sloope

  See Xwinsave.cpp for acknowledgements, copyright and other information.

//////////////////////////////////////////////////////////////////////  */

#ifndef _XWINSAVE__
#define  _XWINSAVE__
#ifdef _WIN32
#define STRICK
#endif
#include <windows.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include "xlock.h"
#include "wxfake.h"
#include "xwinsav.rh"
#define u_char unsigned char
#define min(a,b) (((a) < (b)) ? (a) : (b))
#define max(a,b) (((a) > (b)) ? (a) : (b))

extern "C"
{
  void initflame(Window  win);
  void drawflame(Window win);
  void initpyro(Window  win);
  void drawpyro(Window win);
  void initqix(Window  win);
  void drawqix(Window win);
  void initswarm(Window  win);
  void drawswarm(Window win);
  void inithop(Window  win);
  void drawhop(Window win);
  void initrotor(Window  win);
  void drawrotor(Window win);
  void initworm(Window  win);
  void drawworm(Window win);
  void initspline(Window  win);
  void drawspline(Window win);
  void initgrav(Window  win);
  void drawgrav(Window win);
  void initgalaxy(Window  win);
  void drawgalaxy(Window win);
  void initkaleid(Window  win);
  void drawkaleid(Window win);
  void inithelix(Window  win);
  void drawhelix(Window win);
  int  usleep(unsigned long usec);
  void hsbramp(double h1, double s1, double b1, double h2, double s2, double b2,
                    int count, u_char *red, u_char *green, u_char *blue);
}

typedef struct {
    char       *cmdline_arg;
    void        (*lp_init) (Window);
    void        (*lp_callback) (Window);
    int         def_delay;
    int         def_batchcount;
    float       def_saturation;
    char       *desc;
}           LockStruct;


#define MAXSELECTION_NAMESZ 10
#define MAXSELECTION_SZ 100
#define INI_FILE "control.ini"
#define DEFSCRNSAVE "selection"  // Name of label in ini file for default screen saver.

#endif
