/* //////////////////////////////////////////////////////////////////////

  Module:   Xfake.h - Provides a Microsoft Windows emulation of a group
                      of X11 graphics functions.  These are used in
                      porting X11 programs to MS Windows.

  Author:   Perry K. Sloope

  Copyright (c) 1995 Perry K. Sloope

  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation.

  This file is provided AS IS with no warranties of any kind.  The author
  shall have no liability with respect to the infringement of copyrights,
  trade secrets or any patents by this file or any part thereof.  In no
  event will the author be liable for any lost revenue or profits or
  other special, indirect and consequential damages.

  Comments and additions should be sent to the author:

              sloope@blkbox.com  or
              Compuserve 71234,3632

  These represent a subset of the X11 graphics commands.  Since I am not
  currently an X windows or MS windows graphics expert, the output of
  these functions may not exactly match those of the actual X11 functions.
  In fact, some of these functions do nothing, they just were provided as
  placebos for portability.

  These are unlikely to be the most efficent implmentation of MS windows
  functions. I welcome any comments on this work.

//////////////////////////////////////////////////////////////////////  */

#ifndef _WXFAKE_HPP_
#define _WXFAKE_HPP_

#include "windows.h"
#include<stdio.h>
#define sleep(x) usleep(((x)*1000))
#include<stdlib.h>
#include<math.h>
#include<alloc.h>


typedef int Bool;

#define True  1
#define False 0
#define srandom srand
#define random rand

typedef struct
{
   int notta;
}  Display;

typedef struct
{
   int width, height;
}  XWindowAttributes;

typedef struct
{
   int width, height;
   HBRUSH hbrBackground;
   HWND hWnd;   /* Handle to window. */
   HDC  hdc;   /* Device context for FULL SCREEN. (Can get with CreateDC("DISPLAY",NULL,NULL,NULL); */
}  Window;

typedef Window Drawable;

typedef struct
{
   int width, height;
   int x,y;
} XPoint;

typedef struct
{
   int width, height;
   int x,y;
}  XRectangle;

typedef struct
{
   int width, heigth;
   int x,y;
} Screen;


typedef struct
{
   int width, heigth;
   int x,y;
} ColorMap;

typedef ColorMap *Colormap;

typedef struct
{
   int width, heigth;
   int x,y;
   long fgcolor, bgcolor;
} _XGC;

typedef _XGC *GC;

typedef struct
{
    long foreground, background;
} XGCValues;

typedef struct
{
   int x1, y1;
   int x2,y2;
} XSegment;

#define WhitePixel(dsp, screen) (RGB(255,255,255))
#define WhitePixelOfScreen(scr) (RGB(255,255,255))
#define BlackPixelOfScreen(scr) (0)

#ifdef __cplusplus
extern "C"
{
#endif

extern void XGetWindowAttributes(Display *dsp, Window win, XWindowAttributes *xwa);

extern Screen  *ScreenOfDisplay(Display *dsp, int screen);
extern Colormap DefaultColormapOfScreen(Screen *scr);

extern GC XCreateGC(Display *dsp, Window win, long GCForeground, XGCValues *xgcv);
extern void XSetForeground(Display *dsp, GC gc, long color);

extern void XFillRectangle(Display *dsp, Window win, GC gc, int x1, int y1,
                    int width, int height);

extern void XFillRectangles(Display *dsp, Window win, GC gc,
                     XRectangle rect[], int nrect);
extern void XDrawPoints(Display *dsp, Window win, GC bgGC, XPoint Xpoints[],
                        int nstars, int CoordModeOrigin);
extern int BlackPixel(Display *dsp, int screen);

extern void XClearWindow(Display *dsp, Window win);

extern void XDrawLine(Display *dsp, Window win, GC gc, int x1, int y1, int x2, int y2);

extern void XClearArea(Display *dsp, Window win, int x, int y, int width,
                int height, int expose);

extern void XDrawSegments(Display *dsp, Window win, GC gc, XSegment *s, int numsegs);

extern double rint (double num);

extern void bzero ( char arr[], long size);
extern int usleep(unsigned long usec);

#ifdef __cplusplus
}
#endif

//static int GCForeground = 15;
//static int GCBackground = 0;
// static int  CoordModeOrigin;
#define GCBackground 0
#define CoordModeOrigin 0
#define GCForeground 15

#endif
