/* //////////////////////////////////////////////////////////////////////

  Module:   Xfake.c - Provides a Microsoft Windows emulation of a group
                      of X11 graphics functions.  These are used in
                      porting X11 programs to MS Windows.

  Author:   Perry K. Sloope

  Copyright (c) 1995 Perry K. Sloope

  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation.

  This file is provided AS IS with no warranties of any kind.  The author
  shall have no liability with respect to the infringement of copyrights,
  trade secrets or any patents by this file or any part thereof.  In no
  event will the author be liable for any lost revenue or profits or
  other special, indirect and consequential damages.

  Comments and additions should be sent to the author:

              sloope@blkbox.com  or
              Compuserve 71234,3632

  These represent a subset of the X11 graphics commands.  Since I am not
  currently an X windows or MS windows graphics expert, the output of
  these functions may not exactly match those of the actual X11 functions.
  In fact, some of these functions do nothing, they just were provided as
  placebos for portability.

  These are unlikely to be the most efficent implmentation of MS windows
  functions. I welcome any comments on this work.

//////////////////////////////////////////////////////////////////////  */

#ifdef _WIN32
#define STRICK
#endif
#include <windows.h>
#include "wXfake.h"


// This function will only work correctly for full screen windows.
// Use GetClientRect to get proper behavior for bordered windows.
// Also see XClearWindow.

void XGetWindowAttributes(Display *dsp, Window win, XWindowAttributes *xwa)
{
   RECT r;
//   GetClientRect(win.hWnd,&r);
   GetWindowRect(win.hWnd,&r);
   xwa->height = r.bottom + 1;
   xwa->width  = r.right + 1;
}


Screen  *ScreenOfDisplay(Display *dsp, int screen)
{
    return (NULL);
}


Colormap DefaultColormapOfScreen(Screen *scr)
{
    return (NULL);
}


GC XCreateGC(Display *dsp, Window win, long GCForegrnd, XGCValues *xgcv)
{
    GC tmp = (GC)malloc(sizeof(_XGC));
    if (!tmp)
    {
//        closegraph();
        printf("Out of memory\n");
        exit(1);
    }
    tmp->fgcolor = xgcv->foreground;
    return (tmp);
}


void XSetForeground(Display *dsp, GC gc, long color)
{
   // setcolor(color);
    gc->fgcolor = color;
}


// MS Windows uses the current pen to draw the outline of a rectangle, so here
// we have to set the pen and brush to the same color.  We could have set
// the pen to default to the background color in main(), but then the little
// rectangles would be invisible since they consist only of what the pen
// draws.
void XFillRectangle(Display *dsp, Window win, GC gc, int x1, int y1,
                    int width, int height)
{
     HBRUSH hBrush;
     HPEN hpen;

     hBrush = SelectObject(win.hdc, CreateSolidBrush(gc->fgcolor));
     hpen = SelectObject(win.hdc, CreatePen(PS_INSIDEFRAME,0,gc->fgcolor));
     Rectangle (win.hdc, x1,y1,x1+width,y1+height);
     DeleteObject(SelectObject(win.hdc,hBrush));
     DeleteObject(SelectObject(win.hdc,hpen));
}


void XFillRectangles(Display *dsp, Window win, GC gc,
                     XRectangle rect[], int nrect)
{
    HBRUSH hBrush;
    HPEN hpen;
    int i;

    hBrush = SelectObject(win.hdc, CreateSolidBrush (gc->fgcolor));
    hpen = SelectObject(win.hdc, CreatePen(PS_INSIDEFRAME,0,gc->fgcolor));
    for (i = 0; i < nrect; i++)
    {
        Rectangle (win.hdc, rect[i].x, rect[i].y, rect[i].x+rect[i].width, rect[i].y+rect[i].height);
    }
    DeleteObject(SelectObject (win.hdc,hBrush));
    DeleteObject(SelectObject(win.hdc,hpen));
}


int BlackPixel(Display *dsp, int screen)
{
    return(0);
}


// This function will only work correctly for full screen windows.
// Use GetClientRect to get proper behavior for bordered windows.
// Also see XGetWindowAttributes().

void XClearWindow(Display *dsp, Window win)
{
    RECT rc;
//    GetClientRect(win.hWnd, &rc);
    GetWindowRect(win.hWnd, &rc);
    FillRect(win.hdc, &rc, (HBRUSH)win.hbrBackground);  // GetStockObject(BLACK_BRUSH));
}


void XClearArea(Display *dsp, Window win, int x, int y, int width,
                int height, int expose)
{
   _XGC gc;

   gc.fgcolor = GetBkColor(win.hdc);
   XFillRectangle(dsp, win, &gc, x,y,width, height);
}


void XDrawPoints(Display *dsp, Window win, GC gc, XPoint Xpoints[], int nstars,
                 int CrdModeOrigin)
{
    int i;

    for (i = 0; i < nstars; i++)
         SetPixel(win.hdc,Xpoints[i].x,Xpoints[i].y, gc->fgcolor);
}


void XDrawPoint(Display *dsp, Window win,  GC gc, int x, int y)
{
    SetPixel(win.hdc,x, y, gc->fgcolor);
}



void XDrawLine(Display *dsp, Window win, GC gc, int x1, int y1, int x2, int y2)
{
   HPEN hpen;

   hpen = SelectObject(win.hdc, CreatePen(PS_SOLID,0,gc->fgcolor));
   MoveToEx(win.hdc,x1,y1,NULL);
   LineTo(win.hdc,x2, y2);
   DeleteObject(SelectObject(win.hdc,hpen));
}

void XDrawSegments(Display *dsp, Window win, GC gc, XSegment *s, int numsegs)
{
   int i;
   HPEN hpen;
   hpen = SelectObject(win.hdc, CreatePen(PS_SOLID,0,gc->fgcolor));
   for (i = 0; i < numsegs; i++)
   {
      MoveToEx(win.hdc,s[i].x1,s[i].y1,NULL);
      LineTo(win.hdc,s[i].x2, s[i].y2);
   }
   DeleteObject(SelectObject(win.hdc,hpen));
}

/* Not X functions, but needed for the screensavers. */

void bzero ( char arr[], long size)
{
    long i;

    for( i = 0; i < size; i++)
       arr[i] = NULL;
}

double rint (double num)
{
    double r, n;

    r = modf(num, &n);
    if (r >= 0.5)
      return n + 1;
    else
      return n;
}
