/* //////////////////////////////////////////////////////////////////////

  Module:   ssclass.hpp - A simple screen saver class for building Microsoft
                          Windows screen savers.

  Author:   Perry K. Sloope

  Copyright (c) 1995 Perry K. Sloope

  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation.

  This file is provided AS IS with no warranties of any kind.  The author
  shall have no liability with respect to the infringement of copyrights,
  trade secrets or any patents by this file or any part thereof.  In no
  event will the author be liable for any lost revenue or profits or
  other special, indirect and consequential damages.

  Comments and additions should be sent to the author:

              sloope@blkbox.com  or
              Compuserve 71234,3632

  Useage:  This is an abstract base class, so you will need to inherit
  this into your own class.  Your class will need to define these functions:

  void ShowScreenSaver() - This function is called repeatedly and should
  draw the screen on each call in order to create an animation effect. You
  may need to add a pause function within this to get the proper effect.

  void InitSS() - This is called within the RunScreenSaver() function after the screen
  saver window has been created and shown. It can be used to initalize
  your screen saver function or draw the intial screen.  This was really
  put in here as part of the xwinsave program.  It was needed because of
  the manner in which the orginal xlock screen savers were designed. If you
  don't need it, then it can be ignored.

  Most screen savers have a configuration dialog that is called when the
  setup button is pressed in the Windows Control Panel DeskTop.
  If you want to use a configuration (setup) dialog for the screen saver,
  you will need to define the following function in your main file, but
  NOT as part of your class. (It should have global scope.)

  BOOL FAR PASCAL _export ConfigDlgFunc (HWND hDlg, UINT message,
                                                 UINT wParam, LONG lParam)

  The function name does not have to be ConfigDlgFunc.  In the constructor
  for your class, the following line of code should appear:

    pConfigDlg = ::ConfigDlgFunc;

  This sets a function pointer that the base class uses to call the
  configuration dialog.  Note that you must write a configuration dialog,
  not just declare the prototype above.

  See xwinsaver.cpp for an example on how to use this class.  Any comments
  on this class will be welcomed.  This class was cranked out one evening after
  work, so it is probably not the best (or even the correct way) to implement
  a screen saver.  But it did the job for me.

  I almost forgot.  Be sure that you include the following line in your
  .def file.

     DESCRIPTION    'SCRNSAVE :Program Description'

  Program Description is the text that appears in the screen saver list
  box in the Windows Control Panel DeskTop.  It will not recognize your
  program without this line.  Also, after compiling your program, rename it so
  that it has a scr extention instead of exe.

  See Readme.txt for more information.

///////////////////////////////////////////////////////////////////////////  */

#ifndef __SSCLASS_
#define __SSCLASS_

class ScreenSave
{
   protected:
      HWND hWnd;
      HDC hdc;

   public:
      HANDLE hInstance, hPrevInstance;
      LPSTR lpszCmdLine;
      int nCmdShow;
      WNDCLASS wndclass;
      char *AppName;
      char *DlgName;
      BOOL FAR PASCAL (* pConfigDlg)(HWND, UINT, UINT, LONG);

      ScreenSave(char *AppNm, HANDLE hInst, HANDLE hPrevInst, LPSTR CmdLine,
                 int CmdShow);
      ~ScreenSave(){delete[] AppName;}
      virtual char GetCmdLine();
      virtual int ShowConfig(char *DlgName);
      virtual void ShowScreenSaver() = 0;
      virtual int RunScreenSaver();
      virtual void InitSS(){};
};

#endif
