/* //////////////////////////////////////////////////////////////////////

  Module:   ssclass.cpp - A simple screen saver class for building Microsoft
                          Windows screen savers.

  Author:   Perry K. Sloope

  Copyright (c) 1995 Perry K. Sloope

  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation.

  This file is provided AS IS with no warranties of any kind.  The author
  shall have no liability with respect to the infringement of copyrights,
  trade secrets or any patents by this file or any part thereof.  In no
  event will the author be liable for any lost revenue or profits or
  other special, indirect and consequential damages.

  Comments and additions should be sent to the author:

              sloope@blkbox.com  or
              Compuserve 71234,3632

  Useage:  See ssclass.h for instructions.  See xwinsaver.cpp for an example
           on using the class.

  This was built and compiled using Borland 4.5 C++.  However I tried to design
  the code so that it was independent of the compiler.  It should be possible
  to compile this using any C++ compiler that can produce MS Windows 3.1
  executables.  No special library files or dlls are required other than
  those needed to build any MS Windows program.

//////////////////////////////////////////////////////////////////////////  */
#ifdef _WIN32
#define STRICK
#endif
#include <windows.h>
#include <string.h>
#include <ctype.h>
#include "ssclass.hpp"


ScreenSave::ScreenSave(char *AppNm, HANDLE hInst, HANDLE hPrevInst,
                       LPSTR CmdLine, int CmdShow)
{
   AppName = new char[strlen(AppNm)+1];
   strcpy(AppName,AppNm);
   hInstance = hInst;
   hPrevInstance = hPrevInst;
   lpszCmdLine = CmdLine;
   nCmdShow = CmdShow;
   pConfigDlg = NULL;
   DlgName = NULL;
}



int ScreenSave::ShowConfig(char *DlgName)
{
     static FARPROC ConfigDlgProc;

     if (pConfigDlg == NULL)
        return FALSE;
     ConfigDlgProc = MakeProcInstance ((FARPROC)pConfigDlg, hInstance);
     DialogBox (hInstance, DlgName, NULL, ConfigDlgProc);
     return TRUE;
}


char ScreenSave::GetCmdLine()
{
    char cmdarg = toupper(lpszCmdLine[0]);
    if((cmdarg == '/') || (cmdarg == '-'))
        cmdarg = toupper(lpszCmdLine[1]);
    return cmdarg;
}



LONG FAR PASCAL _export ScrnSavProc (HWND hwnd, UINT message,
                                                 UINT wParam, LONG lParam)
{
     static firsttime = 1;
     switch (message)
     {
          case WM_SIZE:
//               cxClient = LOWORD (lParam) ;
//               cyClient = HIWORD (lParam) ;
               return 0 ;
          case WM_ACTIVATE:
          case WM_ACTIVATEAPP:
               if ( wParam != 0 )
                   break;

          case WM_MOUSEMOVE:
          case WM_KEYDOWN:
          case WM_KEYUP:
          case WM_SYSKEYDOWN:
          case WM_LBUTTONDOWN:
          case WM_MBUTTONDOWN:
          case WM_RBUTTONDOWN:
             if (firsttime)
               firsttime = 0;
             else
               PostMessage(hwnd, WM_CLOSE, 0, 0L);
             break;
          case WM_DESTROY:
               PostQuitMessage (0) ;
               return 0 ;
      }
      return DefWindowProc (hwnd, message, wParam, lParam) ;
}




int ScreenSave::RunScreenSaver()
{
     MSG msg;

     if(GetCmdLine() != 'S')
     {
        if (ShowConfig(DlgName))
          return TRUE;
     }

     if (!hPrevInstance)
     {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW | CS_SAVEBITS;
          wndclass.lpfnWndProc   = ::ScrnSavProc;
          wndclass.cbClsExtra    = 0;
          wndclass.cbWndExtra    = 0;
          wndclass.hInstance     = hInstance;
          wndclass.hIcon         = NULL;
          wndclass.hCursor       = NULL; // Don't need no stinking cursor.
          wndclass.hbrBackground = GetStockObject (BLACK_BRUSH);
          wndclass.lpszMenuName  = NULL;
          wndclass.lpszClassName = AppName;

          RegisterClass (&wndclass);
     }

     hWnd = CreateWindowEx (WS_EX_TOPMOST,AppName, "",
                          WS_MAXIMIZE | WS_POPUP,
                          0,0,GetSystemMetrics(SM_CXSCREEN),
                          GetSystemMetrics(SM_CYSCREEN),
                          NULL, NULL, hInstance, NULL);

     ShowWindow (hWnd, nCmdShow);
     UpdateWindow (hWnd);
     while (ShowCursor(FALSE) >= 0);  // Hide cursor.
     hdc = CreateDC("DISPLAY",NULL,NULL,NULL);
     InitSS();
     for(;;)
     {
         if (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE))
         {
             if (msg.message == WM_QUIT)
                  break ;

             TranslateMessage (&msg) ;
             DispatchMessage (&msg) ;
         }
         else
         {
            ShowScreenSaver();
         }
     }
     DeleteDC (hdc);
     while (ShowCursor(TRUE) < 0);
     return msg.wParam ;
}

