/*** sioerror.c ***/

#include <windows.h>
#include "sioerror.h"
#include "term.h"

extern HWND hMainWnd;
static char Text[40];

#define NBR_ERR_MSG 21

static char *ErrorText[NBR_ERR_MSG] = {
  /*  0 */      "No error.",
  /* -1 */      "Timeout waiting for I/O.",
  /* -2 */      "Port not enabled.",
  /* -3 */      "No buffer available.",
  /* -4 */      "No such port.",
  /* -5 */      "Expecting 'S', 'C', or 'R' as 2nd argument.",
  /* -6 */      "Expecting 'A', 'C', or 'D' as 2nd argument.",
  /* -7 */      "Bad parity code.",
  /* -8 */      "Bad stop bits code.",
  /* -9 */      "Bad wordlength code.",
 /* -10 */      "Bad buffer size code.",
 /* -11 */      "Bad baud rate code.",
 /* -12 */      "LOOP_BACK test fails.",
 /* -13 */      "UART undefined.",
 /* -14 */      "Bad or missing UART.",
 /* -15 */      "Port already enabled.",
 /* -16 */      "ISR already in use",
 /* -17 */      "No such IRQ",
 /* -18 */      "ISR limit exceeded",
 /* -19 */      "Illegal Modification!",
 /* -20 */      "Previous fatal error"};

void SioError(int Code,char *FunMsg)
{int Index = 0;
 if(Code==0) Index = 0;
 else
   {if(Code<(0-NBR_ERR_MSG))
      {
       wsprintf(Text,"No such error code = %d",Code);
       MessageBox(hMainWnd,Text,FunMsg,
         MB_TASKMODAL | MB_ICONEXCLAMATION | MB_OK);
      }
    else
      {Index = 0 - Code;
       MessageBox(hMainWnd,ErrorText[Index],FunMsg,
         MB_TASKMODAL | MB_ICONEXCLAMATION | MB_OK);
      }
   }
} /* end SioError */