
.NOLIST

;-----------------------------------------------------------------------
;		HILEVEL.INC - Macros for HiLevel 2.1 files.
;		Copyright (c) 1993 Eric Grass
;-----------------------------------------------------------------------


IFNB	@CurSeg
	ECHO	HILEVEL.INC should not be included inside a segment declaration.
ENDIF

		EXTERNDEF	C	_aNchkstk:NEAR
		EXTERNDEF	C	_aFchkstk:FAR


;-----------------------------------------------------------------------
;	The hCall macro pushes the specified arguments onto the stack
;	and calls the specified procedure.
;-----------------------------------------------------------------------

hCall		MACRO	Args:VARARG
		LOCAL	firstpass, procname, arg
		firstpass = 1
		FOR	arg, <Args>
			IF	firstpass EQ 0
				PUSH	arg
			ELSE
				procname TEXTEQU <arg>
				firstpass = 0
			ENDIF
		ENDM
		CALL	procname
		ENDM


;-----------------------------------------------------------------------
;	HiLevel Prologue Macros

;	The following macros are used to generate prologue and epilogue
;	code.
;-----------------------------------------------------------------------



hPrologue	MACRO	procname, flag, parmbytes, localbytes, reglist, userparms
		LOCAL	?DoPrologue, ?LoadDS, ?CheckStack, ?IncBP

		?DoPrologue = 0
		?LoadDS = 0
		?CheckStack = 0
		?IncBP = 0
		IFNB	<userparms>
			FOR	par, <userparms>
				IFIDN	<par>, <LOADDS>
					?LoadDS = 1
				ENDIF
				IFIDN	<par>, <NOLOADDS>
					?LoadDS = 0
				ENDIF
				IFIDN	<par>, <CHECKSTACK>
					?CheckStack = 1
				ENDIF
				IFIDN	<par>, <NOCHECKSTACK>
					?CheckStack = 0
				ENDIF
				IFIDN	<par>, <INCBP>
					IF	flag AND 20H
						?IncBP = 1
					ENDIF
				ENDIF
				IFIDN	<par>, <NOINCBP>
					?IncBP = 0
				ENDIF
				IFIDN	<par>, <FORCEFRAME>
					?DoPrologue = 1
				ENDIF
			ENDM
		ENDIF
		?DoPrologue = ?DoPrologue OR ?IncBP OR ?LoadDS OR ?CheckStack OR (localbytes NE 0) OR (parmbytes NE 0)
		IF	?DoPrologue EQ 0
			EXITM	<0>
		ENDIF
		IF	?LoadDS EQ 1
			PUSH	DS
			POP	AX
			NOP
		ENDIF
		IF	?IncBP EQ 1
			INC	BP
		ENDIF
		PUSH	BP
		MOV	BP, SP
		IF 	?LoadDS EQ 1
			PUSH	DS
			MOV	DS, AX
		ENDIF
		IF	?CheckStack EQ 1
			MOV	AX, localbytes
			% IFIDN	<_TEXT>, <@CurSeg>
				CALL	_aNchkstk
			ELSE
				CALL	_aFchkstk
			ENDIF
		ELSE
			IF	localbytes NE 0
				SUB	SP, localbytes
			ENDIF
		ENDIF
		IFNB	reglist
			FOR	reg, reglist
				PUSH	reg
			ENDM
		ENDIF
		EXITM	<localbytes>
		ENDM


hEpilogue	MACRO	procname, flag, parmbytes, localbytes, reglist, userparms
		LOCAL	?DoEpilogue, ?LoadDS, ?CheckStack, ?IncBP

		?DoEpilogue = 0
		?LoadDS = 0
		?CheckStack = 0
		?IncBP = 0
		IFNB	<userparms>
			FOR	par, <userparms>
				IFIDN	<par>, <LOADDS>
					?LoadDS = 1
				ENDIF
				IFIDN	<par>, <NOLOADDS>
					?LoadDS = 0
				ENDIF
				IFIDN	<par>, <CHECKSTACK>
					?CheckStack = 1
				ENDIF
				IFIDN	<par>, <NOCHECKSTACK>
					?CheckStack = 0
				ENDIF
				IFIDN	<par>, <INCBP>
					IF	flag AND 20H
						?IncBP = 1
					ENDIF
				ENDIF
				IFIDN	<par>, <NOINCBP>
					?IncBP = 0
				ENDIF
				IFIDN	<par>, <FORCEFRAME>
					?DoEpilogue = 1
				ENDIF
			ENDM
		ENDIF
		?DoEpilogue = ?DoEpilogue OR ?IncBP OR ?LoadDS OR ?CheckStack OR (localbytes NE 0) OR (parmbytes NE 0)
		IF	?DoEpilogue EQ 0
			RET
			EXITM
		ENDIF
		IFNB	reglist
			FOR	reg, reglist
				POP	reg
			ENDM
		ENDIF
		IF	?LoadDS
			DEC	BP
			DEC	BP
			MOV	SP, BP
			POP	DS
			POP	BP
		ELSE
			MOV	SP,BP
			POP	BP
		ENDIF
		IF	?IncBP
			DEC	BP
		ENDIF
		IF 	flag AND 10H
			RET
		ELSE
			IF	parmbytes NE 0
				RET	parmbytes
			ELSE
				RET
			ENDIF
		ENDIF
		ENDM

.LIST
