/* *******************************************************************

The Oracle SQL Class Library Version 1.0,
Author: Sergei Kuchin
Copyright (C) Mosakin Corp., 1995
This library is free software.  Permission to use, copy,
modify and redistribute the Oracle SQL class library for any
purpose is hereby granted without fee, provided that the
above copyright notice appear in all copies.


******************************************************************* */
#ifndef __OSCL_DEF_H
#define __OSCL_DEF_H

#include <oscl_idf.h>

// ------------- Macros to define variables and select items -------------

#define DOUBLE_ITEM(Name)       DEFINE_NUM("",Name,TDouble,double)
#define FLOAT_ITEM(Name)        DEFINE_NUM("",Name,TFloat,float)
#define LONGINT_ITEM(Name)      DEFINE_NUM("",Name,TLongInt,long)
#define SIGNEDCHAR_ITEM(Name)   DEFINE_NUM("",Name,TSignedChar,sb1)
#define SHORTINT_ITEM(Name)     DEFINE_NUM("",Name,TShortInt,short)
#define INT_ITEM(Name)          DEFINE_NUM("",Name,TOInt,int)
#define UINT_ITEM(Name)         DEFINE_NUM("",Name,TUnsignedInt,uword)

#define DOUBLE_VAR(Name)       DEFINE_NUM(":",Name,TDouble,double)
#define FLOAT_VAR(Name)        DEFINE_NUM(":",Name,TFloat,float)
#define LONGINT_VAR(Name)      DEFINE_NUM(":",Name,TLongInt,long)
#define SIGNEDCHAR_VAR(Name)   DEFINE_NUM(":",Name,TSignedChar,sb1)
#define SHORTINT_VAR(Name)     DEFINE_NUM(":",Name,TShortInt,short)
#define INT_VAR(Name)          DEFINE_NUM(":",Name,TOInt,int)
#define UINT_VAR(Name)         DEFINE_NUM(":",Name,TUnsignedInt,uword)

#define DOUBLE_ITEM_VECT(Name,VectSize)       \
  NUM_VECT("",Name,TDouble,double,VectSize)
#define FLOAT_ITEM_VECT(Name,VectSize)        \
  NUM_VECT("",Name,TFloat,float,VectSize)
#define LONGINT_ITEM_VECT(Name,VectSize)      \
  NUM_VECT("",Name,TLongInt,long,VectSize)
#define SIGNEDCHAR_ITEM_VECT(Name,VectSize)   \
  NUM_VECT("",Name,TSignedChar,sb1,VectSize)
#define SHORTINT_ITEM_VECT(Name,VectSize)     \
  NUM_VECT("",Name,TShortInt,short,VectSize)
#define INT_ITEM_VECT(Name,VectSize)          \
  NUM_VECT("",Name,TOInt,int,VectSize)
#define UINT_ITEM_VECT(Name,VectSize)         \
  NUM_VECT("",Name,TUnsignedInt,uword,VectSize)

#define DOUBLE_VAR_VECT(Name,VectSize)       \
  NUM_VECT(":",Name,TDouble,double,VectSize)
#define FLOAT_VAR_VECT(Name,VectSize)        \
  NUM_VECT(":",Name,TFloat,float,VectSize)
#define LONGINT_VAR_VECT(Name,VectSize)      \
  NUM_VECT(":",Name,TLongInt,long,VectSize)
#define SIGNEDCHAR_VAR_VECT(Name,VectSize)   \
  NUM_VECT(":",Name,TSignedChar,sb1,VectSize)
#define SHORTINT_VAR_VECT(Name,VectSize)     \
  NUM_VECT(":",Name,TShortInt,short,VectSize)
#define INT_VAR_VECT(Name,VectSize)          \
  NUM_VECT(":",Name,TOInt,int,VectSize)
#define UINT_VAR_VECT(Name,VectSize)         \
  NUM_VECT(":",Name,TUnsignedInt,uword,VectSize)

#define STRING_ITEM(Name,StrSize)   DEFINE_STRING("",Name,StrSize,char)
#define STRING_VAR(Name,StrSize)    DEFINE_STRING(":",Name,StrSize,char)

#define STRING_ITEM_VECT(Name,StrSize,VectSize)   \
  STRING_VECT("",Name,StrSize,VectSize,char)
#define STRING_VAR_VECT(Name,StrSize,VectSize)    \
  STRING_VECT(":",Name,StrSize,VectSize,char)

#define LONG_STRING_ITEM(Name,StrSize)      \
  DEFINE_LONG_STRING("",Name,StrSize,TLongString,type_TLongString)
#define LONG_BYTE_STRING_ITEM(Name,StrSize) \
  DEFINE_LONG_STRING("",Name,StrSize,TLongByteString,type_TLongByteString)

#define LONG_STRING_VAR(Name,StrSize)     \
  DEFINE_LONG_STRING(":",Name,StrSize,TLongString,type_TLongString)
#define LONG_BYTE_STRING_VAR(Name,StrSize) \
  DEFINE_LONG_STRING(":",Name,StrSize,TLongByteString,type_TLongByteString)


#define ITEM_OF_TYPE(Type,Name) OBJ_OF_TYPE(Type,"",Name)
#define VAR_OF_TYPE(Type,Name)  OBJ_OF_TYPE(Type,":",Name)

// --------- Macros to create typedefs ---------

#define TYPEDEF_STRING(TypeName,StrSize) \
  TYPEDEF_STR(TypeName,StrSize,char)

#ifdef __BCPLUSPLUS__

#define TYPEDEF_LONG_STRING(TypeName,StrSize) \
  TYPEDEF_LONG_STR(TypeName,StrSize,TLongString,type_TLongString)
#define TYPEDEF_LONG_BYTE_STRING(TypeName,StrSize) \
  TYPEDEF_LONG_STR(TypeName,StrSize,TLongByteString,type_TLongByteString)

#else

#define TYPEDEF_LONG_STRING(TypeName,StrSize) \
  TYPEDEF_LONG_STR(TypeName,StrSize,char,type_TLongString,extLongVarChar)
#define TYPEDEF_LONG_BYTE_STRING(TypeName,StrSize) \
  TYPEDEF_LONG_STR(TypeName,StrSize,ub1,type_TLongByteString,extLongVarRaw)

#endif

#define TYPEDEF_STRING_VECT(TypeName,StrSize,VectSize)  \
  TYPEDEF_STR_VECT(TypeName,StrSize,VectSize,char)


#define TYPEDEF_DOUBLE_VECT(TypeName,VectSize)   \
  TYPEDEF_NUM_VECT(TypeName,VectSize,TDouble,double)
#define TYPEDEF_FLOAT_VECT(TypeName,VectSize)   \
  TYPEDEF_NUM_VECT(TypeName,VectSize,TFloat,float)
#define TYPEDEF_LONGINT_VECT(TypeName,VectSize)   \
  TYPEDEF_NUM_VECT(TypeName,VectSize,TLongInt,long)
#define TYPEDEF_SIGNEDCHAR_VECT(TypeName,VectSize)  \
  TYPEDEF_NUM_VECT(TypeName,VectSize,TSignedChar,sb1)
#define TYPEDEF_SHORTINT_VECT(TypeName,VectSize)   \
  TYPEDEF_NUM_VECT(TypeName,VectSize,TShortInt,short)
#define TYPEDEF_INT_VECT(TypeName,VectSize)   \
  TYPEDEF_NUM_VECT(TypeName,VectSize,TOInt,int)
#define TYPEDEF_UINT_VECT(TypeName,VectSize)   \
  TYPEDEF_NUM_VECT(TypeName,VectSize,TUnsignedInt,uword)


// ------------- Select item list  -------------

#define BEGIN_SELECT_LIST(Stm)                                       \
  short ___##Stm##SelectListMode(void){return 0;};                   \
  short ___##Stm##SelectListVectSize(void){return 1;};               \
  PHostVarArray ___##Stm##SelectList(void)                           \
    {return new THostVarArray(SHOULD_DELETE,

#define ITEM(Name) ___##Name##Init()

#define END_SELECT_LIST  END_OF_LIST);}

#define DEFINE_EMPTY_SELECT_LIST(Stm)                         \
  short ___##Stm##SelectListVectSize(void){return 1;};        \
  short ___##Stm##SelectListMode(void){return 1;};            \
  PHostVarArray ___##Stm##SelectList(void){return 0;}

#define DEFINE_DEFAULT_SELECT_LIST(Stm,VectSize)              \
  short ___##Stm##SelectListVectSize(void){return VectSize;}; \
  short ___##Stm##SelectListMode(void){return 2;};            \
  PHostVarArray ___##Stm##SelectList(void){return 0;}


// ----------------- Host variable list -------------------------------

#define BEGIN_VAR_LIST(Stm)                                           \
  PHostVarArray ___##Stm##VarList(void)                               \
    {return new THostVarArray(SHOULD_DELETE,

#define VAR(Name) ___##Name##Init()

#define END_VAR_LIST  END_OF_LIST);}

#define DEFINE_EMPTY_VAR_LIST(Stm) \
  PHostVarArray ___##Stm##VarList(void){return 0;}


// --------------------- SQL Statement  ------------------------------------

#define DEFINE_STM(Stm,StmText)                                        \
  PStm Stm;                                                            \
                                                                       \
  short Stm##Open(PConnect db)                                         \
   {Stm=0; int rc;                                                     \
    if(___##Stm##SelectListMode()!=2){                                 \
     Stm=new TStm(db,StmText,                                          \
                     SHOULD_DELETE,                                    \
                      ___##Stm##SelectList(),                          \
                      ___##Stm##VarList()                              \
              );                                                       \
    }else{                                                             \
     Stm=new TStm(db,StmText,                                          \
                      ___##Stm##SelectListVectSize(),                  \
                         SHOULD_DELETE,                                \
                      ___##Stm##VarList()                              \
              );                                                       \
    }                                                                  \
    rc=Stm->Parse();                                                   \
    return rc;                                                         \
   };                                                                  \
  short Stm##Open(POCursor cur)                                        \
   {Stm=0;                                                             \
    if(___##Stm##SelectListMode()!=2){                                 \
     Stm=new TStm(cur,StmText,                                         \
                     SHOULD_DELETE,                                    \
                      ___##Stm##SelectList(),                          \
                      ___##Stm##VarList()                              \
              );                                                       \
    }else{                                                             \
     Stm=new TStm(cur,StmText,                                         \
                      ___##Stm##SelectListVectSize(),                  \
                         SHOULD_DELETE,                                \
                      ___##Stm##VarList()                              \
              );                                                       \
    }                                                                  \
    return Stm->Parse();                                               \
   };                                                                  \
                                                                       \
  void Stm##Close(void){delete Stm; Stm=0;}

// --------------- SELECT  Statement ----------------

#define DEFINE_SELECT_STM(Stm,StmText,InternalVectSize)                \
  PSelectStm Stm;                                                      \
                                                                       \
  short Stm##Open(PConnect db)                                         \
   {Stm=0;                                                             \
    if(___##Stm##SelectListMode()!=2){                                 \
     Stm=new TSelectStm(db,StmText,                                    \
                     SHOULD_DELETE,                                    \
                     InternalVectSize,                                 \
                      ___##Stm##SelectList(),                          \
                      ___##Stm##VarList()                              \
              );                                                       \
    }else{                                                             \
     Stm=new TSelectStm(db,StmText,                                    \
                         SHOULD_DELETE,                                \
                         InternalVectSize,                             \
                      ___##Stm##VarList()                              \
              );                                                       \
    }                                                                  \
    return Stm->Parse();                                               \
   };                                                                  \
  short Stm##Open(PSelectCursor cur)                                   \
   {Stm=0;                                                             \
    if(___##Stm##SelectListMode()!=2){                                 \
     Stm=new TSelectStm(cur,StmText,                                   \
                        SHOULD_DELETE,                                 \
                        InternalVectSize,                              \
                        ___##Stm##SelectList(),                        \
                        ___##Stm##VarList()                            \
              );                                                       \
    }else{                                                             \
     Stm=new TSelectStm(cur,StmText,                                   \
                        SHOULD_DELETE,                                 \
                        InternalVectSize,                              \
                        ___##Stm##VarList()                            \
              );                                                       \
    }                                                                  \
    return Stm->Parse();                                               \
   };                                                                  \
                                                                       \
  void Stm##Close(void){delete Stm; Stm=0;}

#endif
