#ifndef __VARIABLE_H_
#define __VARIABLE_H_

/*  Simple BASIC-like language. double, double[] and char[] (strings) are
supported.
*/

#include "general\simple.h"
#include "general\kh_error.h"
#include <string.h>
#include "general\strdup.h"

// We use dynamically allocated arrays of double. Format is:
// d[0] == number of elements, d[1 - n] contains data.
enum VAR_TYPE { REAL = 1, STR, ARRAY };

struct _export Variable
    {
    VAR_TYPE type;
    char* name;
    union
        {
        double d;
        char* s;
        double* da;
	};
    Variable(double D, char* s);
    Variable(char*  S, char* nm);
    Variable(double* D, char* s);
    Variable(int dim, char* s);
    ~Variable();
    };

#endif __VARIABLE_H_