#ifndef __SLANG_FILES_H_
#define __SLANG_FILES_H_

/*  This class inherits Slang functionality and has additional functions:
		INPUT - BASIC-like input operator, able to handle both user input
			and ASCII file data
		PRINT - BASIC-like print operator, output could be directed to
			screen (window) or to the file
		OPEN, READ, WRITE, CLOSE, EOFILE, FILELEN, SEEK, RENAME,
		SETMODE, GETPOS, REMOVE, NEXT_LINE - file operating functions,
			see manual for details
*/

#include "kh_slang\slang.h"

enum { SLANG_PRINT = 1000, SLANG_INPUT,
	SLANG_OPEN, SLANG_READ, SLANG_WRITE, SLANG_CLOSE, SLANG_EOFILE,
	SLANG_FILELEN, SLANG_SEEK, SLANG_RENAME, SLANG_SETMODE,
	SLANG_GETPOS, SLANG_REMOVE, SLANG_NEXT_LINE
///
	};

class _export SlangFiles : public Slang    // File and i/o functions added
	{
	public:
		int in_file, out_file; // Handles of files for input and output

	public:
		SlangFiles();

		virtual void further_processing();
        virtual double further_math(double x);

		void slang_open();            // Open file
		void slang_read();            // Read from file
		void slang_write();           // Write to file
		void slang_close();           // Close the file
		int slang_eof();              // Detect end of file
		ulong slang_filelength();     // Return length of file
		void slang_lseek();           // Position file cursor
		void slang_rename();          // Rename file
		void slang_setmode();         // Change file mode
		ulong slang_tell();           // Get file pos
		void slang_unlink();          // Remove file
		void next_line();             // Go to next line in file

		void input();              // General input function
		virtual void print();              // General output function

// This functions will be overloaded in child class (which is Windows-aware)
		virtual int printf(double argument)
			{ return ::printf("%f", argument); }
		virtual int printf(char * argument)
			{ return ::printf(argument); }
		virtual int printf(char * format, double argument)
			{ return ::printf(format, argument); }

		virtual void Gets(char* str, char* prompt) // For input function
			{ printf(prompt); gets(str); }
	 };

#endif __SLANG_FILES_H_




