#include "kh_slang\s_files.h"
#include <io.h>

SlangFiles::SlangFiles() : Slang()
	{
	/////////////
	commands TABLE[] =  {
		{ "PRINT",  SLANG_PRINT    },
		{ "INPUT",  SLANG_INPUT    },
		{ "PAUSE", SLANG_PAUSE     },
///
		{ "REMOVE", SLANG_REMOVE   },
		{ "RENAME", SLANG_RENAME   },
		{ "SEEK", SLANG_SEEK       },
		{ "SETMODE", SLANG_SETMODE },
		{ "WRITE", SLANG_WRITE      },
		{ "NEXT_LINE", SLANG_NEXT_LINE },
		{ "OPEN", SLANG_OPEN       },
		{ "READ", SLANG_READ       },
		{ "CLOSE", SLANG_CLOSE     },
		{ "EOF", SLANG_EOFILE      },
		{ "FILELEN", SLANG_FILELEN },
		{ "GETPOS", SLANG_GETPOS   }
	};
	FuncTable->init(TABLE);
	in_file = out_file = -1;
	}
///////////////////////////////////////////////////////////////////////////
void  SlangFiles::further_processing()
	{
	switch(tok)  // If it is operator or subroutine call
		{
		case SLANG_PRINT:    print();    break;
		case SLANG_INPUT:    input();    break;

		case SLANG_OPEN: slang_open(); break;   // Open file
		case SLANG_READ: slang_read(); break;   // Read from file
		case SLANG_WRITE: slang_write(); break; // Write to file
		case SLANG_CLOSE: slang_close(); break; // Close file
		case SLANG_EOFILE:   slang_eof();  break;  // EOF reached
		case SLANG_FILELEN: slang_filelength(); break; // End of file
		case SLANG_SEEK: slang_lseek(); break;  // Move position in file
		case SLANG_RENAME: slang_rename(); break; // Rename file
		case SLANG_SETMODE: slang_setmode(); break; // Set access mode
		case SLANG_GETPOS: slang_tell(); break; // Get current pos. in file
		case SLANG_REMOVE: slang_unlink(); break; // Delete file
		case SLANG_NEXT_LINE: next_line(); break;
		case SLANG_GETTOKEN: slang_get_token(); break; // Get token from string
		case SLANG_PUTTOKEN: slang_put_token(); break; // Put token to string end
		}
	}
///////////////////////////////////////////////////////
void SlangFiles::slang_open()    // open(x, "work.txt", 1 + 3)
	{
    get_token();    // "("
    if(*token != '(')
	{ serror(1); return; }

    get_token();   // Name of handler variable
    if(token_type != VARIABLE)
	{ serror(2); return; }
    char* name = strdup(token);

    get_token();   // ','
    if(*token != ',')
	{ serror(0); return; }
    get_token();   // File name

    char* file_name;
    switch(token_type)
	{
	case QUOTE:
	    file_name = strdup(token);
	    break;
	case VARIABLE:
	    file_name = variables->find(token)->s;
	    if(file_name == NULL)
		{ delete name; serror(4); return; }
	    file_name = strdup(variables->find(token)->s);
	    break;
	default:
	    delete name;
	    serror(26);
	    return;
	}

    get_token(); // ","
    if(*token != ',')
	{ delete name; delete file_name; serror(0); return; }

    double value;   // Access string
    get_exp(&value);

    int handle = open(file_name, (int)value);
    variables->assign((double)handle, name);
    delete name;
    delete file_name;
    }
//////////////////////////
void SlangFiles::slang_read()     // read(handle, buf <, len>)
	{
	get_token();    // "("
	if(*token != '(')
	{ serror(1);	return;	}
	get_token();   // Name of handler variable

	Variable* name;
    if(token_type != VARIABLE || !(name = variables->find(token)))
	{ serror(4); return; }

    get_token(); // ","
    if(*token != ',')
	{ serror(0); return; }

    get_token();   // Buf. name
    if(token_type != VARIABLE)
	{ serror(4); return; }
	char* buf_name = strdup(token);

    get_token(); // "," or ")"
    double value;              // Length
    switch(*token)
	{
	case ',':
	    if(get_exp(&value))
		{ delete buf_name; serror(0); return; }
	    break;
	case ')':
	    value = DEF_STRING_LEN;
	    break;
	default:
	    serror(0);
	    return;
	}
    char* buf = new char[value + 1];

    int handle = name->d;
    for(int i = 0; i < value && !eof(handle); i++)
	{
	read(handle, buf + i, 1);
	if(buf[i] == '\n')
	    {
	    if(buf[i - 1] == '\r')
		i--;
	    break;
	    }
	}
    buf[i] = '\0';
    variables->assign(buf, buf_name);
    delete buf_name;
    delete buf;
    }
//////////////////////////
void SlangFiles::slang_write()  // write(handle, buf <, len>)
    {
    get_token();    // "("
    if(*token != '(')
	{ serror(1);	return;	}
    get_token();
    Variable* name;
    if(token_type != VARIABLE || !(name = variables->find(token)))
	{ serror(4); return; }

    get_token(); // ","
    if(*token != ',')
	{ serror(0); return; }

    get_token();   // Buf. name
    Variable* buf_name;
    switch(token_type)
	{
	case VARIABLE:
	    if(!(buf_name = variables->find(token)))
		{ serror(4); return; }
	    break;
	case QUOTE:
	    buf_name = variables->assign(token, "retval");
//	    buf_name = variables->find("retval");
	    break;
	default:
	    serror(4);
	    return;
	}

    get_token(); // "," or ")"
    double value;              // Length
    switch(*token)
	{
	case ',':
		if(get_exp(&value))
		{ serror(0); return; }
	    break;
	case ')':
	    value = strlen(buf_name->s);
	    break;
	default:
	    serror(0);
	    return;
	}

    write(name->d, buf_name->s, value);
    get_token();   // ";" or not
    if(*token == ';')
	write(name->d, "\r\n", 1);
    else
	putback();
    }

//////////////////////////
void SlangFiles::slang_close()          // close
    {
    get_token();    // "("
    if(*token != '(')
	{ serror(1);	return;	}
    get_token();   // Name of handler variable
    Variable* v;
    if(!(v = variables->find(token)))
	{ serror(21); return; }
    close(v->d);
    }
//////////////////////////
int SlangFiles::slang_eof()       // eof(handle)
	{
//    get_token();    // "("
//    if(*token != '(')
//	{ serror(1);	return -1;	}
//    get_token();   // Name of handler variable
	Variable* v;
	if(!(v = variables->find(token)))
	{ serror(21); return -1; }
	return eof(v->d);
	}
//////////////////////////
ulong SlangFiles::slang_filelength()    // filelength(handle)
    {
//    get_token();    // "("
//    if(*token != '(')
//	{ serror(1);	return -1;	}
//    get_token();   // Name of handler variable
    Variable* v;
    if(!(v = variables->find(token)))
	{ serror(21); return -1; }
    return filelength(v->d);
    }
//////////////////////////
void SlangFiles::slang_lseek()     // seek(handle, offset, fromwhere)
	{
	get_token();    // "("
	if(*token != '(')
	{ serror(1);	return;	}
	get_token();   // Name of handler variable
	if(token_type != VARIABLE)
	{ serror(2); return; }
    char* name = strdup(token);
    double offset, from;
    get_token();
    if(*token != ',')
	{ serror(0);	return;	}
    get_exp(&offset);
    if(*token != ',')
	{ serror(0);	return;	}
    get_exp(&from);
    Variable* v;
	if(!(v = variables->find(name)))
	{ serror(4); return; }
	lseek(v->d, offset, from);
	delete name;
	}
//////////////////////////
void SlangFiles::slang_rename() // rename(oldname, newname)
    {
    get_token();    // "("
    if(*token != '(')
	{ serror(1);	return;	}

    double value;
    char* old_name = get_exp(&value);
    if(*token != ',')
	{ serror(0);	return;	}
    char* new_name = get_exp(&value);

    rename(old_name, new_name);
    }
//////////////////////////
void SlangFiles::slang_setmode()  // setmode(handle, 1+3+5)
	{
	get_token();    // "("
	if(*token != '(')
	{ serror(1);	return;	}
    get_token();   // Name of handler variable
    if(token_type != VARIABLE)
	{ serror(2); return; }
    char* name = strdup(token);
    get_token();
    if(*token != ',')
	{ delete name; serror(0);	return;	}

    double mode;
    get_exp(&mode);
    Variable* v;
    if(!(v = variables->find(name)))
	{ serror(4); return; }
	setmode(v->d, mode);
	delete name;
	}
//////////////////////////
ulong SlangFiles::slang_tell()  // getpos(handle)
    {
//    get_token();    // "("
//    if(*token != '(')
//	{ serror(1);	return -1;	}

//    get_token();
    if(token_type != VARIABLE)
	{ serror(2); return -1; }
    Variable* v;
    if(!(v = variables->find(token)))
	{ serror(4); return -1; }
    return tell(v->d);
    }
//////////////////////////
void SlangFiles::slang_unlink()   // remove(name)
	{
	get_token();    // "("
	if(*token != '(')
	{ serror(1);	return;	}

    get_token();
    if(token_type != VARIABLE || token_type != QUOTE)
	{ serror(2); return; }
    double value;
    remove(get_exp(&value));
    }
//////////////////////////
//////////////////////////
void SlangFiles::next_line()
	{
	get_token();    // "("
	if(*token != '(')
	{ serror(1);	return;	}
	Variable* v;
	get_token();                     // handler
	if(token_type != VARIABLE || !(v = variables->find(token))
	|| (v->type != REAL))
	{ serror(2); return; }
	char buf[2];
	while(1)
	{
	read(v->d, buf, 1);
	if(buf[0] == '\n' || eof(v->d))
	    break;
	}
	}
/////////////////////////////
void SlangFiles::print()
  {
  if(error)
	return;

  char s[256];
  strcpy(s, "%f");
  double value; char* str_value;
  int len = 0;

  do {
	get_token();
	if(tok == SLANG_EOL || tok == SLANG_FINISHED // || tok == REMARK
		|| error)
	  break;

	while(*token == '{')                       // Format specifier
	  {
	  get_token();
      if(!strcmp(token, "file"))  // Handle of output file, -1 screen
	{
	double d;
	get_exp(&d);
	out_file = (int)d;
	}
      else if(!strcmp(token, "tab"))
        {
	double d;
	get_exp(&d);
	for(int i = len; i < d; i++)
	  printf(" ");
	}
      else if(token_type == QUOTE)
	strcpy(s, token);
      while(*token != '}')
	get_token();
	  get_token();
      }
    switch(token_type)
      {
      case QUOTE:       // it's string
	printf(token);
	len += strlen(token);
	get_token();
	break;
      default:          // it's expression
	putback();
	str_value = get_exp(&value);
	switch(variable_type)
          {
	  case REAL:
	  case ARRAY: len += printf(s, value); break;
	  case STR :  len += printf(str_value);   break;
	  default:
			  break;
	  }
      }
    switch(*token)
      {
      case ';': printf("\n"); break;
      case ',': break;               // nonthing to do
      default :
        if(tok != SLANG_EOL && tok != SLANG_FINISHED)
          {
          serror(0);
          return;
          }
      }
    } while(*token == ';' || *token == ',');
  }
/////////////////////////////////////////////////////////
/* INPUT {file x} {tab 15} a, " b: ", b, c; d
   INPUT "Input a, b, c, d: ", {tab 15} a, {tab 15} b, c; d

   Real input could be:
	   a. Number
	   b. String
	   No variables, expressions and so on. This permits us to interprete
	   Hello as "Hello", not as variable.
*/
void SlangFiles::input()
	{
	if(error)
	return;

	double i; char str[256]; // input string
	get_token();
	char prompt[80];

	if(*token == '{')                       // Format specifier
	  {
	  get_token();
	  if(!strcmp(token, "file"))  // Handle of input file, -1 kbd
	{
	double d;
	get_exp(&d);
	in_file = (int)d;
	}
      while(*token != '}')
	get_token();
      get_token();
      }
    else if(token_type == QUOTE)
	{
	strncpy(prompt, token, 80);
	get_token();
	if(*token != ',')
	    { serror(0); return; }
	get_token();
	}
    else
	strncpy(prompt, "? ", 80);

    Gets(str, prompt);
	char* c = str;

    do
      {
      Variable* v = variables->find(token);   // Name
		if(v == NULL)
	{
	serror(24);
	return;
	}
		 char t_token[80];
		char* temp;
		switch(v->type)
	{
	case STR:     // if exist (str)variable - assign str, else - real
		 {
				char s[256];
		 int type_of_string = 0; // No quotes
		if(str[0] == '"')
			{
	      type_of_string = 1; // Quotes
              c++;              // Skip quote
              }
	    for(int j = 0; j < 256; j++)
	      {
	      if(!type_of_string &&
		(c[j] == ',' || c[j] == ';' || c[j] == '"'
		|| c[j] == '\n' || c[j] == '\0' || c[j] == ' '
		|| c[j] == '\t'))
		break;
			if(type_of_string && (c[j] == '"'
		|| c[j] == '\n' || c[j] == '\0'))
		break;
              s[j] = c[j];		 
		  }
	    s[j] = '\0';
		if(s[j - 1] == '\r')
			  s [j - 1] = '\0';
  	    variables->assign(s, token);
	    get_token();
		 }
		 break;
	case REAL:
		 {
		 strcpy(t_token, token);   // t_token keep name
		 temp = prog;
				prog = c;
		 get_exp(&i);  // Get value of token of str
		 c = prog;
				prog = temp;
		 variables->assign(i, t_token);
		 get_token();
		 }
		 break;
	case ARRAY:
		 strcpy(t_token, token);   // t_token keep name
		 double value;
		 get_token();
	    get_exp(&i);              // i keeps index

		temp = prog;
		prog = c;
		get_exp(&value);          // value keeps input
			c = prog;
		prog = temp;
		variables->assign(value, t_token, (int)i);
			get_token();
		break;
	}
	  while(*token == ',' || *token == ';' || *token == '\t')
		  get_token();
	  } while(*token != '\r' && *token != '\n');
	}
///////////////////////////////////////////////////////////////////////////
double SlangFiles::further_math(double x)
	{
	if(error)
		return 0.0;

	double result;
	int t = tok;
	switch(t)
		{
		case SLANG_EOFILE: result = eof((int)(x)); break;
		case SLANG_FILELEN: result = filelength((int)x); break;
		case SLANG_GETPOS: result = tell((int)x); break;
		default:
// In the next generation do something like this:
//			result = Slang::further_math(x);
// and only there in the case of error do:
			serror(0); break;
		}
//
	return result;
	}

