#ifndef __SLANG_TABLE_H_
#define __SLANG_TABLE_H_

#include <string.h>

enum { DELIMITER = 1,     // '\0'(end),/*,*/,\r,<>=,' ',+-^/*%=;(),<>[]
	   VARIABLE,          // Symbolic name of variable, like x, k1 and so on
	   NUMBER,            // Double value
	   COMMAND,           // See "commands TABLE[]" later in this file
	   STRING,            // Remarked blocks or quoted text
	   QUOTE,             // Quote
	   ALPHA };           // @ (gosub) or ! (label) symbol



struct commands
	{
	char command[20];
	int tok;
	};
/////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////
struct _export UserFunc
  {
  char* DLL_name;
  char* function_name;
  int tok;

  UserFunc(char* dll, char* func, int t);// = SLANG_USER)
  ~UserFunc();
  };

struct _export FunctionList
	{
	int used;
	int total;
	UserFunc** list;

	FunctionList();
	~FunctionList();

	void init(commands* TABLE);
//    void sort();
	void add(char* dll, char* name, int tok);// = SLANG_USER, int to_sort = 1);
    UserFunc* remove(char* function_name);
    UserFunc* find(char* function_name);
    };                     


static char* error_string[] =
	{
	"Syntax error",                            //  0
	"Symbol '(' or ')' expected",              //  1
	"Not an expression",                       //  2
	"Symbol '=' expected",                     //  3
	"Not a variable",                          //  4
	"Too many subroutines",                    //  5
	"Duplicated subroutines",                  //  6
	"Undefined subroutine",                    //  7
	"Expected THEN operator",                  //  8
	"Expected TO operator",                    //  9
	"Number of nested FOR cycles too big",     //  10
	"NEXT without FOR",                        //  11
	"Number of nested GOSUB calls too big",    //  12
	"RETURN without GOSUB",                    //  13
	"Quote expected",			   //  14
	"Wrong arguments number",                  //  15
	"Out of range",                            //  16
	"It is no file",                           //  17
	"Symbol '=' or ARRAY expected",            //  18
	"Symbol '[' or ']' expected",              //  19
	"Name is already used ",                   //  20
	"File error",                              //  21
	"Memory allocation error",                 //  22
	"User break",                              //  23
	"Undefined variable",                      //  24
	"Use IF - THEN - ELSE - ENDIF",            //  25
	"Wrong argument type",                     //  26
	"Undefined function",                      //  27
	"DLL error",                               //  28
	"Print error",                             //  29
	"Math. error",                             //  30  
	"USER ERROR"
	};

#endif __SLANG_TABLE_H_