#ifndef __SLANG_MATH_H_
#define __SLANG_MATH_H_

#include "kh_slang\s_files.h"

enum { SLANG_CEIL = 3000, SLANG_COMBIN,
	   SLANG_COSH, SLANG_DEGREES, SLANG_FACT, SLANG_PRODUCT, SLANG_RADIANS,
	   SLANG_RAND, SLANG_SINH, SLANG_SUM, SLANG_SUMSQ, SLANG_SUMXMY2,
	   SLANG_TANH,

	   SLANG_AVERAGE, SLANG_CORREL, SLANG_COVAR, SLANG_DEVSQ, SLANG_EXPODIST,
	   SLANG_GEOMEAN, SLANG_REGRESSION, SLANG_MAX, SLANG_MIN, SLANG_NORMDIST,
	   SLANG_PERMUT, SLANG_POISSON, SLANG_STDDEV, SLANG_STDEVP, SLANG_VAR,
	   SLANG_VARP,

	   SLANG_ARRSUM, SLANG_ARRSUB, SLANG_ARRDIV, SLANG_ARRMULT,
	   SLANG_MVAVG, SLANG_MVMAX, SLANG_MVMIN,

	   SLANG_LOADER
	};
/////////////////////////////////////////////////////////////////////
class _export SlangMath : public SlangFiles    // The base interpreter class
	{
	public:
		SlangMath();

		virtual void further_processing();
		virtual double further_math(double x);
        virtual double further_math_first();

		Variable* get_array();

//	 virtual double slang_exec_sql() = 0;
//	 virtual double slang_read_db() = 0;
//	 virtual double slang_write_db() = 0;
		double slang_combin();
		double slang_product();
		double slang_rand();
		double slang_sum();      // a[0] + a[1] +...
		double slang_sumsq();    // a[0]^2 + a[1]^2 +...
		double slang_sumxmy2();  // (a[0] - b[0])^2 + ...
		double slang_average();  // sum(a[i])/n
		double slang_correl();
		double slang_covar();
		double slang_devsq();
		double slang_expodist();
		double slang_geomean();
		double slang_max();      // Max array el-t
		double slang_min();      // Min array el-t
		double slang_normdist();
		double slang_permut();
		double slang_poisson();
		double slang_stddev();
		double slang_stdevp();
		double slang_var();
		double slang_varp();

		void slang_arrsum();     // a1 + b1, ...
		void slang_arrsub();     // a1 - b1, ...
		void slang_arrdiv();     // a1 / b1, 0 if /0...
		void slang_arrmult();    // a1 * b1, ...
		void slang_regression();
// Mv... functions take 4 arguments:
//	 array - to be processed, array name for result, interval for operation,
//	 and shift. If index == 5, interval == 3 and shift == 0, process a5, a6,
//	 a7; if shift == 1, then a4, a5, a6; if shift == 2, a3, a4, a5.
		void slang_mvavg();
		void slang_mvmax();
		void slang_mvmin();

       	void slang_loader();
	 };

#endif __SLANG_MATH_H_




