#ifndef __BASIC_H_
#define __BASIC_H_

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <ctype.h>

#include "general\simple.h"
#include "kh_slang\slangtab.h"
#include "kh_slang\var_tab.h"

#define NUM_LAB   100     // Number of labels
#define LAB_LEN   10      // Length of label name
#define FOR_NEST  25      // Number of nested FOR cycles
#define SUB_NEST  25      // Number of nested SUBROUTINES calls
#define PROG_SIZE 32000   // Maximum program size (or use multyfile projects)
#define LINE_LEN 160      // Program line len (LINE - CR - LINE ...)
#define DEF_STRING_LEN 200 // Default len of string
//#define DEF_ARRAY_SIZE 2000

enum PLAY_SOURCE { FROM_FILE, FROM_STRING };


enum { SLANG_IF = 1, SLANG_THEN, SLANG_ENDIF, SLANG_ELSE, SLANG_FOR,
	   SLANG_CONTINUE, SLANG_BREAK, SLANG_NEXT, SLANG_TO, SLANG_GOTO,
	   SLANG_END_SUB, SLANG_RETURN, SLANG_END, SLANG_REMARK,
	   SLANG_REMARK_BLOCK, SLANG_EOL,

	   SLANG_DELETE,

	   SLANG_PAUSE,

	   SLANG_FINISHED, SLANG_GOSUB, SLANG_LABEL,

	   SLANG_PLAYEX, SLANG_LPLAY, SLANG_SPLAY,

	   SLANG_SIN, SLANG_COS, SLANG_TAN, SLANG_ASIN, SLANG_ACOS, SLANG_ATAN,
	   SLANG_ABS, SLANG_EXP, SLANG_LOG, SLANG_LG,

		SLANG_STRCMP, SLANG_STRCHR,
		SLANG_GETTOKEN, SLANG_GETREAL, SLANG_PUTTOKEN,

//       SLANG_USER = 10000, SLANG_REGISTER
	   };  // All functions after this are user-defined in Slang childs


struct for_stack
	 {
	 char name[10];  // Counter - cycle variable name
	 double endval;  // Cycle end value
	 uint entrance; // Point in the program string
    };

struct play_stack
	 {
    char* prog;                            // Name of file
	 uint shift;                             // Offset in this file
    play_stack(char* s, int i)
		  { prog = new char[strlen(s)]; strcpy(prog, s); shift = i; }
	 ~play_stack() { delete prog; prog = NULL; }
	 };

struct label               // Label : LABEL NAME and pointer to the place
	 {                      // in the program
	 char name[LAB_LEN];
	 uint p;
	 };
//////////////////////////////////////////////////////////////////////////////////
static int math_error = 0;
int _matherr(struct _exeption* exept);
//////////////////////////////////////////////////////////////////////////////////

class _export Slang                     // The base interpreter class
	 {
	 public:

	PLAY_SOURCE play_source;  // FROM_FILE or FROM_STRING
	int error;                         // Number of the error
	char* program;          // SLANG program (contents of current file)
	uint substack[SUB_NEST];          // Subroutines stack
	play_stack* playstack[SUB_NEST];   // External files player
	for_stack fstack[FOR_NEST];        // FOR stack

	 int variable_type;  // Type of current variable
	 char   token_type;  // Type of token obtained
	 int tok;           // Group of token obtained
	 char token[LINE_LEN]; // Token obtained

	 int for_used;       // FOR stack top
	 int sub_used;       // Gosub stack top
	 int play_used;      // Play stack top

	 char* prog;         // Program - from the current point to the end

	 label* labels;      // Table of labels in current file
	 VarTable* variables; // Table of variables
	 VarTable* arguments; // Parameters for user DLL functions

	 FunctionList* FuncTable;
	 UserFunc* function;  // Current function

	 public:
		  Slang();
		  ~Slang();

		int prepare_interprete();
		virtual void further_processing() {}
		virtual double further_math(double x) { return 0.0; }
		virtual double further_math_first() { return 0.0; }

	 char* get_string_arg(char* dst); // token contains string or variable
//////////////////////////////////////////////////////////////////////////////////
//	virtual double slang_user(char* DLL_name, char* function_name) = 0;
//	virtual void slang_register() = 0;
//	virtual void slang_unregister() = 0;

	 void slang_end_sub();         // Go to return

	 void slang_get_token();              // Parse string
	 double slang_get_real(Variable* s);  //
	 void slang_put_token();

	 void del();

	 void slang_goto();         // GOTO operator
	 void slang_if();           // IF operator
	 void slang_else();         // ELSE operator
	 void slang_for();          // FOR operator
	 void slang_continue();     // CONTINUE operator
	 void slang_break();        // BREAK operator
	 void next();               // NEXT operator
	 void gosub();              // Pass control to the subroutine
	 void sub_return();         // Return from subroutine
	 void play();               // Play external file
	 void lplay();              // Link functions of current module
	 virtual void interprete(); // basic() call it in cycle
	 void get_label();
	 int slang_strcmp();             // compare two strings
	 int slang_strchr();             // check string for given char
	 void pause();               // See "C" delay() function


	 void set_error(int err) { error = err; }
	 int get_argument(double* x);
	 int get_error() { return error; }
	 void set_program(char* p) { program = p; }
	 char* get_program() { return program; }
	 char* load_program(char*); // Remove old program and load new file
	 uint find_label(char*);   // Find label name in the table
	 uint sub_pop();           // Get subroutine parameters from stack
	 void sub_push(char*);      // Push Gosub parameters to stack
	 for_stack for_pop();       // Get FOR parameters from stack
	 void for_push(for_stack);  // Push FOR parameters to stack
	 void playpush(char*, int); // Push external file parameters to stack
	 play_stack* playpop();     // Get external file parameters from stack

	 void scan_labels();        // Scan file and fill labels
	 void find_eol();           // Scip line
	 void find_return();        // Search for RETURN (\r\n)

	 void label_init();         // Init labels
	 int get_next_label(char*); // Get next label
	 int reassign_arguments();  // We use assign_ and reassign_arguments
	 int assign_arguments();    // with subroutines calls to pass args.
	 void release_var(char* );  // Remove variable from table
	 void assigment();          // Assign value to variable
	 void basic(char*);         // Executes program pointed by char*

	 void math(double* result);  // sin, cos...

	 char* get_exp(double*);
	 char* level0(double*);
	 char* level1(double*), *level2(double*); // Recursive analyser
	 char* level3(double*), *level4(double*);  // User could modify
	 char* level5(double*), *level6(double*);  // the "primitive" function
	 char* level7(double*);                    // and add COMMAND group
	 char* primitive(double*);                 // user-defined functions
	 void arith(char, double*, double*, char op1 = '0');
	 void unary(char, double*);

	 virtual void serror(int);  // Error processor
	 virtual void error_report(char* text); // Overload for your own print

	 void putback();            // Put token back
	 int get_token();           // Get token from prog
	 int iswhite(char);         // Recognize symbols to skip
	 int isdelim(char);         // Recognize delimiters (),:;" and so on

	 virtual void terminate();  // User-defined terminator (ESC and so on)
	 };

#endif __BASIC_H_





