/*  Project slang

    Copyright  1994,1996. All Rights Reserved.

    SUBSYSTEM:    slang.exe Application
    FILE:         slngmdi1.cpp
    AUTHOR:       S.Vartanov


	 OVERVIEW
	 ========
	 Source file for implementation of slangMDIChild (TMDIChild).
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "slangapp.h"
#include "slngedtf.h"
#include "slngmdi1.h"
#include "slang\win_ext.h"
//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(slangMDIChild, TMDIChild)
//{{slangMDIChildRSP_TBL_BEGIN}}
    EV_COMMAND(CM_RUN, CmRun),
//{{slangMDIChildRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{slangMDIChild Implementation}}


//////////////////////////////////////////////////////////
// slangMDIChild
// ==========
// Construction/Destruction handling.
slangMDIChild::slangMDIChild (TMDIClient &parent, const char far *title, TWindow *clientWnd, bool shrinkToClient, TModule *module)
    : TMDIChild (parent, title, clientWnd == 0 ? new slangEditFile(0, 0, 0) : clientWnd, shrinkToClient, module)
{
	 // INSERT>> Your constructor code here.
	 fname = NULL;
}


slangMDIChild::~slangMDIChild ()
{
	 Destroy();

	 // INSERT>> Your destructor code here.
//	 slangApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), slangApp);
	 if(childList)
		  {
		  char s[256];
		  GetWindowText(s, 255);
		  delete childList->remove(childList->find(fname));
		  }
	 delete fname;
}



void slangMDIChild::CmRun ()
{
	 // INSERT>> Your code here.
//	 slangApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), slangApp);

	 SendMessage(WM_COMMAND, CM_FILESAVE, 0L);
	 if(!dr)
		  {
		  MDIDraw* child = new MDIDraw(*THISA, fname, 0);

		  // Associate ICON w/ this child window.
		  child->SetIcon(GetApplication(), IDI_DOC);

		  // If the current active MDI child is maximize then this one should be also.
		  MDIDraw* curChild = (MDIDraw*)(THISA->GetActiveMDIChild());
		  if (curChild && (curChild->GetWindowLong(GWL_STYLE) & WS_MAXIMIZE))
				child->Attr.Style |= WS_MAXIMIZE;

		  child->Create();

		  dr = child;
		  }
	 else
		  {
		  dr->BringWindowToTop();
		  dr->SetWindowText(fname);
		  ((DrawPane*)(dr->GetClientWindow()))->setFileName(fname);
		  ((DrawPane*)(dr->GetClientWindow()))->first_draw = TRUE;
		  dr->Invalidate();
		  }
	 }

