#ifndef __HORIZ_VERT_AXES_H_
#define __HORIZ_VERT_AXES_H_

#include "kh_graf\axe.h"

enum axes_dir  { HORIZ_AXE, VERT_AXE };
enum axes_type { NORMAL_AXE, REVERSE_AXE };

class _export HV_Axes : public Axe
    {
    public:
	int type;
	int dir;
	int text_dir;
    public:
	HV_Axes(int l, double start = 0, double end = 0,
	    int tick_no = 5, int* t = NULL,
	    int s_tick_no = 0, int* s = NULL,
	    char** lab = NULL);
	void show_labels(loc pos);
	void set_type(int t, int d, int td = HORIZ_AXE);
	virtual loc get_label_pos(loc, int );
	void show_axe(loc pos, int color, int width, int tick_width);
	void draw_axe(loc lt, int ax_col, int lab_col, int width, int tick_width);     // Show both axe and labels
	virtual void load(char* s);
	virtual void settextjustify(int hor_j, int ver_j);
	virtual int gettextwidth(char* s);
	virtual void outtextxy(int x, int y, char* s, int dir);
	virtual int getheight();
	virtual void setlinestyle(int w, int s);
	virtual void line(int l, int t, int r, int b);
    };

#endif __HORIZ_VERT_AXES_H_