//    Class for drawing X-Y dependences on screen.

#ifndef __GRAF_H_
#define __GRAF_H_

//#include "bgipaint.h"

#include "kh_graf\axes2.h"
#include "kh_gdi\drawtool.h"

/*    There are few types of graphics. Line graf could be used for
    drawing splines (no markers). Marker graf looks nice for the set
    of few (up to 20 - 40) points. Combined graf is the combination of
    line and marker grafs (data with spline). Bar and 3 dimensional bar
    presents data as bars drawn from 0(Y) to y(Y). Stacked bar graf
    draws 3-d bars not from zero, but from the top of previous bar.
*/

enum { NO_GRAF, LINE_GRAF, MARKER_GRAF, COMBINED_GRAF, BAR_GRAF,
		 BAR_3D_GRAF, STACKED_BAR_GRAF };

enum { NON,
       BAR, CIRCLE, TRIANGLE, STAR5, STAR6, R_CROSS, X_CROSS,
       DIAMOND, TRIANGLE2, BAR2, CIRCLE2, ARROW_UP, ARROW_DN };

class _export Graf : public KH_Paint, public Axes2
    {
    public:
	double xmin, ymin, xmax, ymax;
	rect clip;
	int marker_size;
	 public:
	Graf();
   ~Graf();

	void show_marker(int type, loc pos);
/* Array of shifts is twofold larger than x and y arrays. It contain
information about shifts of bars in BAR_GRAF or BAR_3D_GRAF. s[2*i] contain
negative and s[2*i +1] - positive shifts.
After every call to this function shifts[] will be modified. Initial values
of array element at first call should be 0.
*/
	void plot_data(double* x, double* y1, int no, int type, int mark,
	    int* shifts = NULL, double* y_dv = NULL, double* x_dv = NULL);
	void cross();
	void calc_scale(double* ar, int axe, int is_first, int n, int num,
	    double* dv = NULL);
	void get_stacked(double* add, double* base, int n);
	void set_graf_clip(int x1, int y1, int x2, int y2);
	void set_graf_scale(double xmi, double ymi, double xma, double yma);
	void set_marker_size(int m) { marker_size = m; }

	void show_axes(int ax_color, int legends_color,
	    int grid_style, int grid_color, int w, int tw, int set);
    };

#endif __GRAF_H_
