/*  Project slang
    
    Copyright  1994,1996. All Rights Reserved.

    SUBSYSTEM:    slang.apx Application
    FILE:         textpane.cpp
    AUTHOR:       S.Vartanov


    OVERVIEW
    ========
    Source file for implementation of TextPane (TWindow).      
*/

#include <owl\owlpch.h>
#pragma hdrstop

#include "textpane.h"


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(TextPane, TWindow)
//{{TextPaneRSP_TBL_BEGIN}}
    EV_WM_SIZE,
//{{TextPaneRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{TextPane Implementation}}


TextPane::TextPane (TWindow* parent, const char far* title, TModule* module):
    TWindow(parent, title, module)
{
    // Change the window's background color
	 SetBkgndColor(RGB(0x00, 0x00, 0x00));

	 // INSERT>> Your constructor code here.
	 screen = (char**)malloc((NUM_OF_RAW + 2) * sizeof(char*));
	 for(int i = 0; i < NUM_OF_RAW + 2; i++)
		  {
		  screen[i] = new char[NUM_OF_COL + 2];
		  screen[i][0] = '\0';
		  }
	 xpos = ypos = 0;
	 start_x = start_y = 0;
	 }
////////////////////////////////////////////////////////////////////
TextPane::~TextPane ()
	 {
	 Destroy();

	 // INSERT>> Your destructor code here.
	 for(int i = 0; i < NUM_OF_RAW + 2; i++)
		  delete screen[i];
	 delete screen;
	 }
//////////////////////////////////////////////////////////////////////
void TextPane::Paint (TDC& dc, bool erase, TRect& rect)
	 {
	 TWindow::Paint(dc, erase, rect);
	 // INSERT>> Your code here.
	 TRect r = GetClientRect();

//	 HBRUSH brush = (HBRUSH)GetStockObject(BLACK_BRUSH);
//	 brush = (HBRUSH)SelectObject((HDC)dc, brush);
//	 HPEN pen  = CreatePen(PS_SOLID, 1, RGB(0, 255, 0));
//	 pen = (HPEN)SelectObject((HDC)dc, pen);
	 SetTextColor((HDC)dc, RGB(0, 255, 0));
	 SetBkColor((HDC)dc, RGB(0, 0, 0));
	 TEXTMETRIC tm;
	 dc.GetTextMetrics(tm);
	 int h = tm.tmHeight;
//    int w = tm.tmAveCharWidth;
	 int raws = (r.bottom - r.top + 1) / h;
//    int rt = r.right - r.left + 1;
	 start_y = ypos < raws ? 0 : ypos - raws;
//	 dc.Rectangle(r);
	 for(int i = start_y; i <= ypos; i++)
		  TextOut((HDC)dc, 0, (i - start_y) * h, screen[i], strlen(screen[i]));

//	 SelectObject((HDC)dc, brush);
//	 SelectObject((HDC)dc, pen);
//	 DeleteObject(pen);
	 }
/////////////////////////////////////////////////////////////////////
void TextPane::show_text(char* text)
  {
  HDC dc = GetDC(*this);
  TRect r = GetClientRect();

	 HBRUSH brush = (HBRUSH)GetStockObject(BLACK_BRUSH);
	 brush = (HBRUSH)SelectObject(dc, brush);
//	 HPEN pen  = CreatePen(PS_SOLID, 1, RGB(0, 255, 0));
//	 pen = (HPEN)SelectObject((HDC)dc, pen);
  SetTextColor(dc, RGB(0, 255, 0));
  SetBkColor((HDC)dc, RGB(0, 0, 0));

  TEXTMETRIC tm;
  GetTextMetrics(dc, &tm);
  int h = tm.tmHeight;
  int w = tm.tmAveCharWidth;
  int raws = (r.bottom - r.top + 1) / h - 1;
//  int rt = r.right - r.left + 1;

  BOOL finished = FALSE;

  for(int i = 0; i < strlen(text); i++)
	 {
	 finished = FALSE;

	 if(ypos == NUM_OF_RAW)
		{
		finished = TRUE;
		Rectangle(dc, r.left, r.top, r.right, r.bottom);
		char* tmp = screen[0];
		for(int j = 0; j < ypos - 1; j++)
			 screen[j] = screen[j + 1];
		screen[NUM_OF_RAW - 1] = tmp;
		screen[NUM_OF_RAW - 1][0] = '\0';

		for(j = start_y; j < NUM_OF_RAW; j++)
			 TextOut(dc, 0, (j - start_y) * h, screen[j], strlen(screen[j]));
		start_x = xpos = 0;

		ypos--;
		}
	 if(text[i] == '\n')
		{
		finished = TRUE;
		screen[ypos][xpos] = '\0';
		xpos = 0;
		start_x = 0;
		ypos++;
		break;
		}
	 if(ypos - start_y >= raws)
		{
		Rectangle(dc, r.left, r.top, r.right, r.bottom);
		start_y++;
		start_x = xpos = 0;
		for(int j = start_y; j < NUM_OF_RAW; j++)
			 TextOut(dc, 0, (j - start_y) * h, screen[j], strlen(screen[j]));
		}
	 if(xpos < NUM_OF_COL)
		{
		screen[ypos][xpos] = text[i];
		xpos++;
		}
	 }
  if(!finished)
	 {
	 screen[ypos][xpos] = '\0';
	 TextOut(dc, start_x * w, (ypos - start_y) * h, screen[ypos] + start_x,
	 xpos - start_x);
	 }
//  ReleaseDC(*this, dc);

	 SelectObject(dc, brush);
//	 SelectObject((HDC)dc, pen);
//	 DeleteObject(pen);

  ReleaseDC(*this, dc);
  }
////////////////////////////////////////////////////////////


void TextPane::EvSize (uint sizeType, TSize& size)
{
    TWindow::EvSize(sizeType, size);

    // INSERT>> Your code here.
    Invalidate();
}

