/*  Project slang

	 Copyright  1994,1996. All Rights Reserved.

	 SUBSYSTEM:    slang.exe Application
	 FILE:         slngmdic.cpp
	 AUTHOR:       S.Vartanov


	 OVERVIEW
	 ========
	 Source file for implementation of slangMDIClient (TMDIClient).
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include <dir.h>

#include "slangapp.h"
#include "slngedtf.h"
#include "slngmdi1.h"
#include "slngmdic.h"
#include "mdidraw.h"
#include "apxprint.h"
#include "apxprev.h"

// My code
#include "slang\win_ext.h"
#include <stdio.h>
#include <io.h>


int newFileNum = 0;

// End of my code

//{{slangMDIClient Implementation}}
//
// Build a response table for all messages/commands handled
// by slangMDIClient derived from TMDIClient.
//
DEFINE_RESPONSE_TABLE1(slangMDIClient, TMDIClient)
//{{slangMDIClientRSP_TBL_BEGIN}}
	 EV_COMMAND(CM_MDIFILENEW, CmFileNew),
	 EV_COMMAND(CM_MDIFILEOPEN, CmFileOpen),
	 EV_COMMAND(CM_FILEPRINT, CmFilePrint),
	 EV_COMMAND(CM_FILEPRINTERSETUP, CmFilePrintSetup),
	 EV_COMMAND(CM_FILEPRINTPREVIEW, CmFilePrintPreview),
	 EV_COMMAND_ENABLE(CM_FILEPRINT, CmPrintEnable),
	 EV_COMMAND_ENABLE(CM_FILEPRINTERSETUP, CmPrintEnable),
	 EV_COMMAND_ENABLE(CM_FILEPRINTPREVIEW, CmPrintEnable),
//{{slangMDIClientRSP_TBL_END}}
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// slangMDIClient
// ===========
// Construction/Destruction handling.
slangMDIClient::slangMDIClient (TModule* module)
 : TMDIClient (module)
{
	 // Change the window's background color
	 SetBkgndColor(RGB(0x82, 0x82, 0x82));

	 ChildCount = 0;

	 // INSERT>> Your constructor code here.
	 THISA = this;
	 childList = new ChildInfoList();

	 slang = new WinOOPic();
	 }


slangMDIClient::~slangMDIClient ()
{
	 Destroy();

	 // INSERT>> Your destructor code here.
	 delete childList;
	 childList = NULL;
	 delete slang;
}


//////////////////////////////////////////////////////////
// slangMDIClient
// ===========
// MDIClient site initialization.
void slangMDIClient::SetupWindow ()
{
	 // Default SetUpWindow processing.
	 TMDIClient::SetupWindow ();

	 slangApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), slangApp);

	 // Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
	 // computed in the member functions CmFileOpen, and CmFileSaveAs.
	 theApp->FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
	 theApp->FileData.SetFilter("SLANG programs (*.vec)|*.VEC|All Files (*.*)|*.*|");

}
//////////////////////////////////////////////////////////
void slangMDIClient::get_new_name(string& name, char* ext)
	 {
	 if(childList->used > 20)
		  {
		  MessageBox("Too many windows", "SLANG", MB_OK);
		  return;
		  }
	 char s1[10];
	 char s2[256];
	 getcwd(s2, 254);
	 while(1)
		  {
		  name = s2;
		  name += "\\work";
		  name += itoa(newFileNum++, s1, 10);
		  name += ext;
		  if(childList->find(name.c_str()) == -1)
				break;
		  }
	 }
////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
// slangMDIClient
// ===========
// Menu File New command
void slangMDIClient::CmFileNew ()
	 {
	 string name;
	 get_new_name(name, ".vec");
	 if(!(*(name.c_str())))
		  return;
//	 char title[255];
	 // Generate a title for the MDI child window.
//	 wsprintf(title, "%d", ChildCount++);

	 OpenFile(name.c_str());
/*
	 TextPane* image = new TextPane(0);
	 IO_Window* child = new IO_Window(*this, image);
	 child->SetIcon(GetApplication(), IDI_DOC);
	 child->Create();
	 char s[80];
	 for(int i = 0; i < 100; i++)
		  {
		  sprintf(s, "String No %d\n", i);
		  child->printf(s);
		  }
*/
	 }
///////////////////////////////////////////////////////////////////

void slangMDIClient::OpenFile (const char *fileName)
{
//	 if(!(file = fopen(fileName, "r")))
//		  file = fopen(fileName, "w");
//	 fclose(file);
	 if(access(fileName, 0))
		  {
		  FILE* file;
		  file = fopen(fileName, "w");
		  fclose(file);
		  }

	 slangApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), slangApp);

	 if (fileName)
		  strcpy(theApp->FileData.FileName, fileName);

	 //
	 // Create a MDIChild window whose client is slangEditFile.
	 //
	 slangMDIChild* child = new slangMDIChild(*this, "",
		  new slangEditFile(0, 0, 0, 0, 0, 0, 0, theApp->FileData.FileName));
	 child->fname = str_dup(fileName);
	 childList->add(new ChildInfo((TWindow*)child, fileName, SLANG_WINDOW));
	 // Associate ICON w/ this child window.
	 child->SetIcon(GetApplication(), IDI_DOC);

	 // If the current active MDI child is maximize then this one should be also.
	 slangMDIChild *curChild = (slangMDIChild *)GetActiveMDIChild();
	 if (curChild && (curChild->GetWindowLong(GWL_STYLE) & WS_MAXIMIZE))
		  child->Attr.Style |= WS_MAXIMIZE;

	 child->Create();
	 LoadTextFile();
}


//////////////////////////////////////////////////////////
// slangMDIClient
// ===========
// Menu File Open command
void slangMDIClient::CmFileOpen ()
{
	 slangApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), slangApp);

	 //
	 // Display standard Open dialog box to select a file name.
	 //
	 *(theApp->FileData.FileName) = 0;

	 if (TFileOpenDialog(this, theApp->FileData).Execute() == IDOK)
		  {
		  int idx;
		  if((idx = childList->find(theApp->FileData.FileName)) == -1)
				OpenFile(theApp->FileData.FileName);
		  else
				(childList->list[idx]->w)->BringWindowToTop();
		  }
	 }


// Used by ListBox client to read a text file into the list box.
void slangMDIClient::LoadTextFile ()
{
	 char            buf[255+1];
	 ifstream        *inStream;

	 slangApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), slangApp);

	 slangMDIChild* curChild = (slangMDIChild *)GetActiveMDIChild();
	 TListBox* client = TYPESAFE_DOWNCAST(curChild->GetClientWindow(), TListBox);

	 // Only work if the client class is a TListBox.
	 if (client) {
		  client->ClearList();
		  inStream = new ifstream(theApp->FileData.FileName);
		  while (inStream->good()) {
				inStream->getline(buf, sizeof(buf) - 1);
				if (inStream->good())
					 client->AddString(buf);
		  }

		  // Return an error message if we had a stream error and it wasn't the eof.
		  if (inStream->bad() && !inStream->eof()) {
				string msgTemplate(*GetModule(), IDS_UNABLEREAD);
				char*  msg = new char[MAXPATH + msgTemplate.length()];
				wsprintf(msg, msgTemplate.c_str(), *(theApp->FileData.FileName));
				MessageBox(msg, GetApplication()->GetName(), MB_ICONEXCLAMATION | MB_OK);
				delete msg;
		  }

		  delete inStream;
	 }
}


//////////////////////////////////////////////////////////
// slangMDIClient
// ==========
// Menu File Print command
void slangMDIClient::CmFilePrint ()
{
	 //
	 // Create Printer object if not already created.
	 //
	 slangApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), slangApp);
	 if (theApp) {
		  if (!theApp->Printer)
				theApp->Printer = new TPrinter(GetApplication());

		  //
		  // Create Printout window and set characteristics.
		  //
		  APXPrintOut printout(theApp->Printer, Title, GetActiveMDIChild()->GetClientWindow(), true);

		  theApp->Printing++;

		  //
		  // Bring up the Print dialog and print the document.
		  //
		  theApp->Printer->Print(GetWindowPtr(GetActiveWindow()), printout, true);

		  theApp->Printing--;
	 }
}


//////////////////////////////////////////////////////////
// slangMDIClient
// ==========
// Menu File Print Setup command
void slangMDIClient::CmFilePrintSetup ()
{
	 slangApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), slangApp);
	 if (theApp) {
		  if (!theApp->Printer)
				theApp->Printer = new TPrinter(GetApplication());

		  //
		  // Bring up the Print Setup dialog.
		  //
		  theApp->Printer->Setup(this);
	 }
}


//////////////////////////////////////////////////////////
// slangMDIClient
// ==========
// Menu File Print Preview command
void slangMDIClient::CmFilePrintPreview ()
{
	 slangApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), slangApp);
	 if (theApp) {
		  if (!theApp->Printer)
				theApp->Printer = new TPrinter(GetApplication());

		  theApp->Printing++;

		  PreviewWindow *prevW = new PreviewWindow(Parent, theApp->Printer, GetActiveMDIChild()->GetClientWindow(), "Print Preview", new TLayoutWindow(0));
		  prevW->Create();

		  GetApplication()->BeginModal(GetApplication()->GetMainWindow());

		  // We must destroy the preview window explicitly.  Otherwise, the window will not be destroyed until
		  // it's parent the MainWindow is destroyed.
		  prevW->Destroy();
		  delete prevW;

		  theApp->Printing--;
	 }
}


//////////////////////////////////////////////////////////
// slangMDIClient
// ==========
// Menu enabler used by Print, Print Setup and Print Preview.
void slangMDIClient::CmPrintEnable (TCommandEnabler &tce)
{
	 if (GetActiveMDIChild()) {
		  slangApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), slangApp);
		  if (theApp) {
				// If we have a Printer already created just test if all is okay.
				// Otherwise create a Printer object and make sure the printer
				// really exists and then delete the Printer object.
				if (!theApp->Printer) {
					 theApp->Printer = new TPrinter(GetApplication());

					 tce.Enable(theApp->Printer->GetSetup().Error == 0);
				} else
					 tce.Enable(theApp->Printer->GetSetup().Error == 0);
		  }
	 } else
		  tce.Enable(false);
}




