/*  Project slang
    
    Copyright  1994,1996. All Rights Reserved.

    SUBSYSTEM:    slang.exe Application
    FILE:         slngedtf.cpp
    AUTHOR:       S.Vartanov


    OVERVIEW
    ========
    Source file for implementation of slangEditFile (TEditFile).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "slangapp.h"
#include "slngedtf.h"
#include "slngedtf.h"

#include <stdio.h>
#include "helpdilg.h"
#include "slang\win_ext.h"

//{{slangEditFile Implementation}}


//
// Build a response table for all messages/commands handled
// by slangEditFile derived from TEditFile.
//
DEFINE_RESPONSE_TABLE1(slangEditFile, TEditFile)
//{{slangEditFileRSP_TBL_BEGIN}}
	 EV_WM_GETMINMAXINFO,
//    EV_COMMAND(CM_HELP_FUNCTIONS, OnHelpFunctions),
//{{slangEditFileRSP_TBL_END}}
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// slangEditFile
// ==========
// Construction/Destruction handling.
slangEditFile::slangEditFile (TWindow* parent, int id, const char far* text, int x, int y, int w, int h, const char far* fileName, TModule* module)
	 : TEditFile(parent, id, text, x, y, w, h, fileName, module)
{
    // INSERT>> Your constructor code here.

}


slangEditFile::~slangEditFile ()
{
    Destroy();

	 // INSERT>> Your destructor code here.

}


void slangEditFile::SetupWindow ()
{
    TEditFile::SetupWindow();

    slangApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), slangApp);
	 FileData = theApp->FileData;
}


//
// Paint routine for Window, Printer, and PrintPreview for an TEdit client.
//
void slangEditFile::Paint (TDC& dc, bool, TRect& rect)
{
	 window_type = SLANG_WINDOW;

	 slangApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), slangApp);
	 if (theApp) {
		  // Only paint if we're printing and we have something to paint, otherwise do nothing.
		  if (theApp->Printing && theApp->Printer && !rect.IsEmpty()) {
				// Use pageSize to get the size of the window to render into.  For a Window it's the client area,
				// for a printer it's the printer DC dimensions and for print preview it's the layout window.
				TSize   pageSize(rect.right - rect.left, rect.bottom - rect.top);

				HFONT   hFont = (HFONT)GetWindowFont();
				TFont   font("Arial", -12);
				if (hFont == 0)
              dc.SelectObject(font);
            else
				  dc.SelectObject(TFont(hFont));
    
            TEXTMETRIC  tm;
            int fHeight = (dc.GetTextMetrics(tm) == true) ? tm.tmHeight + tm.tmExternalLeading : 10;
    
				// How many lines of this font can we fit on a page.
            int linesPerPage = MulDiv(pageSize.cy, 1, fHeight);
            if (linesPerPage) {    
                TPrintDialog::TData &printerData = theApp->Printer->GetSetup();

                int maxPg = ((GetNumLines() / linesPerPage) + 1.0);

                // Compute the number of pages to print.
					 printerData.MinPage = 1;
                printerData.MaxPage = maxPg;

					 // Do the text stuff:
                int     fromPage = printerData.FromPage == -1 ? 1 : printerData.FromPage;
                int     toPage = printerData.ToPage == -1 ? 1 : printerData.ToPage;
					 char    buffer[255];
                int     currentPage = fromPage;

                while (currentPage <= toPage) {
                    int startLine = (currentPage - 1) * linesPerPage;
                    int lineIdx = 0;
                    while (lineIdx < linesPerPage) {
								// If the string is no longer valid then there's nothing more to display.
                        if (!GetLine(buffer, sizeof(buffer), startLine + lineIdx))
                            break;
                        dc.TabbedTextOut(TPoint(0, lineIdx * fHeight), buffer, strlen(buffer), 0, NULL, 0);
                        lineIdx++;
                    }
                    currentPage++;
					 }
				}
		  }
	 }
}


void slangEditFile::EvGetMinMaxInfo (MINMAXINFO far& minmaxinfo)
{
	 slangApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), slangApp);
	 if (theApp) {
		  if (theApp->Printing) {
				minmaxinfo.ptMaxSize = TPoint(32000, 32000);
				minmaxinfo.ptMaxTrackSize = TPoint(32000, 32000);
				return;
		  }
	 }
	 TEditFile::EvGetMinMaxInfo(minmaxinfo);
}



/*
void slangEditFile::OnHelpFunctions ()
{
	 // INSERT>> Your code here.
	 char str[256];
	 if(HelpDialog(this, IDD_HELP_INDEX, str).Execute() == IDOK)
		  Insert(str);
}
*/
