#ifndef __BGI_PAINT_H_
#define __BGI_PAINT_H_

//#include <owl\owlpch.h>
//#pragma hdrstop
#include <windows.h>
#include "kh_gdi\paint.h"
#include "general\simple.h"
//////////////// Common color ref. and fill code ////////////////////////
/*
#ifndef RGB

#define COLORREF unsigned long
#define BYTE uchar
#define WORD unsigned short
#define DWORD unsigned long

#define RGB(r,g,b)          ((COLORREF)(((BYTE)(r)|((WORD)(g)<<8))|(((DWORD)(BYTE)(b))<<16)))

#endif RGB
*/
////////////////////////////////////////////////////////////////////////////
#define SOLID_FILL              1
#define SOLID_LINE              PS_SOLID
#define DASHED_LINE             PS_DASH
#define DOTTED_LINE             PS_DOT
#define CENTER_LINE             PS_DASHDOT

// Do not use HS_BDIAGONAL, HS_FDIAGONAL, HS_VERTICAL, HS_HORIZONTAL
// HS_CROSS and HS_DIAGCROSS !!!
#define LINE_FILL               0
#define HATCH_FILL              2
#define SLASH_FILL              3
#define XHATCH_FILL             4
#define BKSLASH_FILL            5
#define LTSLASH_FILL            6

#define LEFT_TEXT     0
#define CENTER_TEXT   1
#define RIGHT_TEXT    2
#define BOTTOM_TEXT   0
#define TOP_TEXT      2

////////////////////////////////////////////////////////////////////////////
#define HS_SOLID                SOLID_FILL
//////////////////////////////////////////////////////////
enum COLORS { BLACK, BLUE, GREEN, CYAN, RED, MAGENTA, BROWN, LIGHTGRAY,
	 DARKGRAY, LIGHTBLUE, LIGHTGREEN, LIGHTCYAN, LIGHTRED, LIGHTMAGENTA,
	 YELLOW, WHITE };
////////////////////////////////////////////////////////////////////////////
struct color_to_16
	 {
	 int color;
	 COLORREF colorref;
	 };

//extern color_to_16 _export tricolors[16];
static color_to_16 tricolors[16] =
	 {   { BLACK, 0 },
		  { BLUE, RGB(0, 0, 128) },
		  { GREEN, RGB(0, 128, 0) },
		  {  CYAN, RGB(0, 128, 128) },
		  {  RED, RGB(128, 0, 0) },
		  { MAGENTA, RGB(74, 23, 74) },
		  { BROWN, RGB(128, 64, 64) },
		  { LIGHTGRAY, RGB(128, 128, 128) },
		  { DARKGRAY, RGB(64, 64, 64) },
		  { LIGHTBLUE, RGB(0, 0, 255) },
		  { LIGHTGREEN, RGB(0, 255, 0) },
		  { LIGHTCYAN, RGB(0, 255, 255) },
		  { LIGHTRED, RGB(255, 0, 0) },
		  { LIGHTMAGENTA, RGB(255, 0, 255) },
		  { YELLOW, RGB(255,255,30) },
		  { WHITE, RGB(255, 255, 255) }
	 };
////////////////////////////////////////////////////////////////////////////
//#define WIN31
/*
#undef COLORREF
#undef BYTE
#undef WORD
#undef DWORD
*/
//#undef RGB

struct _export To_Paint
	 {
	 int PenSize;
	 int PenStyle;
	 COLORREF color;

	 int pattern_num;
	 int fill_color;
	 COLORREF BrushColor;

	 HDC DC;
	 /////////////////////////////////
	 To_Paint() { pattern_num = SOLID_FILL; PenSize = 1; PenStyle = PS_SOLID;
		 color = RGB(0,0,0); BrushColor = RGB(0,0,0); }
	 /////////////////////////////////
	 int getx() { POINT p; ::GetCurrentPositionEx(DC, &p); return p.x; }
	 int gety() { POINT p; ::GetCurrentPositionEx(DC, &p); return p.y; }
	 COLORREF getcolorref() { return color; }
	 int getcolor(COLORREF col);
	 int getcolor() { return getcolor(color); }

	 void setcolor(int r, int g, int b)	{ color = RGB(r,g,b); }
	 void setcolor(int c)
	{ color = tricolors[c].colorref; }

	 void putpixel(int x, int y) { ::SetPixel(DC, x, y, getcolorref()); }
	 void setlinestyle(int width, int style)
	{ PenSize = width; PenStyle = style; }
    void setlinestyle(int style, unsigned int, int width)
	{ PenSize = width; PenStyle = style; }

    void setfillstyle(int style, int col)
	{
	pattern_num = style;
	fill_color = col;
	BrushColor = tricolors[col].colorref;
	}
    void setfillstyle(int style, COLORREF col)
	{
	pattern_num = style;
	BrushColor = col;
	}

    void moveto(int x, int y) { ::MoveTo(DC, x, y); }
    void lineto(int x, int y);
    void fillpoly(int numpoints, int* polypoints);
    void drawpoly(int numpoints, int far* points);
    };

/////////////////////////////////////////////////////////////////////////////
/*  KH_Paint class could draw graphics primitives using different libraries,
	 zoom, scroll, rotate (including complex rotations) and so on.
*/

struct _export KH_Paint : public To_Paint, public Paint
	 {
	KH_Paint();

        int getx();
        int gety();
	loc get_CP();
	void putpixel(int x, int y);
	void line(int xstart, int ystart, int xend, int yend)
	    { moveto(xstart, ystart); lineto(xend, yend); }

	void lineto(int x, int y);
	void moveto(int x, int y);
	void circle(int x, int y, int radius)
            { ellipse(x, y, 0, 360, radius, radius); }
	void ellipse(int x, int y, int stangle, int endangle, int xr, int yr);
	void rectangle(int left, int top, int right, int bottom);
	void drawpoly(int numpoints, int far* points);
	void fillpoly(int numpoints, int far* points)
	    { int f = fill; fill = ON; drawpoly(numpoints, points);
		 fill = f; }
	void bar3d(int l, int t, int r, int b, int d, int top);
	virtual void outtext(char* str, int dir = 0);
	void set_fill(int state) { fill = state; }
    };

#endif __BGI_PAINT_H_
