/*  Project slang
    
    Copyright  1995. All Rights Reserved.

    SUBSYSTEM:    slang.apx Application
    FILE:         helpdilg.cpp
    AUTHOR:       Stepan S.Vartanov


    OVERVIEW
    ========
    Source file for implementation of HelpDialog (TDialog).      
*/

#include <owl\owlpch.h>
#pragma hdrstop

#include "slang\helpdilg.h"
#include <stdio.h>

//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(HelpDialog, TDialog)
//{{HelpDialogRSP_TBL_BEGIN}}
    EV_BN_CLICKED(IDOK, OnOk),
    EV_WM_SHOWWINDOW,
//{{HelpDialogRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{HelpDialog Implementation}}


HelpDialog::HelpDialog (TWindow* parent, TResId resId, char* s):
	 TDialog(parent, resId, 0)
{
	 // INSERT>> Your constructor code here.
	 str = s;
	 lbListBox = new TListBox(parent, IDC_HELPLIST);
}


HelpDialog::~HelpDialog ()
{
	 Destroy();

	 // INSERT>> Your destructor code here.
	 delete lbListBox;
    lbListBox = NULL;

}


void HelpDialog::OnOk ()
{
	// INSERT>> Your code here.
	char s[256];
	if(lbListBox->GetSelString(s, 255))
		strcpy(str, s);
}
///////////////////////////////////////////////////////
void HelpDialog::EvShowWindow (bool show, uint status)
{
	 TDialog::EvShowWindow(show, status);
	 // INSERT>> Your code here.
	 char s[256];
	FILE* file;
	if((file = fopen("SLANGHLP.HL", "rb")) != 0)
		{
		while((fgets(s, 255, file)) != 0)
			lbListBox->AddString(s);
		fclose(file);
      lbListBox->Invalidate();
		}

	// End of my code

}

