/*  Project gdi_demo
    
    Copyright  1995. All Rights Reserved.

    SUBSYSTEM:    gdi_demo.exe Application
    FILE:         gd_dmapp.cpp
    AUTHOR:       S.Vartanov


    OVERVIEW
    ========
    Source file for implementation of gdi_demoApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop


#include "gd_dmapp.h"
#include "gd_dmwnd.h"                        // Definition of client class.       
#include "gd_dmabd.h"                        // Definition of about dialog.       

//{{gdi_demoApp Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(gdi_demoApp, TApplication)
//{{gdi_demoAppRSP_TBL_BEGIN}}
    EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
//{{gdi_demoAppRSP_TBL_END}}
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// gdi_demoApp
// =====
//
gdi_demoApp::gdi_demoApp () : TApplication("gdi_demo")
{

    // Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
    // computed in the member functions CmFileOpen, and CmFileSaveAs.
    FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
    FileData.SetFilter("All Files (*.*)|*.*|");

    // INSERT>> Your constructor code here.
}


gdi_demoApp::~gdi_demoApp ()
{
	 // INSERT>> Your destructor code here.
}


//////////////////////////////////////////////////////////
// gdi_demoApp
// =====
// Application intialization.
//
void gdi_demoApp::InitMainWindow ()
{
	 if (nCmdShow != SW_HIDE)
		  nCmdShow = (nCmdShow != SW_SHOWMINNOACTIVE) ? SW_SHOWMAXIMIZED : nCmdShow;

	 SDIDecFrame *frame = new SDIDecFrame(0, GetName(), 0, false);

	 // Override the default window style for the main window.
	 frame->Attr.Style |= WS_BORDER | WS_CAPTION | WS_CLIPCHILDREN | WS_SYSMENU | WS_VISIBLE;
	 frame->Attr.Style &= ~(WS_CHILD | WS_MAXIMIZEBOX | WS_MINIMIZEBOX | WS_THICKFRAME);

	 //
	 // Assign ICON w/ this application.
	 //
	 frame->SetIcon(this, IDI_SDIAPPLICATION);

	 //
	 // Menu associated with window and accelerator table associated with table.
	 //
	 frame->AssignMenu(SDI_MENU);

	 //
	 // Associate with the accelerator table.
	 //
	 frame->Attr.AccelTable = SDI_MENU;


	 SetMainWindow(frame);

	 frame->SetMenuDescr(TMenuDescr(SDI_MENU));
}


//{{SDIDecFrame Implementation}}


SDIDecFrame::SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, bool trackMenuSelection, TModule *module)
	 : TDecoratedFrame(parent, title, clientWnd == 0 ? new gdi_demoWindow(0, "") : clientWnd, trackMenuSelection, module)
{
	 // INSERT>> Your constructor code here.

}


SDIDecFrame::~SDIDecFrame ()
{
    // INSERT>> Your destructor code here.

}


//////////////////////////////////////////////////////////
// gdi_demoApp
// ===========
// Menu Help About gdi_demo.exe command
void gdi_demoApp::CmHelpAbout ()
{
	 //
	 // Show the modal dialog.
    //
    gdi_demoAboutDlg(MainWindow).Execute();
}
int OwlMain (int , char* [])
{
	 try {
        gdi_demoApp    app;
        return app.Run();
    }
    catch (xmsg& x) {
        ::MessageBox(0, x.why().c_str(), "Exception", MB_OK);
    }

    return -1;
}
