/*  Project gdi_demo
    
    Copyright  1995. All Rights Reserved.

    SUBSYSTEM:    gdi_demo.exe Application
    FILE:         gd_dmapp.cpp
    AUTHOR:       S.Vartanov


    OVERVIEW
    ========
    Source file for implementation of gdi_demoApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop


#include "gd_dmapp.h"
#include "gd_dmwnd.h"                        // Definition of client class.       
#include "gd_dmabd.h"                        // Definition of about dialog.       


//{{gdi_demoApp Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(gdi_demoApp, TApplication)
//{{gdi_demoAppRSP_TBL_BEGIN}}
    EV_COMMAND(CM_FILENEW, CmFileNew),
    EV_COMMAND(CM_FILEOPEN, CmFileOpen),
    EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
//{{gdi_demoAppRSP_TBL_END}}
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// gdi_demoApp
// =====
//
gdi_demoApp::gdi_demoApp () : TApplication("gdi_demo")
{

    // Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
    // computed in the member functions CmFileOpen, and CmFileSaveAs.
    FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
    FileData.SetFilter("All Files (*.*)|*.*|");

    // INSERT>> Your constructor code here.
}


gdi_demoApp::~gdi_demoApp ()
{
    // INSERT>> Your destructor code here.
}


void gdi_demoApp::SetupSpeedBar (TDecoratedFrame *frame)
{ 
    //
    // Create default toolbar New and associate toolbar buttons with commands.
    //   
    TControlBar* cb = new TControlBar(frame);
    cb->Insert(*new TButtonGadget(CM_FILENEW, CM_FILENEW));
    cb->Insert(*new TButtonGadget(CM_FILEOPEN, CM_FILEOPEN));
    cb->Insert(*new TButtonGadget(CM_FILESAVE, CM_FILESAVE));
    cb->Insert(*new TSeparatorGadget(6));
    cb->Insert(*new TButtonGadget(CM_EDITCUT, CM_EDITCUT));
    cb->Insert(*new TButtonGadget(CM_EDITCOPY, CM_EDITCOPY));
    cb->Insert(*new TButtonGadget(CM_EDITPASTE, CM_EDITPASTE));
    cb->Insert(*new TSeparatorGadget(6));
    cb->Insert(*new TButtonGadget(CM_EDITUNDO, CM_EDITUNDO));
    cb->Insert(*new TSeparatorGadget(6));
    cb->Insert(*new TButtonGadget(CM_EDITFIND, CM_EDITFIND));
    cb->Insert(*new TButtonGadget(CM_EDITFINDNEXT, CM_EDITFINDNEXT));

    // Add fly-over help hints.
    cb->SetHintMode(TGadgetWindow::EnterHints);

    frame->Insert(*cb, TDecoratedFrame::Top);
}


//////////////////////////////////////////////////////////
// gdi_demoApp
// =====
// Application intialization.
//
void gdi_demoApp::InitMainWindow ()
{
    if (nCmdShow != SW_HIDE)
        nCmdShow = (nCmdShow != SW_SHOWMINNOACTIVE) ? SW_SHOWMAXIMIZED : nCmdShow;

    SDIDecFrame *frame = new SDIDecFrame(0, GetName(), 0, true);

    // Override the default window style for the main window.
    frame->Attr.Style |= WS_BORDER | WS_CAPTION | WS_CLIPCHILDREN | WS_MAXIMIZEBOX | WS_MINIMIZEBOX | WS_SYSMENU | WS_VISIBLE;
    frame->Attr.Style &= ~(WS_CHILD | WS_THICKFRAME);

    //
    // Assign ICON w/ this application.
    //
    frame->SetIcon(this, IDI_SDIAPPLICATION);

    //
    // Menu associated with window and accelerator table associated with table.
    //
    frame->AssignMenu(SDI_MENU);
    
    //
    // Associate with the accelerator table.
    //
    frame->Attr.AccelTable = SDI_MENU;

    SetupSpeedBar(frame);

    TStatusBar *sb = new TStatusBar(frame, TGadget::Recessed,
                                    TStatusBar::CapsLock        |
                                    TStatusBar::NumLock         |
                                    TStatusBar::ScrollLock      |
                                    TStatusBar::Overtype);
    frame->Insert(*sb, TDecoratedFrame::Bottom);
  
    SetMainWindow(frame);

    frame->SetMenuDescr(TMenuDescr(SDI_MENU));
}


//////////////////////////////////////////////////////////
// gdi_demoApp
// ===========
// Menu File New command
void gdi_demoApp::CmFileNew ()
{
}


//////////////////////////////////////////////////////////
// gdi_demoApp
// ===========
// Menu File Open command
void gdi_demoApp::CmFileOpen ()
{
    //
    // Display standard Open dialog box to select a file name.
    //
    *FileData.FileName = 0;

    gdi_demoWindow *client = TYPESAFE_DOWNCAST(GetMainWindow()->GetClientWindow(), gdi_demoWindow);     // Client window for the frame.
    if (client->CanClose())
        if (TFileOpenDialog(GetMainWindow(), FileData).Execute() == IDOK)
            OpenFile();
}


void gdi_demoApp::OpenFile (const char *fileName)
{
    if (fileName)
        strcpy(FileData.FileName, fileName);

}


//{{SDIDecFrame Implementation}}


SDIDecFrame::SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, bool trackMenuSelection, TModule *module)
    : TDecoratedFrame(parent, title, clientWnd == 0 ? new gdi_demoWindow(0, "") : clientWnd, trackMenuSelection, module)
{
    // INSERT>> Your constructor code here.

}


SDIDecFrame::~SDIDecFrame ()
{
    // INSERT>> Your destructor code here.

}


//////////////////////////////////////////////////////////
// gdi_demoApp
// ===========
// Menu Help About gdi_demo.exe command
void gdi_demoApp::CmHelpAbout ()
{
    //
    // Show the modal dialog.
    //
    gdi_demoAboutDlg(MainWindow).Execute();
}
int OwlMain (int , char* [])
{
    try {
        gdi_demoApp    app;
        return app.Run();
    }
    catch (xmsg& x) {
        ::MessageBox(0, x.why().c_str(), "Exception", MB_OK);
    }

    return -1;
}
