#if !defined(__drawpane_h)              // Sentry, use file only if it's not already included.
#define __drawpane_h

/*  Project slang
    
    Copyright  1994,1996. All Rights Reserved.

    SUBSYSTEM:    slang.apx Application
    FILE:         drawpane.h
    AUTHOR:       S.Vartanov


	 OVERVIEW
	 ========
	 Class definition for DrawPane (TWindow).
*/

#include <owl\owlpch.h>
#pragma hdrstop


#include "slangapp.rh"            // Definition of all resources.
#include "general\strdup.h"

enum { MOUSE_IDLE,         // No action
		 MOUSE_SELECT,       // Resize selected area
		 MOUSE_SELECTED,     // Image pasted but not copied to BMP
		 MOUSE_DRAG,         // Grag pasted image
		 MOUSE_LT,           // Resize pasted image, left - top
		 MOUSE_RT,           // Resize pasted image, right - top
		 MOUSE_RB,           // Resize pasted image, right - bottom
		 MOUSE_LB            // Resize pasted image, left - bottom
	  };

//{{TWindow = DrawPane}}
class DrawPane : public TWindow
	 {
	 public:
		  HBITMAP hBmp;
		  HBITMAP hBmpOld;
		  BOOL first_draw;

		  int iMouseStatus;
		  TRect rSelection;
		  TRect rPrev;
		  TPoint pPrev;
		  HDC rubberDC;
		  BOOL isPasted; // Is clip picture pasted into selected area

		  char* fname;
// To be removed
HDC DC;
// ......

		  DrawPane (TWindow* parent, const char far* title = 0, TModule* module = 0);
		  virtual ~DrawPane ();

		  void setFileName(char* name) { delete fname; fname = str_dup(name); }
		  void draw(HDC dc);
		  void drawRubber(TRect& r);  // Draw rubber rectangle
//{{DrawPaneVIRTUAL_BEGIN}}
public:
	 virtual void Paint (TDC& dc, bool erase, TRect& rect);
//{{DrawPaneVIRTUAL_END}}

//{{DrawPaneRSP_TBL_BEGIN}}
protected:
	 void FileSave ();
	 void EvLButtonDown (uint modKeys, TPoint& point);
	 void EvMouseMove (uint modKeys, TPoint& point);
	 void EvLButtonUp (uint modKeys, TPoint& point);
	 void CopyToClipboard ();
	 void PasteFromClipboard ();
    void EditCopyTo();
	 void EnableCopy (TCommandEnabler &tce);
	 void EnablePaste (TCommandEnabler &tce);
//{{DrawPaneRSP_TBL_END}}
DECLARE_RESPONSE_TABLE(DrawPane);
};    //{{DrawPane}}


#endif                                      // __drawpane_h sentry.

