/*  Project slang

	 Copyright  1994,1996. All Rights Reserved.

	 SUBSYSTEM:    slang.apx Application
	 FILE:         drawpane.cpp
	 AUTHOR:       S.Vartanov


	 OVERVIEW
	 ========
	 Source file for implementation of DrawPane (TWindow).
*/

#include <owl\owlpch.h>
#pragma hdrstop
#include "drawpane.h"

#include "slang\bmp.h"
//#include "slang\extern.h"
#include "slang\win_ext.h"
#include "slangapp.h"

int MARKER_SIZE = 3;

//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(DrawPane, TWindow)
//{{DrawPaneRSP_TBL_BEGIN}}
	 EV_COMMAND(CM_FILESAVE, FileSave),
	 EV_WM_LBUTTONDOWN,
	 EV_WM_MOUSEMOVE,
	 EV_WM_LBUTTONUP,
	 EV_COMMAND(CM_EDITCOPY, CopyToClipboard),
	 EV_COMMAND(CM_EDITPASTE, PasteFromClipboard),
	 EV_COMMAND(CM_EDITCOPYTO, EditCopyTo),
	 EV_COMMAND_ENABLE(CM_EDITCOPY, EnableCopy),
	 EV_COMMAND_ENABLE(CM_EDITPASTE, EnablePaste),
	 EV_COMMAND_ENABLE(CM_EDITCOPYTO, EnableCopy),
//{{DrawPaneRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{DrawPane Implementation}}


DrawPane::DrawPane (TWindow* parent, const char far* title, TModule* module)
	 : TWindow(parent, "", module)
	 {
	 // INSERT>> Your constructor code here.
	 first_draw = TRUE;
	 iMouseStatus = MOUSE_IDLE;
	 rSelection.SetNull();   // Set 0,0,0,0
	 isPasted = FALSE;
	 fname = str_dup(title);
// To be removed
DC = 0;
// ......
	 hBmp = 0;
	 }
/////////////////////////////////////////////////////////////////
DrawPane::~DrawPane ()
	 {
	 Destroy();

	 // INSERT>> Your destructor code here.
	 delete fname;
	 if(DC)
		  {
		  hBmp = (HBITMAP)SelectObject(DC, hBmpOld);
		  DeleteObject(hBmp);
		  DeleteDC(DC);
		  }
	 }
////////////////////////////////////////////////////////////////////
void DrawPane::Paint (TDC& dc, bool erase, TRect& rect)
	 {
	 TWindow::Paint(dc, erase, rect);

	 // INSERT>> Your code here.
	 window_type = DRAW_WINDOW;
	 draw((HDC)dc);
	 }
//////////////////////////////////////////////////////////////
void DrawPane::draw(HDC dc)
	 {
//	 iMouseStatus = MOUSE_IDLE;
//	 rSelection.SetNull();   // Set 0,0,0,0

	 if(first_draw)
		  {
		  SetMapMode(dc, MM_ISOTROPIC);
		  SetWindowExt(dc, 1, 1);
		  SetViewportExt(dc, 1, 1);

		  DC = CreateCompatibleDC(dc);
		  hBmp = CreateCompatibleBitmap(dc, 1024, 1024);
		  hBmpOld = (HBITMAP)SelectObject(DC, hBmp);

		  HBRUSH hBrush = (HBRUSH)GetStockObject(WHITE_BRUSH);
        SelectObject(DC, hBrush);
		  RECT rc = { 0, 0, 1024, 1024 };
		  FillRect(DC, &rc, hBrush);

		  slang->DC = DC;
		  if(fname)
				slang->basic(slang->load_program(fname));

//		  MoveTo(DC, 0, 0);
//		  LineTo(DC, 200, 200);

		  first_draw = 0;
		  }

	 BitBlt(dc, 0, 0, 1024, 1024, DC, 0, 0, SRCCOPY);
	 }
///////////////////////////////////////////////////////////////////////
void DrawPane::FileSave ()
	 {
	 // INSERT>> Your code here.
	 char* szFileName = "WORK.BMP";
	 SaveDIBFile(hBmp, szFileName);
	 }
////////////////////////////////////////////////////////////////////////
void DrawPane::EditCopyTo()
	 {
	 // INSERT>> Your code here.
	 CopyToClipboard();
	 ////////////////
	 BITMAP bm;
	 drawRubber(rSelection);    // Remove rubber band
	 OpenClipboard();
	 HBITMAP hBitmap;
	 if((hBitmap = (HBITMAP)GetClipboardData(CF_BITMAP)) != 0)
		  {
		  slangApp *theApp = TYPESAFE_DOWNCAST(GetApplication(), slangApp);
		  theApp->FileData.Flags = OFN_HIDEREADONLY;
		  theApp->FileData.SetFilter("Bitmap (*.bmp)|*.BMP|");

		  strcpy(theApp->FileData.FileName, "*.bmp");
		  if(TFileSaveDialog(this, theApp->FileData).Execute() == IDOK)
				SaveDIBFile(hBmp, theApp->FileData.FileName);
		  }
	 CloseClipboard();

//	 drawRubber(rSelection);    // Show rubber band
	 }
////////////////////////////////////////////////////////////////////////
void DrawPane::drawRubber(TRect& r)
	 {
	 SetROP2(rubberDC, R2_NOT);
	 HBRUSH hBrush = (HBRUSH)GetStockObject(HOLLOW_BRUSH);
	 SelectObject(rubberDC, hBrush);

	 Rectangle(rubberDC, r.left, r.top, r.right, r.bottom);

	 hBrush = (HBRUSH)GetStockObject(BLACK_BRUSH);
	 SelectObject(rubberDC, hBrush);

	 TRect r1(r.left - MARKER_SIZE, r.top - MARKER_SIZE,
		  r.left + MARKER_SIZE, r.top + MARKER_SIZE);
	 Rectangle(rubberDC, r1.left, r1.top, r1.right, r1.bottom);

	 if(r1.right != r1.left)
		  {
		  TRect r2(r.right - MARKER_SIZE, r.top - MARKER_SIZE,
				r.right + MARKER_SIZE, r.top + MARKER_SIZE);
		  Rectangle(rubberDC, r2.left, r2.top, r2.right, r2.bottom);

		  if(r.top != r.bottom)
				{
				TRect r3(r.right - MARKER_SIZE, r.bottom - MARKER_SIZE,
					 r.right + MARKER_SIZE, r.bottom + MARKER_SIZE);
				Rectangle(rubberDC, r3.left, r3.top, r3.right, r3.bottom);

				TRect r4(r.left - MARKER_SIZE, r.bottom - MARKER_SIZE,
					 r.left + MARKER_SIZE, r.bottom + MARKER_SIZE);
				Rectangle(rubberDC, r4.left, r4.top, r4.right, r4.bottom);
				}
		  }
	 }
////////////////////////////////////////////////////////////////////////
void DrawPane::EvLButtonDown(uint modKeys, TPoint& point)
	 {
	 TWindow::EvLButtonDown(modKeys, point);
	 // INSERT>> Your code here.

	 switch(iMouseStatus)
		  {
		  case MOUSE_SELECTED:
				{
				pPrev = point;
				rPrev = rSelection;
//				drawRubber(rSelection);

				if(rSelection.Contains(point))
					 iMouseStatus = MOUSE_DRAG;
				else if(point.x > rSelection.left - MARKER_SIZE
					 && point.x < rSelection.left + MARKER_SIZE)
					 {
					 if(point.y > rSelection.top - MARKER_SIZE
						  && point.y < rSelection.top + MARKER_SIZE)
						  iMouseStatus = MOUSE_LT;
					 else if(point.y > rSelection.bottom - MARKER_SIZE
						  && point.y < rSelection.bottom + MARKER_SIZE)
						  iMouseStatus = MOUSE_LB;
					 }
				else if(point.x > rSelection.right - MARKER_SIZE
					 && point.x < rSelection.right + MARKER_SIZE)
					 {
					 if(point.y > rSelection.top - MARKER_SIZE
						  && point.y < rSelection.top + MARKER_SIZE)
						  iMouseStatus = MOUSE_RT;
					 else if(point.y > rSelection.bottom - MARKER_SIZE
						  && point.y < rSelection.bottom + MARKER_SIZE)
						  iMouseStatus = MOUSE_RB;
					 }
				else if(isPasted)
					 {
					 isPasted = FALSE;
					 BITMAP bm;
					 drawRubber(rSelection);    // Remove rubber band
					 iMouseStatus = MOUSE_IDLE;
					 OpenClipboard();
					 HBITMAP hBitmap;
					 if((hBitmap = (HBITMAP)GetClipboardData(CF_BITMAP)) != 0)
						  {
						  HDC hdcMem = CreateCompatibleDC(DC);
						  SelectObject(hdcMem, hBitmap);
						  GetObject(hBitmap, sizeof(BITMAP), (LPSTR)&bm);
						  SetStretchBltMode(DC, COLORONCOLOR);
						  StretchBlt(DC, rSelection.left, rSelection.top,
								rSelection.right - rSelection.left + 1,
								rSelection.bottom - rSelection.top + 1,
								hdcMem, 0, 0, bm.bmWidth, bm.bmHeight, SRCCOPY);
						  DeleteDC(hdcMem);
//						  Invalidate(TRUE);
						  BitBlt(rubberDC, 0, 0, 1024, 1024, DC, 0, 0, SRCCOPY);
						  }
					 CloseClipboard();
					 }
				else
					 {
					 drawRubber(rSelection);
					 iMouseStatus = MOUSE_IDLE;
					 }
				}
				break;
		  case MOUSE_IDLE:   // No action
				{
				pPrev = point;

				rSelection.left = point.x;
				rSelection.top = point.y;
				rSelection.right = point.x;
				rSelection.bottom = point.y;

				iMouseStatus = MOUSE_SELECT;
				rubberDC = GetDC(*this);

				drawRubber(rSelection);
				}
				break;
		 default:            // Impossible choices
			  break;
		  }
	 }
////////////////////////////////////////////////////////
void DrawPane::EvMouseMove (uint modKeys, TPoint& point)
	 {
	 TWindow::EvMouseMove(modKeys, point);
	 // INSERT>> Your code here.

	 switch(iMouseStatus)
		  {
		  case MOUSE_LT:           // Resize pasted image, left - top
				{
				rPrev = rSelection;
				drawRubber(rPrev);
				rSelection.left = point.x;
				rSelection.top = point.y;
				drawRubber(rSelection);
				}
				break;
		  case MOUSE_RT:           // Resize pasted image, right - top
				{
				rPrev = rSelection;
				drawRubber(rPrev);
				rSelection.right = point.x;
				rSelection.top = point.y;
				drawRubber(rSelection);
				}
				break;
		  case MOUSE_SELECT:       // Resize selected area
		  case MOUSE_RB:           // Resize pasted image, right - bottom
				{
				rPrev = rSelection;
				drawRubber(rPrev);
				rSelection.right = point.x;
				rSelection.bottom = point.y;
				drawRubber(rSelection);
				}
				break;
		  case MOUSE_LB:           // Resize pasted image, left - bottom
				{
				rPrev = rSelection;
				drawRubber(rPrev);
				rSelection.left = point.x;
				rSelection.bottom = point.y;
				drawRubber(rSelection);
				}
				break;

		  case MOUSE_DRAG:         // Grag pasted image
				{
				rPrev = rSelection;
				drawRubber(rPrev);

				int deltax = point.x - pPrev.x;
				int deltay = point.y - pPrev.y;
				rSelection.left += deltax;
				rSelection.top += deltay;
				rSelection.right += deltax;
				rSelection.bottom += deltay;
				pPrev = point;
				drawRubber(rSelection);
				}
				break;
		  default:
				break;
		  }
	 }
//////////////////////////////////////////////////////////////////////
void DrawPane::EvLButtonUp (uint modKeys, TPoint& point)
	 {
	 TWindow::EvLButtonUp(modKeys, point);

	 // INSERT>> Your code here.
	 switch(iMouseStatus)
		  {
		  case MOUSE_LT:           // Resize pasted image, left - top
		  case MOUSE_RT:           // Resize pasted image, right - top
		  case MOUSE_RB:           // Resize pasted image, right - bottom
		  case MOUSE_LB:           // Resize pasted image, left - bottom
		  case MOUSE_DRAG:         // Grag pasted image
				{
				drawRubber(rSelection);    // Remove rubber band
//				Invalidate(TRUE);
				BitBlt(rubberDC, 0, 0, 1024, 1024, DC, 0, 0, SRCCOPY);
				iMouseStatus = MOUSE_SELECTED;
				if(!isPasted)
					 {
					 drawRubber(rSelection);    // Show rubber band
					 break;
					 }

				BITMAP bm;

				OpenClipboard();
				HBITMAP hBitmap;
				if((hBitmap = (HBITMAP)GetClipboardData(CF_BITMAP)) != 0)
					 {
					 HDC hdcMem = CreateCompatibleDC(rubberDC);
					 SelectObject(hdcMem, hBitmap);
					 GetObject(hBitmap, sizeof(BITMAP), (LPSTR)&bm);
					 SetStretchBltMode(DC, COLORONCOLOR);
					 StretchBlt(rubberDC, rSelection.left, rSelection.top,
							rSelection.right - rSelection.left + 1,
							rSelection.bottom - rSelection.top + 1,
							hdcMem, 0, 0, bm.bmWidth, bm.bmHeight, SRCCOPY);
					 DeleteDC(hdcMem);
					 }
				CloseClipboard();

				drawRubber(rSelection);    // Show rubber band
				}
				break;
		  case MOUSE_SELECT:       // Resize selected area
				{
				iMouseStatus = MOUSE_SELECTED;
				}
				break;

		  default:
				break;
		  }
	 ReleaseDC(*this, rubberDC);
	 }


/////////////////////////////////////////////////////////////////////////
void DrawPane::CopyToClipboard ()
	 {
	 // INSERT>> Your code here.
	 HBITMAP hBitmap;
	 HDC hdcMem = CreateCompatibleDC(rubberDC);
	 int w, h;
	 hBitmap = CreateCompatibleBitmap(rubberDC,
		  w = rSelection.right - rSelection.left + 1,
		  h = rSelection.bottom - rSelection.top + 1);
	 drawRubber(rSelection);
	 if(hBitmap)
		  {
		  SelectObject(hdcMem, hBitmap);
		  StretchBlt(hdcMem, 0, 0, w, h, rubberDC,
				rSelection.left, rSelection.top, w, h, SRCCOPY);
		  OpenClipboard();
		  EmptyClipboard();
		  SetClipboardData(CF_BITMAP, hBitmap);
		  CloseClipboard();
		  }
	 drawRubber(rSelection);
	 DeleteDC(hdcMem);
	 }


void DrawPane::PasteFromClipboard ()
	 {
	 // INSERT>> Your code here.
	 isPasted = TRUE;

	 BITMAP bm;
	 drawRubber(rSelection);    // Remove rubber band
	 OpenClipboard();
	 HBITMAP hBitmap;
	 if((hBitmap = (HBITMAP)GetClipboardData(CF_BITMAP)) != 0)
		  {
		  HDC hdcMem = CreateCompatibleDC(rubberDC);
		  SelectObject(hdcMem, hBitmap);
		  GetObject(hBitmap, sizeof(BITMAP), (LPSTR)&bm);
		  SetStretchBltMode(DC, COLORONCOLOR);
		  StretchBlt(rubberDC, rSelection.left, rSelection.top,
							rSelection.right - rSelection.left + 1,
							rSelection.bottom - rSelection.top + 1,
							hdcMem, 0, 0, bm.bmWidth, bm.bmHeight, SRCCOPY);
		  DeleteDC(hdcMem);
		  }
	 CloseClipboard();

	 drawRubber(rSelection);    // Show rubber band
	 }
////////////////////////////////////////////////////////////////////
void DrawPane::EnableCopy (TCommandEnabler &tce)
{
	 // INSERT>> Your code here.
	 if(iMouseStatus == MOUSE_SELECTED && !isPasted)
		  tce.Enable(TRUE);
	 else
		  tce.Enable(FALSE);
}
////////////////////////////////////////////////////////////////////
void DrawPane::EnablePaste (TCommandEnabler &tce)
	 {
	 // INSERT>> Your code here.
	 OpenClipboard();
	 if(iMouseStatus == MOUSE_SELECTED && GetClipboardData(CF_BITMAP) != 0)
		  tce.Enable(TRUE);
	 else
		  tce.Enable(FALSE);
	 CloseClipboard();
	 }



