#if !defined(__textpane_h)              // Sentry, use file only if it's not already included.
#define __textpane_h

/*  Project slang
    
    Copyright  1994,1996. All Rights Reserved.

    SUBSYSTEM:    slang.apx Application
    FILE:         textpane.h
    AUTHOR:       S.Vartanov


    OVERVIEW
    ========
    Class definition for TextPane (TWindow).      
*/

#include <owl\owlpch.h>
#pragma hdrstop


#include "slangapp.rh"            // Definition of all resources.

// Dimentions of text screen
#define NUM_OF_RAW          25
#define NUM_OF_COL          80

//{{TWindow = TextPane}}
class TextPane : public TWindow
    {
    public:
	    char** screen;
	    int xpos, ypos;  // 0, 0, 79, 24
       int start_x, start_y;


        TextPane (TWindow* parent, const char far* title = 0,
            TModule* module = 0);
		  virtual ~TextPane ();
        void show_text(char* text);

//{{TextPaneVIRTUAL_BEGIN}}
public:
    virtual void Paint (TDC& dc, bool erase, TRect& rect);
//{{TextPaneVIRTUAL_END}}

//{{TextPaneRSP_TBL_BEGIN}}
protected:
    void EvSize (uint sizeType, TSize& size);
//{{TextPaneRSP_TBL_END}}
DECLARE_RESPONSE_TABLE(TextPane);
};    //{{TextPane}}


#endif                                      // __textpane_h sentry.

