#if !defined(__slangapp_h)              // Sentry, use file only if it's not already included.
#define __slangapp_h

/*  Project slang
    
    Copyright  1994,1996. All Rights Reserved.

    SUBSYSTEM:    slang.exe Application
    FILE:         slangapp.h
    AUTHOR:       S.Vartanov


    OVERVIEW
    ========
    Class definition for slangApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop

#include "slngmdic.h"
#include "slangapp.rh"            // Definition of all resources.


//{{TApplication = slangApp}}
class slangApp : public TApplication {
private:
    bool            HelpState;                          // Has the help engine been used.
    bool            ContextHelp;                        // SHIFT-F1 state (context sensitive HELP)
    HCURSOR         HelpCursor;                         // Context sensitive help cursor

    void SetupSpeedBar (TDecoratedMDIFrame *frame);

public:
    slangApp ();
    virtual ~slangApp ();

    TOpenSaveDialog::TData  FileData;                   // Data to control open/saveas standard dialog.

    slangMDIClient  *mdiClient;

    // Public data members used by the print menu commands and Paint routine in MDIChild.
    TPrinter        *Printer;                           // Printer support.
    int             Printing;                           // Printing in progress.

//{{slangAppVIRTUAL_BEGIN}}
public:
    virtual void InitMainWindow();
    virtual bool CanClose ();
    virtual bool ProcessAppMsg (MSG& msg);
//{{slangAppVIRTUAL_END}}

//{{slangAppRSP_TBL_BEGIN}}
protected:
    void CmHelpContents ();
    void CmHelpUsing ();
    void CmHelpAbout ();
    void EvWinIniChange (char far* section);
//{{slangAppRSP_TBL_END}}
DECLARE_RESPONSE_TABLE(slangApp);
};    //{{slangApp}}


#endif                                      // __slangapp_h sentry.
