/*  Project slang
    
    Copyright  1994,1996. All Rights Reserved.

    SUBSYSTEM:    slang.apx Application
    FILE:         mdidraw.cpp
    AUTHOR:       S.Vartanov


    OVERVIEW
    ========
    Source file for implementation of MDIDraw (TMDIChild).      
*/

#include <owl\owlpch.h>
#pragma hdrstop

#include "mdidraw.h"
#include "slang\win_ext.h"
//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(MDIDraw, TMDIChild)
//{{MDIDrawRSP_TBL_BEGIN}}
//{{MDIDrawRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{MDIDraw Implementation}}


MDIDraw::MDIDraw (TMDIClient& parent, const char far* title, TWindow* clientWnd, bool shrinkToClient, TModule* module):
	 TMDIChild(parent, title, clientWnd == 0 ? new DrawPane(0, title) : clientWnd, shrinkToClient, module)
{
	 // Override the default window style for TMDIChild.
	 Attr.Style |= WS_BORDER | WS_CAPTION | WS_CHILD | WS_CLIPCHILDREN | WS_MAXIMIZEBOX | WS_MINIMIZEBOX | WS_SYSMENU | WS_VISIBLE | WS_THICKFRAME;
//    Attr.Style &= ~(WS_THICKFRAME);

	 // INSERT>> Your constructor code here.
	 dr = this;
}


MDIDraw::~MDIDraw ()
{
	 Destroy();

	 // INSERT>> Your destructor code here.
	 char s[256];
	 GetWindowText(s, 255);
	 if(childList)
		  delete childList->remove(childList->find(s));

	 dr = NULL;
}



