/*  Project slang
    
    Copyright  1994,1996. All Rights Reserved.

    SUBSYSTEM:    slang.apx Application
    FILE:         io_win.cpp
    AUTHOR:       S.Vartanov


    OVERVIEW
    ========
    Source file for implementation of IO_Window (TMDIChild).      
*/

#include <owl\owlpch.h>
#pragma hdrstop

#include "io_win.h"
///////////////////////////////////////
#include "slang\win_ext.h"
#include <stdio.h>
//{{IO_Window Implementation}}


IO_Window::IO_Window (TMDIClient& parent, TWindow* clientWnd,
	 bool shrinkToClient, TModule* module):
	 TMDIChild(parent, "Output", clientWnd,
		  shrinkToClient, module)
{
	 // Override the default window style for TMDIChild.
	 Attr.Style |= WS_BORDER | WS_CAPTION | WS_CHILD | WS_CLIPCHILDREN | WS_MAXIMIZEBOX | WS_MINIMIZEBOX | WS_SYSMENU | WS_VISIBLE;
//	 Attr.Style &= ~(WS_THICKFRAME);

	 // INSERT>> Your constructor code here.
	 outwin = this;
	 image = (TextPane*)clientWnd;
}


IO_Window::~IO_Window ()
{
	 Destroy();

	 // INSERT>> Your destructor code here.
	 outwin = NULL;
}
////////////////////////////////////////////
int IO_Window::printf(double argument)
  {
  char s[NUM_OF_COL + 2];
  sprintf(s, "%f", argument);
  image->show_text(s);
  return strlen(s);
  }
///////////
int IO_Window::printf(char * argument)
  {
  image->show_text(argument);
  return strlen(argument);
  }
////////////////////////////////////////////////////////
int IO_Window::printf(char * format, double argument)
  {
  char s[NUM_OF_COL + 2];
  sprintf(s, format, argument);
  image->show_text(s);
  return strlen(s);
  }
////////////////////////////////////////////////////////////////

