
#include <malloc.h>
#include <windows.h>
#include <windowsx.h>

#if defined( __WINDOWS_386__ ) || defined( __NT__ )
   #define  _EXPORT
#else
   #define  _EXPORT __export
#endif

#include "hds_com.h"
void your_main(HWND hwnd);
long _EXPORT FAR PASCAL WindowProc( HWND, unsigned, UINT, LONG );
static BOOL  FirstInstance( HANDLE );
static BOOL AnyInstance( HANDLE, int, LPSTR );
void window_destroy(HWND hwnd);
void stt HDS_left_up(HWND hwnd,int x,int y,UINT keyFlags);
void stt HDS_left_down(HWND hwnd,BOOL fDoubleClick,int x,int y,UINT keyFlags);
void stt HDS_right_up(HWND hwnd,int x,int y,UINT keyFlags);
void stt HDS_right_down(HWND hwnd,BOOL fDoubleClick,int x,int y,UINT keyFlags);
void stt HDS_mouse_moved(HWND hwnd,int x,int y,UINT keyFlags);
void stt HDS_key_pressed(HWND hwnd,UINT ch,int cRepeat);

HANDLE MyInstance;

/*******************************************************************/
/* initialization of main window and main loops                    */
/* send any messages to WinProc                                    */
/*******************************************************************/

   int PASCAL WinMain( HANDLE this_inst, HANDLE prev_inst, LPSTR cmdline,
                       int cmdshow )
   {
/*       MSG          msg; */
       MyInstance = this_inst;

       SetMessageQueue(1);
       prev_inst = 0;
       if(!prev_inst ) {
           if(!FirstInstance( this_inst ) ) return( FALSE );
       }
       if(!AnyInstance( this_inst, cmdshow, cmdline ) ) return( FALSE );

/* you can add message handling here */
/*       return( msg.wParam ); */
       return (1);
   }

/********************************************************************/
/* register window class for the application and do any other       */
/* application initialization                                       */
/********************************************************************/

   static BOOL FirstInstance( HANDLE this_inst )
   {
       WNDCLASS    wc;
       BOOL        rc;

/* set up and register window class */

       wc.style = CS_HREDRAW | CS_VREDRAW;
       wc.lpfnWndProc = (LPVOID) WindowProc;
       wc.cbClsExtra = 0;
       wc.cbWndExtra = sizeof( DWORD );
       wc.hInstance = this_inst;
       wc.hIcon = LoadIcon( this_inst, NULL );
       wc.hCursor = LoadCursor( NULL, IDC_ARROW );
       wc.hbrBackground = GetStockObject( BLACK_BRUSH );
       wc.lpszMenuName = "\0";
       wc.lpszClassName = "HDR_demo";
       rc = RegisterClass( &wc );
    return( rc );
} 
/************************************************************************/
/* do main work for every instance (create window, initialize the data  */
/*   etc.                                                               */
/************************************************************************/

   static BOOL AnyInstance( HANDLE this_inst, int cmdshow, LPSTR cmdline )
   {
       HWND        hwnd;
       int         screen_x=640,screen_y=480;
    
/* create the main window */

       hwnd = CreateWindow(
           "HDR_demo",                 /* class          */
           "hello",                    /* caption        */
           WS_POPUP,                   /* style          */
           0,                          /* init. x pos    */
           0,                          /* init. y pos    */
           screen_x,                   /* init. x size   */
           screen_y,                   /* init. y size   */
           NULL,                       /* parent window  */
           NULL,                       /* menu handle    */
           this_inst,                  /* program handle */
           NULL                        /* create parms   */
       );

       if( !hwnd ) return( FALSE );

/* display window */

       ShowWindow( hwnd, cmdshow );
       UpdateWindow( hwnd );

/* call your program  */
       your_main(hwnd); 

/*************************************************************************************/

    return( TRUE );
} 

/*************************************************************************/
/* WindowProc - handle messages for the main application window          */
/* handle the button (mouse) clicks                                      */
/*************************************************************************/

LONG _EXPORT FAR PASCAL WindowProc( HWND hwnd, unsigned msg,
                                     UINT wParam, LONG lParam )
{
    HDC testdc;

    switch( msg )
    {
       HANDLE_MSG(hwnd,WM_DESTROY,window_destroy);
       HANDLE_MSG(hwnd,WM_LBUTTONUP,HDS_left_up);
       HANDLE_MSG(hwnd,WM_LBUTTONDOWN,HDS_left_down);
       HANDLE_MSG(hwnd,WM_RBUTTONUP,HDS_right_up);
       HANDLE_MSG(hwnd,WM_RBUTTONDOWN,HDS_right_down);
       HANDLE_MSG(hwnd,WM_MOUSEMOVE,HDS_mouse_moved);
       HANDLE_MSG(hwnd,WM_CHAR,HDS_key_pressed);
       case WM_SETFOCUS:
              testdc=GetDC(hwnd);
	      HDS_make_master_palette(testdc);
	      ReleaseDC(hwnd,testdc);
	      break;
    }
    return( DefWindowProc( hwnd, msg, wParam, lParam ) );
} 
/**************************************************************/
/* stop messaging on a window                                 */
/* stop the program                                           */

    void window_destroy(HWND hwnd)
    {
       PostQuitMessage(0);
    }
