/**************************************************************************/
/* this demo is similar to hds_dem5, except that a different animation    */
/* algorithm is used, and no explosion in the center takes place.         */
/* It bounces spheres around the screen. When a purple sphere touches     */
/* the right side of the screen it changes color to green.  A counter     */
/* keeps attract of how many are left to convert                          */
/**************************************************************************/
/* these include files are specific to the way this particular demo      */
/* was developed.  Other applications will include the functions a       */
/* slightly different way                                                */

# define nspheres 120 /* number of spheres in simulation */

#include <math.h>        /* standard c math library */
#include <windows.h>     /* standard windows include files */
#include <stdio.h>       /*standard c i/o header file */

#include "hds_lib.h"     /* function prototypes for library*/
#include "hds_enum.h"    /* enumerated types */
#include "winmain.c"     /* code to produce a window */
#include "hds_dem6.h"    /* variables used in this demo and demo 6 */

/*************************************************************************/

  HDC  mem_dc[5];
  HBITMAP mem_bit[5];
  HDC  dc_screen;

void your_main(HANDLE hwnd)  /* called by winmain after a window is created */
{

  int  num_colors;
  int  temp,sizex,sizey;
  int  cstart=10,i;

  dc_screen=HDS_getdc(hwnd);           /*get device (i.e. screen) as the location to draw on */
  HDS_make_master_palette(dc_screen);  /*make the initial color palette*/

/*****************************************************************/



/* add the sphere bitmap colors to the system colormap */
  temp=cstart;
  num_colors=HDS_get_numcolors("hds_gsh.bmp");
  HDS_add_bitmap_colors(dc_screen,"hds_gsh.bmp",temp,num_colors);

  temp+=num_colors;
  num_colors=HDS_get_numcolors("hds_psh.bmp");
  HDS_add_bitmap_colors(dc_screen,"hds_psh.bmp",temp,num_colors);

  temp+=num_colors;
  num_colors=HDS_get_numcolors("par3.bmp");
  HDS_add_bitmap_colors(dc_screen,"par3.bmp",temp,num_colors);
/* display copyright */
  demo_text(-1,dc_screen,hwnd);
  get_start();  /* get the starting position of the spheres */

/* draw the parrot background on the screen */

 HDS_bitmap_tile(0,0,640,480,"par3.bmp",dc_screen,hwnd);

/* display copyright and other text*/
  demo_text(-1,dc_screen,hwnd);
  demo_text(2,dc_screen,hwnd);

/* make 2 buffer (memory areas) the same size as the screen */
/* buffer 1 holds will hold a copy of the background */
/* buffer 2 will get a copy of the background from buffer 1 */
/* and then has the animation drawn on it */

  HDS_make_memory_dc(dc_screen,&mem_dc[0],&mem_bit[0],screenx,screeny);
  HDS_make_memory_dc(dc_screen,&mem_dc[1],&mem_bit[1],screenx,screeny);

/* copy the screen to buffer 1 which will hold the background */
  HDS_copy_rect(dc_screen,mem_dc[0],0,0,screenx,screeny,0,0);

  HDS_get_size("hds_gsh.bmp",&sizex,&sizey);

/* make 3 memory areas (1 for purple sphere, 1 for green sphere,
   and 1 for the mask (purple and green spheres use same mask) */

  for (i=2;i<5;i++) {
    HDS_make_memory_dc(dc_screen,&mem_dc[i],&mem_bit[i],sizex,sizey);
  }

/* draw the images and masks in the appropriate memory areas */
  HDS_drawbitmap(hwnd,mem_dc[2],0,0,"hds_psh.bmp",0);
  HDS_drawbitmap(hwnd,mem_dc[3],0,0,"hds_pshm.bmp",0);
  HDS_drawbitmap(hwnd,mem_dc[4],0,0,"hds_gsh.bmp",0);

/* next we move the spheres around until user clicks mouse */
  move_spheres(dc_screen,hwnd);

/* done with demo--> now clean up memory and free all */
/* the resources */
/* we must delete all the memory areas that we created */

  for (i=0;i<5;i++) {
    HDS_clean_up(&mem_dc[i],&mem_bit[i]);
  }
  HDS_reldc(hwnd,dc_screen);
  HDS_clean_all();
}

/************************************************************************/
/*              demo functions                                          */
/* these are functions that we wrote that are specific to this demo.    */
/* Note that these functions use many different calls to our graphic    */
/* library (all function that start with HDS).                          */

/**************************************************************/
/* display some information text to the screen                */

    void demo_text(int index,HDC dc_screen,HWND hwnd) {
      if (index==-1) {
        HDS_draw_text(WHITE,0,"Copyright @ 1996",420,420,1,2, 3,14,2,0,dc_screen);
        HDS_draw_text(WHITE,0,"Higher Dimension Research, Inc.",420,430,1,2, 3,14,2,0,dc_screen);
        HDS_draw_text(WHITE,0,"all rights reserved",420,440,1,2, 3,14,2,0,dc_screen);
        HDS_draw_text(BLUE,0,"original photo was by Steve Kelly",420,460,1,2, 3,14,2,0,dc_screen);
      } else if (index==2) {
        HDS_draw_text(GREEN,0,"Click the left button to EXIT",0,440,1,2, 3,25,2,0,dc_screen);
      }
    }

/********************************************************************/
/* give all the spheres a starting positions somewhere in the first */
/* quarter of the screen in the x direction                         */

  void get_start() {

    int i,ns=0,iflag;
    int minx=diameter,maxx=200;
    int miny=diameter,maxy=screeny-diameter;
    int randx,randy;
    int dist;

    HDS_random_seed();
    for (i=0;i<nspheres;i++) {
        destroy[ns]=0;
        rand_direction(i);  /* get the initial direction */
    }

    while (ns<nspheres) {
       iflag=0;
       randx=minx+HDS_rand_zero(maxx-minx);
       randy=miny+HDS_rand_zero(maxy-miny);
       for (i=0;i<ns;i++) {
           dist=HDS_calc_distance(im_pos[i].x,im_pos[i].y,randx,randy);
           if (dist<diameter) {
               iflag=1;
               break;
           }
       }
       if (iflag==0) {
           im_pos[ns].x=randx;
           im_pos[ns].y=randy;
           ns++;
       }
    }

    }

/************************************************************/
/* get a new sphere position                                */

    int new_position(int isphere) {

      int new_x, new_y;
      int iflag=1;
      int icolor=0;

      new_x=im_pos[isphere].x+direction[isphere].x*jump;
      new_y=im_pos[isphere].y+direction[isphere].y*jump;

/* check all four walls */
      if (new_x<diameter) {
          iflag=0;
      } else if (new_x>screenx-diameter) {
	  icolor=1;
          iflag=0;
      } else if (new_y<diameter) {
          iflag=0;
      } else if (new_y>screeny-diameter) {
          iflag=0;
      }


/* if there is a wall collision then change directions */

      if (iflag==0) {
          rand_direction(isphere);
      } else {
          im_pos[isphere].x=new_x;
          im_pos[isphere].y=new_y;
      }
      return (icolor);
  }

/**************************************************************/
/* return a random direction                                  */

      void rand_direction(int isphere) {

        int maxa=100;
        int maxah=maxa/2;
        int pm,randx;
        float vx,vy;

        randx=HDS_rand_one(maxa);
        vx=(randx-maxah)/(float)(maxah);
        if (vx==0.0) vx+=0.1;
        vy=sqrt(1.0-vx*vx);
        pm=HDS_rand_zero(1);
        direction[isphere].x=vx;
        if (pm==0) vy*=(-1);
        direction[isphere].y=vy;
      }

/*********************************************************************/
/* move spheres until all are destroyed or user has clicked the right*/
/* mouse button                                                      */

    void move_spheres(HDC dc_screen,HWND hwnd) {
       int i;
       int icount=nspheres;
       int sizex,sizey;
       int x,y,col;
       char count[3];

       HDS_get_size("hds_gsh.bmp",&sizex,&sizey);
       while (nleft>0 && (HDS_check_mouse(hwnd,1)==0)) {

/* copy background buffer to working buffer */
          HDS_copy_rect(mem_dc[0],mem_dc[1],0,0,screenx,screeny,0,0);

/* when the sphere hits the right wall then change its color and */
/* play a sound */
          for (i=0;i<nspheres;i++) {
	       col=new_position(i);
	       if (col==1) {
		   if (color[i]==0) {
		       icount--;
		       HDS_play_wav("bump.wav",0);
		   }
		   color[i]=1;
	       }
               x=im_pos[i].x; y=im_pos[i].y;
/* copy mask bitmap to the buffer*/
/* remember, masks allow for transparent color */
               HDS_copy_mrect(mem_dc[3],mem_dc[1],0,0,sizex,sizey,x,y,1);
/* copy either green or purple ball to the buffer */
	       if (color[i]==0) {
                  HDS_copy_mrect(mem_dc[2],mem_dc[1],0,0,sizex,sizey,x,y,2);
	       }else{
                  HDS_copy_mrect(mem_dc[4],mem_dc[1],0,0,sizex,sizey,x,y,2);
	       }
          }
/* tell how many spheres all left to change color */
	  sprintf(count,"%d",icount);
          HDS_draw_text(RED,0,count,550,50,1,2,3,50,3,0,mem_dc[1]);
/* copy buffer to screen */
          HDS_copy_rect(mem_dc[1],dc_screen,0,0,screenx,screeny,0,0);
       }
    }

