
/**************************************************************************/
/* This example shows some things that can be done with some of the       */
/* animation, sound, and color resources available.  The demo was designed*/
/* for a 640x480 256 color display.  These functions can work with any    */
/* resolution and various color schemes.                                  */
/* This demo was written in the c language, but the function calls        */
/* themselves could be called from any language or application            */
/*                                                                        */
/* copyright @ 1996 by Higher Dimension Research, Inc.                    */
/**************************************************************************/
/* these include files are specific to the way this particular demo      */
/* was developed.  Other applications will include the functions a       */
/* slightly different way                                                */

# define nspheres 10     /* number of spheres in simulation */
#include <windows.h>
#include <math.h>        /* standard c math library */
#include "hds_lib.h"     /* function prototypes for library*/
#include "hds_enum.h"    /* enumerated types */
#include "winmain.c"     /* code to produce a window */
#include "hds_dem6.h"    /* variables, and arrays used only in this demo */
                         /*     and in demo6 */
/*************************************************************************/

void your_main(HANDLE hwnd)  /* called by winmain after a window is created */
{

  int  num_colors;
  int  temp,sizex,sizey;
  int  numx,numy;
  int  cstart=10,x,y;
  int  i,j;
  int  left=0;
  HDC  dc_screen;


  dc_screen=HDS_getdc(hwnd);           /*get device (i.e. screen) as the location to draw on */
  HDS_make_master_palette(dc_screen);  /*make the initial color palette*/

/* add the colors that are in the bitmaps */
/* to the system color map */

  num_colors=HDS_get_numcolors("hds_back.bmp");
  HDS_add_bitmap_colors(dc_screen,"hds_back.bmp",cstart,num_colors);

  temp=cstart+num_colors;
  num_colors=HDS_get_numcolors("hds_b2.bmp");
  HDS_add_bitmap_colors(dc_screen,"hds_b2.bmp",temp,num_colors);

/* repeat the background bitmap by using the tile function */
/* to fill the screen */

  HDS_bitmap_tile(0,0,640,480,"hds_b2.bmp",dc_screen,hwnd);
  HDS_bitmap_tile(360,110,580,335,"hds_back.bmp",dc_screen,hwnd);

/* make raised panels directly on the screen (doing this in memory and then */
/* blasting the final result to the screen would hide the drawing process */
/* from the user as demonstrated in the other demos and would also       */
/* be much faster for drawing other panels of the same size, but it is   */
/* shown this way to show that the panel is being created and is not     */
/* simply a bitmap) */

  HDS_draw_border(dc_screen,4,360,110,580,335,1,-60,60,30);  /*main frame*/
  HDS_draw_border(dc_screen,9,391,141,550,300,-1,-70,70,40); /*picture*/

/* add the center bitmap background colors to the system colormap */
  temp+=num_colors;
  num_colors=HDS_get_numcolors("hds_gt.bmp");
  HDS_add_bitmap_colors(dc_screen,"hds_gt.bmp",temp,num_colors);

/* add the sphere bitmap colors to the system colormap */
  temp+=num_colors;
  num_colors=HDS_get_numcolors("hds_psh.bmp");
  HDS_add_bitmap_colors(dc_screen,"hds_psh.bmp",temp,num_colors);

/* add the cloud background colormap to the system colormap*/
  temp+=num_colors;
  num_colors=HDS_get_numcolors("hds_c.bmp");
  HDS_add_bitmap_colors(dc_screen,"hds_c.bmp",temp,num_colors);

/* draw the cloud bitmap inside the raised panel */
  HDS_drawbitmap(hwnd,dc_screen,400,150,"hds_c.bmp",0);

/* display copyright */
  demo_text(-1,dc_screen,hwnd);

/* draw the color palette */

  HDS_display_colors(dc_screen,0,255,15);
  demo_text(0,dc_screen,hwnd);

  HDS_clear_queue(hwnd);     /* remove all previous messages */
  HDS_get_mouse(left,hwnd);  /* wait for the user to click left mouse button*/

/* show how rotating the color slots creates animation (note that by rotating) */
/* the slots the same number of times as the total color slots rotated we */
/* restore the original image after color rotation */

  for (i=0;i<num_colors;i++) {
    HDS_delay_mil_seconds(100);  /*add a delay so the slots are not rotated*/
                                 /*too fast */
    HDS_color_rotate(dc_screen,temp,temp+num_colors-1);
  }

/* inform the user of the demo progress and wait for left mouse click */
  demo_text(1,dc_screen,hwnd);
  HDS_clear_queue(hwnd);  /* clear any previous mouse clicks */
  HDS_get_mouse(left,hwnd);

/* second part of the animation */
/* this part shows actual flicker free bitmap animation */

  get_start();  /* get the starting position of the spheres */
  HDS_draw_frect(BLACK,0,0,screenx,screeny,dc_screen);  /* clear the screen*/

/* draw the background bitmap */
  HDS_drawbitmap(hwnd,dc_screen,0,0,"hds_b2.bmp",0);

/* get the size of the bitmap */
  HDS_get_size("hds_b2.bmp",&sizex,&sizey);

/* make a single individual tile pattern for the background in the */
/* upper left corner */

  HDS_draw_border(dc_screen,3,0,0,sizex,sizey,1,-70,70,40);
  HDS_draw_border(dc_screen,3,10,10,sizex-10,sizey-10,-1,-70,70,40);
  numx=640/sizex+1;
  numy=480/sizey+1;

/* repeat this first pattern to fill the screen */
  for (j=0;j<numy;j++) {
    for (i=0;i<numx;i++) {
        x=i*sizex; y=j*sizey;
        if (i!=0 || j!=0 )
          HDS_copy_rect(dc_screen,dc_screen,0,0,sizex,sizey,x,y);
    }
  }

/* display copyright and other text*/
  demo_text(-1,dc_screen,hwnd);
  demo_text(2,dc_screen,hwnd);


/* make the middle tile special.  Since our bitmap is not the correct */
/* size we can use the tile function to draw only a portion of the    */
/* bitmap */
/* you could also use a paint package to make this center title      */
/* and then display with the bitmap functions                        */

      x=5*sizex; y=3*sizey; sx3=3*sizex;  sy3=3*sizey;
      HDS_bitmap_tile(x,y,x+sx3,y+sy3,"hds_gt.bmp",dc_screen,hwnd);
      HDS_draw_border(dc_screen,3,x,y,x+sx3,y+sy3,1,-80,80,30);
      HDS_draw_border(dc_screen,3,x+10,y+10,x+sx3-10,y+sy3-10,-1,-70,70,40);
      HDS_draw_frect(BLACK,x+13,y+13,x+sx3-13,y+sy3-13,dc_screen);

/* create memory dc's and draw the spheres */
/* here we create memory location that store the purple sphere bitmap */
/* and then draw all the spheres on the screen */

  for (i=0;i<nspheres;i++) {
    HDS_anim_createm_dc(i,"hds_psh.bmp","hds_pshm.bmp",hwnd,dc_screen);
    HDS_anim_drawm(i,im_pos[i].x,im_pos[i].y,dc_screen);
  }

/* wait for the mouse click */
  HDS_clear_queue(hwnd);
  HDS_clear_mouse(hwnd,1);

/* next we move the spheres around until all are gone */
  move_spheres(dc_screen,hwnd);

/* done with demo--> now clean up memory and free all */
/* the resources */

  HDS_reldc(hwnd,dc_screen);
  HDS_clean_all();
}

/************************************************************************/
/*              demo functions                                          */
/* these are functions that we wrote that are specific to this demo.    */
/* Note that these functions use many different calls to our graphic    */
/* library (all function that start with HDS).                          */

/**************************************************************/
/* display some information text to the screen                */

    void demo_text(int index,HDC dc_screen,HWND hwnd) {
      if (index==-1) {
        HDS_draw_text(WHITE,0,"Copyright @ 1996",420,420,1,2, 3,14,2,0,dc_screen);
        HDS_draw_text(WHITE,0,"Higher Dimension Research, Inc.",420,430,1,2, 3,14,2,0,dc_screen);
        HDS_draw_text(WHITE,0,"all rights reserved",420,440,1,2, 3,14,2,0,dc_screen);
      } else if (index==0) {
        HDS_bitmap_tile(0,340,400,480,"hds_b2.bmp",dc_screen,hwnd);
        HDS_draw_text(YELLOW,0,"This demo shows how rotation of the",0,340,1,2, 3,25,2,0,dc_screen);
        HDS_draw_text(YELLOW,0,"color map index can create animation.",0,360,1,2, 3,25,2,0,dc_screen);
        HDS_draw_text(YELLOW,0,"The color map is displayed so you",0,380,1,2, 3,25,2,0,dc_screen);
        HDS_draw_text(YELLOW,0,"can see the slots change in the palette",0,400,1,2, 3,25,2,0,dc_screen);
        HDS_draw_text(YELLOW,0,"as well as the image in the box.",0,420,1,2, 3,25,2,0,dc_screen);
        HDS_draw_text(GREEN,0,"Click the left button to start",0,440,1,2, 3,25,2,0,dc_screen);
      } else if (index==1) {
        HDS_delay_seconds(3);
        HDS_bitmap_tile(0,340,400,480,"hds_b2.bmp",dc_screen,hwnd);
        HDS_draw_text(TURQ,0,"The next demo shows some of the",0,360,1,2, 3,25,2,0,dc_screen);
        HDS_draw_text(TURQ,0,"animation and sound functions",0,380,1,2, 3,25,2,0,dc_screen);
        HDS_draw_text(GREEN,0,"Click the left button to CONTINUE",0,440,1,2, 3,25,2,0,dc_screen);
      } else if (index==2) {
        HDS_draw_text(GREEN,0,"Click the left button to EXIT",0,440,1,2, 3,25,2,0,dc_screen);
      } else if (index==3) {
        HDS_draw_text(YELLOW,0,"Click the Right mouse button to stop",0,440,1,2, 3,25,2,0,dc_screen);
      }

    }

/********************************************************************/
/* give all the spheres a starting positions somewhere in the first */
/* quarter of the screen in the x direction                         */

  void get_start() {

    int i,ns=0,iflag;
    int minx=diameter,maxx=200;
    int miny=diameter,maxy=screeny-diameter;
    int randx,randy;
    int dist;

    HDS_random_seed();
    for (i=0;i<nspheres;i++) {
        destroy[ns]=0;
        rand_direction(i);  /* get the initial direction */
    }

    while (ns<nspheres) {
       iflag=0;
       randx=minx+HDS_rand_zero(maxx-minx);
       randy=miny+HDS_rand_zero(maxy-miny);
       for (i=0;i<ns;i++) {
           dist=HDS_calc_distance(im_pos[i].x,im_pos[i].y,randx,randy);
           if (dist<diameter) {
               iflag=1;
               break;
           }
       }
       if (iflag==0) {
           im_pos[ns].x=randx;
           im_pos[ns].y=randy;
           ns++;
       }
    }

    }

/************************************************************/
/* get a new sphere position                                */

    int new_position(int isphere) {

      int new_x, new_y;
      int iflag2;
      int iflag=1,i;
      int dist;

      new_x=im_pos[isphere].x+direction[isphere].x*jump;
      new_y=im_pos[isphere].y+direction[isphere].y*jump;

/* check all four walls */

      if (new_x<diameter) {
          iflag=0;
      } else if (new_x>screenx-diameter) {
          iflag=0;
      } else if (new_y<diameter) {
          iflag=0;
      } else if (new_y>screeny-diameter) {
          iflag=0;
      }

/* then check all other spheres */
      iflag2=0;
      if (iflag==1) {
        for (i=0;i<nspheres;i++) {
          if (i!=isphere && destroy[i]!=1) {
             dist=HDS_calc_distance(im_pos[i].x,im_pos[i].y,new_x,new_y);
             if (dist<diameter) {
                iflag2=1;
                iflag=0;
                break;
             }
          }
        }
      }

/* if there is a collision either against the wall or another particle */
/* then make a new random direction but don't move, otherwise move */

      if (iflag==0) {
          rand_direction(isphere);
          if (iflag2) HDS_play_wav("bump.wav",0);
      } else {
          im_pos[isphere].x=new_x;
          im_pos[isphere].y=new_y;
      }
      return (iflag);
  }

/**************************************************************/
/* return a random direction                                  */

      void rand_direction(int isphere) {

        int maxa=100;
        int maxah=maxa/2;
        int pm,randx;
        float vx,vy;

        randx=HDS_rand_one(maxa);
        vx=(randx-maxah)/(float)(maxah);
        if (vx==0.0) vx+=0.1;
        vy=sqrt(1.0-vx*vx);
        pm=HDS_rand_zero(1);
        direction[isphere].x=vx;
        if (pm==0) vy*=(-1);
        direction[isphere].y=vy;
      }
/***********************************************************************/
/* check the postion of the sphere relative to the center of the green */
/* box                                                                 */

      int check_position(HDC dc_screen,int isphere,int spx,int spy) {
          int centerx=310, centery=215;
          int maxdist=30;  /* max distance for explosion */
          int dist;

          HDS_draw_ucircle(0,BLUE,1,centerx,centery,maxdist,dc_screen);

          dist=HDS_calc_distance(spx,spy,centerx,centery);
          if (dist<maxdist) {
              destroy[isphere]=1;
              nleft--;
              return (1);
          }
          return (0);
      }
/***********************************************************************/
/* do an explosion in the center of the screen by color rotation of the*/
/* palette slots                                                       */

   void explosion(HDC dc_screen,int isphere,int spx,int spy) {
       int red,green,blue;
       int ir,ig,ib;
       int outrad=50;
       int sprad=diameter/2;
       int stcolor=192,endcolor=stcolor+outrad-sprad;
       int icount=diameter;
       int i,j;

       spx+=8; spy+=8;   /* account for the fact the sphere is in the */
                         /* center of the bitmap and not the */

       HDS_play_wav("exp2.wav",0);  /*play a sound file in the foreground*/

       for (i=stcolor;i<=endcolor;i++) {
          HDS_draw_ucircle(0,i,2,spx,spy,icount,dc_screen);
          icount--;
       }
       for (j=0;j<5;j++) {
         if (j<2) {
           red=48; green=0; blue=0;
           ir=12; ig=0; ib=0;
         } else {
           red=0; green=48; blue=0;
           ir=0; ig=12; ib=0;
         }
       }

/* use color rotation for the explosion of sphere in the center */

       for (i=stcolor;i<endcolor;i++) {
         HDS_change_color(i,red,green,blue);
         red+=ir; green+=ig; blue+=ib;
       }
       HDS_load_color(dc_screen);

       for (i=stcolor;i<endcolor;i++) {
         HDS_delay_mil_seconds(100);
         HDS_color_rotate(dc_screen,stcolor,endcolor);
       }
       HDS_draw_fcircle(BLACK,spx,spy,diameter+1,dc_screen);
   }

/*********************************************************************/
/* move spheres until all are destroyed or user has clicked the right*/
/* mouse button                                                      */

    void move_spheres(HDC dc_screen,HWND hwnd) {
       int i;
       while (nleft>0 && (HDS_check_mouse(hwnd,1)==0)) {
          for (i=0;i<nspheres;i++) {
             if (destroy[i]!=1) {
               if (new_position(i)) {
                 HDS_anim_updatem(dc_screen,i,im_pos[i].x,im_pos[i].y);
                 if (check_position(dc_screen,i,im_pos[i].x,im_pos[i].y)) {
                   explosion(dc_screen,i,im_pos[i].x,im_pos[i].y);
                 }
               }
             }
          }
       }
    }

