
/*************************************************************************/
/* This example shows some things that can be done with some of the      */
/* bitmap functions.  Although, the demo was designed for 256 color      */
/* it can work with other color resolutions.                             */
/* This example was written in the c language, but the function calls    */
/* themselves could be called from any language or application           */
/*                                                                       */
/* copyright @ 1996 by Higher Dimension Research, Inc.                   */
/*************************************************************************/

#include <windows.h>     /* standard windows include files */

#include "hds_lib.h"     /* function prototypes for library*/
#include "hds_enum.h"    /* enumerated color types */
#include "winmain.c"     /* code to produce a window */

void demo_text(int index,HDC dc_screen,HWND hwnd); /* a function that
                            is specific to this demo*/
/*************************************************************************/

void your_main(HANDLE hwnd)  /* called by winmain after a window is created */
{

  int  num_colors;           /* local variables  used in demo*/
  int  temp,sizex,sizey;
  int  cstart=10,x,y,i;
  HDC     memory_dc;        /* a variable of type integer */
  HBITMAP memory_bit;       /* a variable of type intger */

  dc_screen=HDS_getdc(hwnd);            /*get device (i.e. screen) as the location to draw to */
                                        /*dc_screen is declared in
                                          hds_eg.h file */
  HDS_make_master_palette(dc_screen);   /*make the initial color palette*/

/* add all of the colors from the colormaps in the bitmaps */
/* to the system color map */

  num_colors=HDS_get_numcolors("hds_back.bmp");
  HDS_add_bitmap_colors(dc_screen,"hds_back.bmp",cstart,num_colors);

  temp=cstart+num_colors;
  num_colors=HDS_get_numcolors("hds_c.bmp");
  HDS_add_bitmap_colors(dc_screen,"hds_c.bmp",temp,num_colors);

  temp+=num_colors;
  num_colors=HDS_get_numcolors("hds_diam.bmp");
  HDS_add_bitmap_colors(dc_screen,"hds_diam.bmp",temp,num_colors);

  temp+=num_colors;
  num_colors=HDS_get_numcolors("hds_gt.bmp");
  HDS_add_bitmap_colors(dc_screen,"hds_gt.bmp",temp,num_colors);

  temp+=num_colors;
  num_colors=HDS_get_numcolors("hds_bk1.bmp");
  HDS_add_bitmap_colors(dc_screen,"hds_bk1.bmp",temp,num_colors);

/* use the tile function to repeat the bitmaps to make */
/* complete patterns                                   */

  HDS_bitmap_tile(0,0,640,480,"hds_bk1.bmp",dc_screen,hwnd);
  HDS_bitmap_tile(60,100,400,450,"hds_back.bmp",dc_screen,hwnd);

/* draw some raised and lowered panels */
  HDS_draw_border(dc_screen,7,60,100,400,450,1,-70,70,30);
  HDS_draw_border(dc_screen,9,141,140,300,300,-1,-70,70,40);

/* draw the cloud bitmap in the border */
  HDS_drawbitmap(hwnd,dc_screen,150,150,"hds_c.bmp",0);

/* draw the diamonds as transparent bitmaps */
/* (i.e. preserve the background */

  HDS_drawbitmap_trans(hwnd,dc_screen,140,143,"hds_diam.bmp","hds_dm.bmp");
  HDS_drawbitmap_trans(hwnd,dc_screen,141,210,"hds_diam.bmp","hds_dm.bmp");
  HDS_drawbitmap_trans(hwnd,dc_screen,189,143,"hds_diam.bmp","hds_dm.bmp");
  HDS_drawbitmap_trans(hwnd,dc_screen,190,210,"hds_diam.bmp","hds_dm.bmp");
  HDS_drawbitmap_trans(hwnd,dc_screen,238,143,"hds_diam.bmp","hds_dm.bmp");
  HDS_drawbitmap_trans(hwnd,dc_screen,239,210,"hds_diam.bmp","hds_dm.bmp");

/* draw some sample buttons */
  HDS_draw_text(GREEN,0,"but1",105,355,1,2, 4,16,2,0,dc_screen);
  HDS_draw_text(GREEN,0,"but2",105,385,1,2, 4,16,2,0,dc_screen);
  HDS_draw_text(GREEN,0,"but3",105,415,1,2, 4,16,2,0,dc_screen);

  HDS_draw_border(dc_screen,2,80,350,100,370,1,-80,80,20);
  HDS_draw_border(dc_screen,2,80,380,100,400,1,-80,80,20);
  HDS_draw_border(dc_screen,2,80,410,100,430,1,-80,80,20);

  HDS_draw_border(dc_screen,2,150,350,190,370,-1,-80,80,20);
  HDS_draw_border(dc_screen,2,150,380,190,400,-1,-80,80,30);
  HDS_draw_border(dc_screen,2,150,410,190,430,-1,-80,80,30);

/* some more sample buttons */
  HDS_draw_border(dc_screen,2,250,350,290,370,1,-80,80,20);
  HDS_draw_border(dc_screen,2,250,380,290,400,1,-80,80,30);
  HDS_draw_border(dc_screen,2,250,410,290,430,1,-80,80,30);

/* draw text for the buttons */
  HDS_draw_text(TURQ,0,"but4",210,355,1,2, 4,16,2,0,dc_screen);
  HDS_draw_text(TURQ,0,"but5",210,385,1,2, 4,16,2,0,dc_screen);
  HDS_draw_text(TURQ,0,"but6",210,415,1,2, 4,16,2,0,dc_screen);

/* draw the green marble buttons */
  HDS_drawbitmap(hwnd,dc_screen,350,360,"hds_gt.bmp",0);
  HDS_drawbitmap(hwnd,dc_screen,350,400,"hds_gt.bmp",0);

  HDS_get_size("hds_gt.bmp",&sizex,&sizey);
  HDS_draw_border(dc_screen,2,350,360,350+sizex,360+sizey,1,-80,80,30);
  HDS_draw_border(dc_screen,2,350,400,350+sizex,400+sizey,1,-80,80,30);
  HDS_draw_text(WHITE,0,"m1",320,365,1,2, 4,16,2,0,dc_screen);
  HDS_draw_text(WHITE,0,"m2",320,405,1,2, 4,16,2,0,dc_screen);

/* draw a separator bar */
  HDS_hseparator(dc_screen,90,320,360,60,1);

/* here we draw the text "Masking Text" in purple and then replace  */
/* each purple pixel with pixels from the cloud bitmap              */
/* (we draw the mask twice since the text is longer then the bitmap */

  HDS_draw_text(PURPLE,0,"Masking Text",140,115,1,2, 4,24,3,0,dc_screen);
  HDS_draw_mask(dc_screen,hwnd,140,30,220,135,PURPLE,"hds_c.bmp");
  HDS_draw_mask(dc_screen,hwnd,220,10,300,135,PURPLE,"hds_c.bmp");
  demo_text(0,dc_screen,hwnd);

/* wait for the user to click the left mouse key */

  HDS_clear_queue(hwnd); /*remove all previous button clicks */
  HDS_get_mouse(0,hwnd); /*wait for the left mouse button */

/* draw some images in a memory buffer and then blast to screen */

  HDS_get_size("hds_c.bmp",&sizex,&sizey);
  HDS_make_memory_dc(dc_screen,&memory_dc,&memory_bit,sizex,sizey);
  HDS_drawbitmap(hwnd,memory_dc,0,0,"hds_c.bmp",0);
  HDS_drawbitmap_trans(hwnd,memory_dc,40,40,"hds_diam.bmp","hds_dm.bmp");
  HDS_copy_rect(memory_dc,dc_screen,0,0,sizex,sizey,0,0);

  demo_text(1,dc_screen,hwnd);
  HDS_clear_queue(hwnd);
  HDS_get_mouse(0,hwnd);

/* do some random block copy from memory to the screen */

  HDS_random_seed();
  for (i=0;i<100;i++) {
    x=HDS_rand_zero(640);
    y=HDS_rand_zero(480);
    HDS_copy_rect(memory_dc,dc_screen,0,0,sizex,sizey,x,y);
  }

  HDS_delay_seconds(3);   /* pause 3 seconds */

  demo_text(2,dc_screen,hwnd);

/* wait for the mouse */

  HDS_clear_queue(hwnd);
  HDS_get_mouse(0,hwnd);

/* do some transparent transfers (i.e. do not draw pixels if black ) */
/* we use HDS_anim functions instead of drawbitmap_trans since it would */
/* be faster for multiple drawings of the same image */

/* create the image in memory */
  HDS_anim_createm_dc(1,"hds_diam.bmp","hds_dm.bmp",hwnd,dc_screen);

/* now draw to the screen */
  for (i=0;i<200;i++) {
    x=HDS_rand_zero(640);
    y=HDS_rand_zero(480);
    HDS_anim_drawm(1,x,y,dc_screen);
  }


  HDS_delay_seconds(3);
  demo_text(3,dc_screen,hwnd);

/* wait for the mouse */
  HDS_clear_queue(hwnd);  /* clear any previous mouse clicks */
  HDS_get_mouse(0,hwnd);

/* clean up the memory bitmaps and free the resources */

  HDS_clean_up(&memory_dc,&memory_bit);
  HDS_reldc(hwnd,dc_screen);
  HDS_clean_all();
}


/************************************************************************/
/*              demo functions                                          */
/* these are functions that we wrote that are specific to this demo.    */
/* Note that these functions use many different calls to our graphic    */
/* library (all function that start with HDS).                          */

/**************************************************************/
/* display some information text to the screen                */

    void demo_text(int index,HDC dc_screen,HWND hwnd) {
      HDS_bitmap_tile(400,0,640,480,"hds_bk1.bmp",dc_screen,hwnd);
      HDS_draw_text(WHITE,0,"Copyright @ 1996",420,420,1,2, 3,14,2,0,dc_screen);
      HDS_draw_text(WHITE,0,"Higher Dimension Research, Inc.",420,430,1,2, 3,14,2,0,dc_screen);
      HDS_draw_text(WHITE,0,"all rights reserved",420,440,1,2, 3,14,2,0,dc_screen);
      if (index==0) {
        HDS_draw_text(RED,0,"This shows some different bitmap",
                           410,60,1,2, 3,14,3,0,dc_screen);
        HDS_draw_text(RED,0,"drawing functions done directly",
                           410,80,1,2, 3,14,3,0,dc_screen);
        HDS_draw_text(RED,0,"on the screen.  Normally they ",
                           410,100,1,2, 3,14,3,0,dc_screen);
        HDS_draw_text(RED,0,"are done in memory and the    ",
                           410,120,1,2, 3,14,3,0,dc_screen);
        HDS_draw_text(RED,0,"final image is blasted to the",
                           410,140,1,2, 3,14,3,0,dc_screen);
        HDS_draw_text(RED,0,"screen.",410,160,1,2, 3,14,3,0,dc_screen);
        HDS_draw_text(GREEN,0,"CLICK LEFT BUTTON TO SEE AN",410,180,1,2, 3,14,3,0,dc_screen);
        HDS_draw_text(GREEN,0,"EXAMPLE OF MEMORY BITBLT",410,200,1,2, 3,14,3,0,dc_screen);
        HDS_draw_text(GREEN,0,"(clouds with single diamond)",410,220,1,2, 3,14,3,0,dc_screen);
      } else if (index==1) {
        HDS_draw_text(PURPLE,0,"CLICK left button to see some",410,100,1,2, 3,14,3,0,dc_screen);
        HDS_draw_text(PURPLE,0,"fast random block copy",410,120,1,2, 3,14,3,0,dc_screen);
      } else if (index==2) {
        HDS_draw_text(YELLOW,0,"CLICK left button to see some",410,100,1,2, 3,14,3,0,dc_screen);
        HDS_draw_text(YELLOW,0,"transparent draws (diamond)",410,120,1,2, 3,14,3,0,dc_screen);
      } else if (index==3) {
        HDS_draw_text(WHITE,0,"CLICK left button to ",410,100,1,2, 3,14,3,0,dc_screen);
        HDS_draw_text(WHITE,0,"end the demo",410,120,1,2, 3,14,3,0,dc_screen);
      }
    }






