/*************************************************************************/
/* This shows some example primatives (circles,lines,etc.) drawn on the  */
/* screen. The shapes could be drawn in other colors, sizes and          */
/* thicknesses if desired.                                               */
/* All functions that start with HDS are functions that are part of our  */
/* graphics library                                                      */
/* This example was written in the c language, but the function calls    */
/* themselves could be called from any language or application           */
/* that can use library functions                                        */
/*                                                                       */
/* copyright @ 1996 by Higher Dimension Research, Inc.                   */
/*************************************************************************/

#include <windows.h>     /* standard windows include files */

#include "hds_lib.h"     /* function prototypes for library*/
#include "hds_enum.h"    /* enumerated types */
#include "winmain.c"     /* code to produce a window */
void draw_cells(HDC);    /* a function used only in this demo to draw */
                         /*    the green border cells for the primitives*/

/*************************************************************************/

void your_main(HANDLE hwnd)  /* called by winmain after a window is created */
{

  int i,x,y;
  HDC dc_screen;

  dc_screen=HDS_getdc(hwnd);     /*get device context (i.e. screen) as the location to draw to */
  HDS_make_master_palette(dc_screen);   /*make the initial color palette*/

  draw_cells(dc_screen);  /* used only in this demo to draw box outlines */

/* draw some solid lines */

  HDS_draw_text(WHITE,0,"solid lines",10,5,1,0,1,20,1,0,dc_screen);
  HDS_draw_line(0,RED,1,10,30,80,35,dc_screen);  
  HDS_draw_line(0,GREEN,1,20,40,70,40,dc_screen);
  HDS_draw_line(0,BLUE,10,5,60,85,85,dc_screen); 
  HDS_draw_line(0,YELLOW,1,40,25,40,85,dc_screen);

/* draw some more lines */

  HDS_draw_text(WHITE,0,"more lines",10,105,1,0,1,20,1,0,dc_screen);
  HDS_draw_line(2,TURQ,1,3,130,90,170,dc_screen); 
  HDS_draw_line(1,PURPLE,1,20,190,60,120,dc_screen);
  HDS_draw_line(2,BLUE,1,60,180,20,180,dc_screen);  
  HDS_draw_line(3,YELLOW,1,70,150,20,180,dc_screen);

/* draw some dashed lines */
  HDS_draw_text(WHITE,0,"some pluses",10,205,1,0,1,20,1,0,dc_screen);
  HDS_draw_plus(0,BLUE,2,20,230,40,250,dc_screen);
  HDS_draw_plus(0,RED,2,50,260,80,290,dc_screen);
  HDS_draw_plus(0,PURPLE,1,60,245,80,275,dc_screen);
  HDS_draw_plus(0,YELLOW,1,25,270,35,280,dc_screen);


/* draw some filled rectangles */
  HDS_draw_text(WHITE,0,"filled rectangles",10,305,1,0,1,15,1,0,dc_screen);
  HDS_draw_frect(GREEN,10,330,60,370,dc_screen);
  HDS_draw_frect(YELLOW,30,340,80,350,dc_screen);
  HDS_draw_frect(BLUE,20,380,60,390,dc_screen);

/* draw some unfilled rectangles */
  HDS_draw_text(WHITE,0,"unfilled rectangles",110,5,1,0,1,15,1,0,dc_screen);
  HDS_draw_urect(0,LGT_GRAY,4,110,30,160,70,dc_screen);
  HDS_draw_urect(0,WHITE,2,130,40,180,50,dc_screen);
  HDS_draw_urect(0,BLUE,1,120,80,160,90,dc_screen);
  HDS_draw_urect(0,RED,1,140,40,160,90,dc_screen);

/* draw a filled rounded rectangles */
  HDS_draw_text(WHITE,0,"filled rounded rect",110,105,1,0,1,15,1,0,dc_screen);
  HDS_draw_frrect(RED,120,130,180,190,20,20,dc_screen);

/* draw some unfilled rounded rectangles */
  HDS_draw_text(WHITE,0,"unfilled round rect",105,205,1,0,1,15,1,0,dc_screen);
  HDS_draw_urrect(0,BLUE,1,120,230,180,290,20,20,dc_screen);
  HDS_draw_urrect(0,GREEN,4,140,230,170,280,20,20,dc_screen);
  HDS_draw_urrect(0,WHITE,1,130,240,190,280,20,20,dc_screen);

/* draw some x's */
  HDS_draw_text(WHITE,0,"draw x's",125,305,1,0,1,20,1,0,dc_screen);
  HDS_draw_x(0,RED,2,115,330,165,380,dc_screen);
  HDS_draw_x(0,PURPLE,1,125,320,175,380,dc_screen);
  HDS_draw_x(0,GREEN,3,155,330,185,360,dc_screen);

/* draw some filled circles */
  HDS_draw_text(WHITE,0,"filled circles",210,5,1,0,1,20,1,0,dc_screen);
  HDS_draw_fcircle(TURQ,250,50,20,dc_screen);
  HDS_draw_fcircle(RED,230,70,10,dc_screen);
  HDS_draw_fcircle(YELLOW,270,80,5,dc_screen);

/* draw some un-filled circles */
  HDS_draw_text(WHITE,0,"unfilled circles",210,105,1,0,1,15,1,0,dc_screen);
  HDS_draw_ucircle(0,RED,1,250,150,20,dc_screen);
  HDS_draw_ucircle(0,GREEN,2,230,170,10,dc_screen);
  HDS_draw_ucircle(0,MED_GRAY,1,270,180,5,dc_screen);

/* draw some filled diamonds */
  HDS_draw_text(WHITE,0,"filled diamonds",210,205,1,0,1,15,1,0,dc_screen);
  HDS_draw_fdiamond(TURQ,235,230,255,260,dc_screen);
  HDS_draw_fdiamond(BLUE,250,240,290,290,dc_screen);
  HDS_draw_fdiamond(RED,215,270,225,290,dc_screen);

/* draw some un-filled diamonds */
  HDS_draw_text(WHITE,0,"unfilled diamonds",212,305,1,0,1,15,1,0,dc_screen);
  HDS_draw_udiamond(0,TURQ,1,235,330,255,360,dc_screen);
  HDS_draw_udiamond(1,BLUE,1,250,340,290,390,dc_screen);
  HDS_draw_udiamond(0,RED,2,215,370,225,390,dc_screen);
  HDS_draw_udiamond(0,PURPLE,1,205,325,245,385,dc_screen);

/* draw a filled polygon */
  HDS_draw_text(WHITE,0,"filled polygon",310,5,1,0,1,15,1,0,dc_screen);

  HDS_add_polyp(1,1,338,28);
  HDS_add_polyp(1,2,327,41);
  HDS_add_polyp(1,3,339,58);
  HDS_add_polyp(1,4,391,74);
  HDS_add_polyp(1,5,376,41);
  HDS_draw_fpolyp(GREEN,1,5,dc_screen);

/* draw an unfilled polygon */
  HDS_draw_text(WHITE,0,"unfilled polygon",305,105,1,0,1,15,1,0,dc_screen);
  HDS_add_polyp(1,1,338,128);
  HDS_add_polyp(1,2,327,141);
  HDS_add_polyp(1,3,339,158);
  HDS_add_polyp(1,4,391,174);
  HDS_add_polyp(1,5,376,141);
  HDS_draw_upolyp(0,RED,1,1,5,dc_screen);

/* draw some filled triangles */
  HDS_draw_text(WHITE,0,"filled triangles",310,205,1,0,1,15,1,0,dc_screen);
  HDS_draw_ftriangle(WHITE,30,355,260,dc_screen);
  HDS_draw_ftriangle(BLUE,10,360,260,dc_screen);
  HDS_draw_ftriangle(PURPLE,5,330,270,dc_screen);

/* draw some filled triangles */
  HDS_draw_text(WHITE,0,"unfilled triangles",305,305,1,0,1,15,1,0,dc_screen);
  HDS_draw_utriangle(0,LGT_GRAY,2,30,355,360,dc_screen);
  HDS_draw_utriangle(1,GREEN,1,10,360,360,dc_screen);
  HDS_draw_utriangle(0,RED,1,5,330,370,dc_screen);

/* some points */
/* random points in a box */
  HDS_draw_text(WHITE,0,"points",425,5,1,0,1,20,1,0,dc_screen);

  for (i=0;i<300;i++) {
      x=HDS_rand_zero(90)+405;
      y=HDS_rand_zero(80)+20;
      HDS_point(TURQ,x,y,dc_screen);
  }

/* a filled ellipse */
  HDS_draw_text(WHITE,0,"filled ellipse",415,105,1,0,1,15,1,0,dc_screen);
  HDS_draw_fellipse(BLUE,430,130,490,160,dc_screen);

/* an unfilled ellipses */
  HDS_draw_text(WHITE,0,"unfilled ellipses",405,205,1,0,1,15,1,0,dc_screen);
  HDS_draw_uellipse(0,BLUE,2,430,230,490,260,dc_screen);
  HDS_draw_uellipse(3,YELLOW,1,440,220,470,265,dc_screen);
  HDS_draw_uellipse(0,RED,2,430,230,460,290,dc_screen);

/* draw some text */
  HDS_draw_text(WHITE,0,"Click Left Mouse Button to Quit",10,
                420,1,0,1,30,1,0,dc_screen);
  HDS_draw_text(GREEN,0,"Some",545,50,1,0,1,30,1,0,dc_screen);
  HDS_draw_text(GREEN,0,"Sample",535,80,1,0,1,30,1,0,dc_screen);
  HDS_draw_text(GREEN,0,"Primitives",525,110,1,0,1,30,1,0,dc_screen);
  HDS_draw_text(RED,0,"H",430,320,1,0,4,35,3,1,dc_screen);
  HDS_draw_text(RED,0,"D",440,330,1,0,4,35,3,1,dc_screen);
  HDS_draw_text(RED,0,"S",450,340,1,0,4,35,3,1,dc_screen);

  HDS_draw_text(WHITE,0,"Copyright @ 1996",380,420,1,2, 4,14,2,0,dc_screen);
  HDS_draw_text(WHITE,0,"Higher Dimension Research, Inc.",380,430,1,2, 4,14,2,0,dc_screen);
  HDS_draw_text(WHITE,0,"all rights reserved",380,440,1,2, 4,14,2,0,dc_screen);

/* wait for the user to click the left mouse button and then clean */
/* up and exit */
  HDS_get_mouse(0,hwnd);
  HDS_reldc(hwnd,dc_screen);  /*free resources*/
  HDS_clean_all();            /* finish cleanup */

}

/********************************************************************/
/* This function is used for creating the green boxes which contain */
/* the sample primatives                                            */

  void draw_cells(HDC dc_screen) {
      int num_x=5,num_y=4;
      int x,y,i,j;

      for (i=0;i<num_x;i++) {
          for (j=0;j<num_y;j++) {
              x=(i*100); y=(j*100);
              HDS_draw_urect(0,GREEN,2,x,y,x+100,y+100,dc_screen);
          }
      }
  }














