/*************************************************************************/
/* This shows some examples of using various text sizes and colors.      */
/* This only shows some of the infinite variety of sizes,colors, etc.    */
/* of text that can be displayed                                         */
/* This example was written in the c language, but the function calls    */
/* themselves could be called from any language or application           */
/* that can use library functions (dll's)                                */
/*                                                                       */
/* copyright @ 1996 by Higher Dimension Research, Inc.                   */
/*************************************************************************/
#include <windows.h>     /* standard windows include files */

#include "hds_lib.h"     /* function prototypes for library*/
#include "hds_enum.h"    /* enumerated types */
#include "winmain.c"     /* code to produce a window */

/*************************************************************************/

void your_main(HANDLE hwnd)  /* called by winmain after a window is created */
{

  int i;
  int ypos,size;
  HDC dc_screen;

  dc_screen=HDS_getdc(hwnd);     /*get device (i.e. screen) as the location to draw to */
  HDS_make_master_palette(dc_screen);   /*make the initial color palette*/
  HDS_add_bitmap_colors(dc_screen,"tile.bmp",10,8);  /* add bitmap colors */

/* sample text in blue */

  size=20;
  for (i=0;i<5;i++) {
    ypos=(i*size)+5;
    HDS_draw_text(BLUE,0,"TEXT DEMO",0,ypos,1,2, i+1,size,1,1,dc_screen);
  }

/* some more text in GREEN with italic off at an angle*/
  size=20;
  for (i=0;i<5;i++) {
    ypos=100+(i*size)+5;
    HDS_draw_text(GREEN,240,"TEXT DEMO",0,ypos,1,2, i+1,size,1,0,dc_screen);
  }

/* some more text in PURPLE that is thicker*/
  size=20;
  for (i=0;i<5;i++) {
    ypos=200+(i*size)+5;
    HDS_draw_text(PURPLE,0,"TEXT DEMO",0,ypos,1,2, i+1,size,3,1,dc_screen);
  }

/* some more text in RED that is bigger*/
  size=30;
  for (i=0;i<5;i++) {
    ypos=(i*size)+5;
    HDS_draw_text(RED,0,"Larger Text",150,ypos,1,2, i+1,size,1,1,dc_screen);
  }

/* some more text in gray that is bigger and thicker */
  size=40;
  for (i=0;i<5;i++) {
    ypos=150+(i*size)+5;
    HDS_draw_text(LGT_GRAY,0,"Larger Text",150,ypos,1,2, i+1,size,2,0,dc_screen);
  }

/* repeate a background bitmap */

  HDS_bitmap_tile(450,0,640,450,"tile.bmp",dc_screen,hwnd); /* repeat for background*/

/* some smaller text */
  size =18;
  for (i=0;i<5;i++) {
    ypos=(i*size)+5;
    HDS_draw_text(BLUE,0,"Transparent Text",450,ypos,1,2, i+1,size,1,0,dc_screen);
  }

/* show non-transparent text (black background) */
  size =20;
  HDS_draw_text(RED,0,"NON-Transparent Text",470,150,0,BLACK, i+1,size,1,0,dc_screen);

/* some more text */
  size =25;
  for (i=0;i<5;i++) {
    ypos=250+(i*size)+5;
    HDS_draw_text(PURPLE,0,"Transparent Text",440,ypos,1,2, i+1,size,1,1,dc_screen);
  }

/* draw some text on the screen */

  HDS_draw_text(WHITE,0,"Click Left Mouse Button to Quit",0,
                420,1,0,1,30,1,0,dc_screen);
  HDS_draw_text(RED,0,"Copyright @ 1996",380,420,1,2, 4,14,2,0,dc_screen);
  HDS_draw_text(RED,0,"Higher Dimension Research, Inc.",380,430,1,2, 4,14,2,0,dc_screen);
  HDS_draw_text(RED,0,"all rights reserved",380,440,1,2, 4,14,2,0,dc_screen);

/* clean up */
  HDS_get_mouse(0,hwnd);     /* wait for the left mouse button */
  HDS_reldc(hwnd,dc_screen); /* free up system resources */
  HDS_clean_all();           /* clean up rest of the system resources */
}




