/*************************************************************************/
/* This example shows some things that can be done with the color        */
/* resources available.  The demo was designed for 256 color but the     */
/* functions themselves can work with other color resolutions            */
/* This example was written in the c language, but the function calls    */
/* themselves could be called from many other languages or applications  */
/*                                                                       */
/* copyright @ 1996 by Higher Dimension Research, Inc.                   */
/*************************************************************************/

#include <windows.h>     /* standard windows include files */

#include "hds_lib.h"     /* function prototypes for library*/
#include "hds_enum.h"    /* enumerated color types */
#include "winmain2.c"     /* code to produce a window */
/*************************************************************************/

void your_main(HANDLE hwnd)  /* called by winmain after a window is created */
{

/* some variables used for this demo */
  int  i,x1,y2;
  int  index=10,color;
  int  sizey=100,icount=0,temp;
  int  yp,ys=300,xs=200;
  int  red=255,green=0,blue=255;
  HDC  dc_screen;

  dc_screen=HDS_getdc(hwnd);     /*get device context (i.e. screen) as the location to draw to */
  HDS_make_master_palette(dc_screen);   /*make the initial color palette*/

/* change the background of the screen to white */
  HDS_draw_frect(WHITE,0,0,640,480,dc_screen);

/* draw some lines as a design */
/* Use the function HDS_change_color to change the color in */
/* the system map.  Notice that we make all the color changes */
/* with change_color and then update the changes with load color */

   red=0; green=255; blue=255;
   for (i=0;i<30;i++) {
     green-=4;
     HDS_change_color(i+210,red,green,blue); /* set the color */
   }
   HDS_load_color(dc_screen);  /*make all the changes valid */

/* now draw some lines */
   for (i=0;i<30;i++) {
     x1=640-(i*21);  y2=i*16;
     HDS_draw_line(0,i+210,4,x1,0,640,y2,dc_screen);
   }

/* draw a triangle that has various shades of blue across it */
/* Use the function HDS_change_color to the color in */
/* the system map */

  temp=index;
  for (yp=ys;yp<ys+sizey;yp++) {
    HDS_change_color(index,0,0,index+30); /* set the color */
    index++;
  }
  HDS_load_color(dc_screen);

  index=temp;
  for (yp=ys;yp<ys+sizey;yp++) {
    HDS_draw_line(0,index,1,xs-icount,yp,xs+icount,yp,dc_screen);
    index++;
    icount++;
  }

/* draw a filled circle with various shades of color */
/* Use the function HDS_change_color to the color in */
/* the system map */

  red=255,green=0,blue=255;
  temp=index;
  for (i=100;i>0;i--) {
    HDS_change_color(index,red,green,blue); /* set the color */
    green+=2; blue-=2; index++;
    if (i>50) red-=4;
  }
  HDS_load_color(dc_screen);

  index=temp;
  for (i=100;i>0;i--) {
    HDS_draw_fcircle(index,450,200,i,dc_screen);
    index++;
  }

/* draw a simple design showing off the colors */
/* this just draws some text in various colors and increased size */

  color=110;
  for (i=1;i<100;i++) {
    color++;
    HDS_draw_text(color,0,"7",300,200,1,0,3,i*3,2,0,dc_screen);
  }

/* display all 256 colors of the system palette */

  HDS_display_colors(dc_screen,0,255,12);

/* draw some more text */

/* display the copyright notice as red text */
  HDS_draw_text(RED,0,"Copyright @ 1996",380,420,1,2, 4,14,2,0,dc_screen);
  HDS_draw_text(RED,0,"Higher Dimension Research, Inc.",380,430,1,2, 4,14,2,0,dc_screen);
  HDS_draw_text(RED,0,"all rights reserved",380,440,1,2, 4,14,2,0,dc_screen);

/* wait for user to click left mouse button and then clean up */
/* and quit */

  HDS_delay_seconds(4);
  HDS_reldc(hwnd,dc_screen); /* free up system resources */
  HDS_clean_all();           /* some additional cleaning and we are done */
}




