// CopyRight Maurizio Maccani 1995
#include <windows.h>
#include <windowsx.h>
#include "csh.h" // You MUST include this line
#include "resource.h" 
BOOL FAR PASCAL __export HelpDialogProc(HWND hDlg, UINT uMsg,
					      WPARAM wParam, LPARAM lParam);
HINSTANCE hInst;                                              
long FAR PASCAL _export TestProc(HWND hwnd, UINT message, UINT wParam,
						 LONG lParam);
int PASCAL      WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
					LPSTR lpszCmdParam, int nCmdShow)
{  
    MSG             msg;
    WNDCLASS        wndclass;
    hInst = hInstance;
    
    wndclass.style = CS_HREDRAW | CS_VREDRAW | CS_BYTEALIGNWINDOW | CS_BYTEALIGNCLIENT | CS_GLOBALCLASS | CS_DBLCLKS;
    wndclass.cbClsExtra = 0;
    wndclass.cbWndExtra = 0;
    wndclass.hInstance = hInstance;
    wndclass.hIcon = LoadIcon(hInstance, "icon");
    wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
    wndclass.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);
    wndclass.lpszMenuName = "menu";
    wndclass.lpfnWndProc = TestProc;
    wndclass.lpszClassName = "test";
    RegisterClass(&wndclass);

    /*************************************************************/
    /*************************************************************/
    /*************************************************************/
    // Set the help file
    // path MUST be before the first window creation
    // If it is not the window help will NOT appear
    /*************************************************************/
    /*************************************************************/
    /*************************************************************/
						   
    int ret = SetHelpFile(".\\HELP\\csh.HLP"); // Set the help file
    // path MUST be before the first window creation
    // If it is not the window help will NOT appear
    
					       
    if (ret == HELP_FILE_DO_NOT_EXISTS)        // if the help file does not exist tell to the user
	MessageBox(NULL, "Not existing Help File", "Error", MB_ICONSTOP | MB_OK);
					       
    // AFTER SET HELP FILE                                            
    HWND            hwndHello = CreateWindow("test",    // window class name
					     "CSH Test",      // window caption
					     WS_OVERLAPPEDWINDOW,       // window style
					     100, 100, 180, 160,
					     NULL,      // parent window handle
					     NULL,      // window menu handle
					     (HINSTANCE) hInstance,     // program instance
									// handle
					     NULL);     // creation parameters
    ShowWindow(hwndHello, SW_SHOW);
    UpdateWindow(hwndHello);
    
    SetDefaultHelp(0x0008); // I set the default help to 8
    
    
    while (GetMessage(&msg, NULL, 0, 0)) {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
    }
    return msg.wParam;
}
long FAR PASCAL _export TestProc(HWND hwnd, UINT message, UINT wParam,
						 LONG lParam)
{
    switch (message) {
    case WM_CLOSE:
	  PostQuitMessage(0);
	  return 0;
	  
    case WM_CREATE:
       {
       SetMenuHelp(hwnd, EXIT,0x0009);
       SetMenuHelp(hwnd, ID_DIALOG,0x0010);
       HWND edit = CreateWindow("edit","Highlight and F1",WS_VISIBLE | WS_CHILD | WS_BORDER,12,10,150,25,hwnd,1,hInst,NULL);
       HWND button = CreateWindow("button","Mouse inside and F1",BS_GROUPBOX | WS_VISIBLE | WS_CHILD,10,45,150,60,hwnd,1,hInst,NULL);
       SetWindowHelp(edit,0x0011);
       SetMouseHelp(button,0x0012);
       }  
       
    case WM_COMMAND:
      switch(wParam)
	{
	case EXIT:
	  PostQuitMessage(0);
	  return 0;
	case ID_DIALOG:
	  {
	  DLGPROC         helpDialogBox;
	  helpDialogBox = (DLGPROC) MakeProcInstance((FARPROC) HelpDialogProc, hInst);
	  int             ShowDetails = DialogBox(hInst, "HelpDlg", hwnd, helpDialogBox);
	  FreeProcInstance(helpDialogBox);
	  return 0;
	  }                 
	case ABOUT:
	   MessageBox(hwnd,"Context Sensitive Help Demo - Copyright Maccani Maurizio 1995","Information", MB_ICONINFORMATION | MB_OK);  
	   return 0;
	case INTRODUCTION:
	   WinHelp(hwnd,".\\HELP\\csh.HLP",HELP_CONTEXT,0x0001);
	   return 0;
	}
    }
    return DefWindowProc(hwnd, message, wParam, lParam);
}

BOOL FAR PASCAL __export HelpDialogProc(HWND hDlg, UINT uMsg,
					       WPARAM wParam, LPARAM lParam)
{
    switch (uMsg) {
			case WM_INITDIALOG:
			{
			    SetWindowHelp(hDlg, 0x0013);
			    SetWindowHelp(GetDlgItem(hDlg,IDC_EDIT1),0x0014);
			    SetMouseHelp(GetDlgItem(hDlg,IDC_STATIC),0x0015);
			    return FALSE;
			    }
		    case WM_CLOSE:
			EndDialog(hDlg, 0);
			return TRUE;
		    case WM_COMMAND:
			switch (wParam) {
			case IDOK:
			    EndDialog(hDlg, 0);
			    return TRUE;
			case IDCANCEL:
			    EndDialog(hDlg, 0);
			    return TRUE;
			default:
			    break;
			}
			      
    }
    return (FALSE);

} // end of HelpDialogProc()
	    
	    
