/**************************************************************/
/* runtime.h - ControlZ run-time libraries include file       */
/* Copyright  1995, C. van Zwynsvoorde. All rights reserved. */
/**************************************************************/

/*
 * This is the declaration for the Register functions. There is
 * one in each run-time library. You must call them at the
 * beginning of your program with your name and password.
 * See the COntrolZ.HLP help file for more details.
 *
 * There is also some declaration for utility date/time functions.
 *
 * IMPORTANT:
 * In order to be able to link those functions, you have to
 * include (some of) the following lines in your project's
 * .DEF file:
 *
 * IMPORTS
 *      RegisterCZScaler=CZScaler.1
 *      RegisterCZDial=CZDial.1
 *      RegisterCZTuner=CZTuner.1
 *      RegisterCZCombo=CZCombo.1
 *      RegisterCZList=CZList.1
 *      RegisterCZText=CZText.1
 *      RegisterCZLink=CZLink.1
 *      RegisterCZPalette=CZPalet.1
 *		CZMakeDate=CZCombo.2
 *		CZMakeDuration=CZCombo.3
 *		CZExtractTime=CZCombo.4
 *		CZExtractDate=CZCombo.5
 *		CZGetNow=CZCombo.6
 *
 * You will also have to make a CASE INSENSITIVE LINK AND IMPORT
 */

BOOL FAR PASCAL RegisterCZScaler(LPSTR szName, LPSTR szCode);
BOOL FAR PASCAL RegisterCZDial(LPSTR szName, LPSTR szCode);
BOOL FAR PASCAL RegisterCZTuner(LPSTR szName, LPSTR szCode);
BOOL FAR PASCAL RegisterCZCombo(LPSTR szName, LPSTR szCode);
BOOL FAR PASCAL RegisterCZList(LPSTR szName, LPSTR szCode);
BOOL FAR PASCAL RegisterCZText(LPSTR szName, LPSTR szCode);
BOOL FAR PASCAL RegisterCZLink(LPSTR szName, LPSTR szCode);
BOOL FAR PASCAL RegisterCZPalette(LPSTR szName, LPSTR szCode);
void FAR PASCAL CZExtractDate(double datetime, LPINT lpnDay, LPINT lpnMonth, LPINT lpnYear);
void FAR PASCAL CZExtractTime(double datetime, LPINT lpnHour, LPINT lpnMinute, LPINT lpnSecond, LPINT lpnHundredth);
void FAR PASCAL CZMakeDuration(double FAR *lpDuration, WORD nDays, WORD nHour, WORD nMinute, WORD nSecond, WORD nHundredth);
void FAR PASCAL CZMakeDate(double FAR *lpDate, WORD nDay, WORD nMonth, WORD nYear, WORD nHour, WORD nMinute, WORD nSecond, WORD nHundredth);
void FAR PASCAL CZGetNow(double FAR *lpNow);



