/*
**
**  File:           PRIMFUNC.C
**  Description:    Contains general purpose primitive routines
**  Platform:       Windows
**
**
*/

#include <windows.h>
#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <string.h>
#include <stdarg.h>
#include <stdlib.h>
#include "nndefs.h"

	static char msg1[] = "Bad dimensions in alloc_2d_floats()\n";
	static char msg2[] = "Can't alloc storage for dimension 1 in alloc_2d_floats()\n";
	static char msg3[] = "Can't alloc storage for dimension 2 in alloc_2d_floats()\n";
	static char msg4[] = "Bad dimensions in free_2d_float()\n";
	void Logit(LPSTR fmt, ...);

	union {
		float f;
		long l;
		} MissingUnion;
#define MISSING (MissingUnion.f)

/*
** fgetstr
**
** This function is called to read in a string from an open file. Any ASCII character
** less than or equal to a blank will terminal the string.
** 
**
** Arguments:
**
**      FILE *fd	A pointer to a open file
**      LPSTR str	A pointer to a buffer to put the read in string
**
** Returns:
**
**      int			returns a zero if there were no errors
*/

int fgetstr (FILE *fd, LPSTR str){
	int gs;
	LPSTR ps = str;
	gs = fgetc(fd);
	while (gs < 33) {
		if (gs<0) return gs;
		gs = fgetc(fd);
	}
	while (gs > 32) {
		*str=gs;
		str++;
		gs = fgetc(fd);
	}
	*str=0;
	if (gs < 0) return gs;
	else return 0;
}

/*
** fgetfloat
**
** This function is called to read in a floating point number from an open file. 
** 
**
** Arguments:
**
**      FILE *fd	A pointer to a open file
**
** Returns:
**
**      float		returns the floating point number read in
*/

float fgetfloat (FILE *fd)
{
	static char cdummy[32];
	float f;
	fgetstr(fd,cdummy);
	f=(float)atof(cdummy);
	return f;
}

/*
** fgetint
**
** This function is called to read in a integer number from an open file. 
** 
**
** Arguments:
**
**      FILE *fd	A pointer to a open file
**
** Returns:
**
**      int		returns the integer number read in
*/

int fgetint (FILE *fd)
{
	static char cdummy[32];
	int i;
	fgetstr(fd,cdummy);
	i=atoi(cdummy);
	return i;
}

/*
** fgetlong
**
** This function is called to read in a long integer number from an open file. 
** 
**
** Arguments:
**
**      FILE *fd	A pointer to a open file
**
** Returns:
**
**      long		returns the long integer number read in
*/

long fgetlong (FILE *fd)
{
	static char cdummy[32];
	long l;
	fgetstr(fd,cdummy);
	l=atol(cdummy);
	return l;
}

/*
** alloc_2d_floats
**
** This function is called to create an 2 dimensional array of floating point numbers
** 
**
** Arguments:
**
**      int hi1d	The number of columns of numbers
**      int hi2d	The number of rows of numbers
**
** Returns:
**
**      float **	returns a pointer to the array of 
*/

float  **alloc_2d_floats(int hi1d, int hi2d )
{
	int	 i;
	float **m;
	int len;
	/* check dimensions first */
	if( hi1d<1 || hi2d<1 ) {
		return NULL;
	}
	
	m = (float**) malloc (sizeof(float*) * hi1d);
	if( m == NULL ) {
		return NULL;
	}                  
	len = hi2d*sizeof(float);
	for( i=0; i<hi1d; ++i ) {
		m[i] = (float *) malloc (sizeof(float)*hi2d) ;
		if( m[i] == NULL ) {
			for( i--; i> 0; --i ) free (m[i]);
			free (m);
			return NULL;
		}
		memset (m[i],0,len);
	}
	return m;

} // end alloc_2d_floats 

/*
** free_2d_floats
**
** This function is called to destroy the 2d array of floating point numbers
** 
**
** Arguments:
**
**      int **matrix	The pointer to the 2D array
**      int hi1d		The number of columns of numbers
**
** Returns:
**
**      Nothing
*/

void free_2d_floats( float **matrix, int hi1d)
{
	int i;

	// check dimensions first 
	if( hi1d<1 ) {
		return;
	}
	if( matrix == NULL ) return;
	for( i=0; i<hi1d; i++ ) free (matrix[i]);
	free (matrix);

} // end free_2d_floats 

/*
** ToUpper
**
** This function is called to convert a string to upper case
** 
**
** Arguments:
**
**      char *s		A pointer to the character string
**
** Returns:
**
**      Nothing
*/

void ToUpper (char *s) {
	strupr(s);
}

/*
** isstring
**
** This function is called to check to see if the field is a string that can be
** converted to a number 
** a number is '0123456789+-eE' but not '.'                      
** 
**
** Arguments:
**
**      char *s		A pointer to the character string
**
** Returns:
**
**      int			returns a 1 if the string is not a number
*/

int isstring (const char *s) {
	while (*s!=0) {
		if ((*s>='A') && ((*s != 'e') || (*s != 'E'))) return 1;
		s++;
	}
	return 0;
}

/*
** ChkClip
**
** This function is called to check to see if the number is to be clipped
** 
**
** Arguments:
**
**      float f		The value to be cliped
**      float hi	The high clip value
**      float lo	The low clip value
**
** Returns:
**
**      int			returns a 1 if the number is to be clipped
*/
            
int ChkClip (float f, float hi, float lo)
{
	if (f==MISSING) return 1;
	if ((hi!=MISSING) && (f > hi)) return 1;
	if ((lo!=MISSING) && (f < lo)) return 1;
	return 0;
}

/*
** dump
**
** This function is called to dump a buffer to the log file in hex format
** 
**
** Arguments:
**
**      char *buf	A pointer to the buffer to be dumped
**      int count	The number of bytes in the buffer to be dumped
**
** Returns:
**
**      Nothing
*/
            
void dump (const char *buf,int count)
{
    int i;
    static char obuf[128];
    char tbuf[12];
    if (count==0) count=strlen(buf);

	obuf[0]=0;
	for (i=0; i < count; i++) {
		if ((i % 16) == 0) {
			strcat (obuf,"\n");
			Logit (obuf);
			sprintf (obuf,"%04x - ",i);
		} 
		sprintf (tbuf,"%02x ",(buf[i]&0xff));
		strcat (obuf,tbuf);
	}
	strcat (obuf,"\n");
	Logit (obuf);
}

/*
** removeleadingblanks
**
** This function is called to strip a buffer of leading blanks
** 
**
** Arguments:
**
**      char *buf	A pointer to the buffer to be striped
**
** Returns:
**
**      Nothing
*/
            
void removeleadingblanks (char *s) {
	char *p = s;
	while (*p==32) p++;
	strcpy (s,p);
}

/*
**  fixfieldsize
**
** This function is called to blank pad a buffer to a fixed size
** 
**
** Arguments:
**
**      char *buf	A pointer to the buffer to be padded
**
** Returns:
**
**      Nothing
*/
            
void fixfieldsize(char *s)
{
	int i;
	int l = strlen(s);
	if (l >= MAXSTRING) {
		s[MAXSTRING]=0;
		s[MAXSTRING-1]=32;
		return;
	}
	for (i=l; i < MAXSTRING; i++) s[i] = 32;
	s[MAXSTRING]=0;
}

/*
** Logit
**
** This function is called to print a string to the log file. Each record is appended to
** the end of the log file.
** 
**
** Arguments:
**
**      char *fmt	A pointer to the format string (same as the printf function)
**
** Returns:
**
**      Nothing
*/
            
void Logit(LPSTR fmt, ...)
{
	FILE *fd;
	char buf[512];
	extern int SessionLog;
	int ret;
	
	va_list args;
	va_start(args,fmt);
	ret = vsprintf(buf,fmt,args);
	fd = fopen("c:\\nncalc.log","a+");
	fputs (buf,fd);
	fclose(fd);
	va_end(args);
}

