#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "nndefs.h"
#include "params.h"
#include "datamat.h"
#include "neural.h"
       
	NEURAL *tneural;       	       
	void Logit(const char* fmt, ...);
	FILE *fd;
	float *Ivec,*Ovec;
	char buf[128], fname[128], m1[16],m2[16];    
	int i;

void main () {

	unlink ("nnlib.log");
	printf ("\nNNLIB interrogation test program v1.2\n    Enter END to an input prompt to exit program\n\n");
	printf ("Enter model name = ");
	gets (buf);
	if ((buf[0]=='E') || (buf[0]=='e')) exit(0);
	printf ("\n");
	
	strcpy (fname,buf);
	strcat (fname,".ENN");
    tneural = LoadNetwork(fname);
    if (tneural == NULL) {
   		printf ("Load error <%s>\n",buf);
   		exit(1); 
   	}

    fd = fopen("itest.dmp","w");
    //DumpNeural(tneural,fd);
    fclose (fd);

	Ivec = (float*) malloc (sizeof(float)*tneural->m_ninputs);
	Ovec = (float*) malloc (sizeof(float)*tneural->m_noutputs);
	
loop:

	for (i=0;i<tneural->m_ninputs;i++) {
		sprintf (m1,tneural->m_dm->m_icoldesc[i].format,tneural->m_dm->m_icoldesc[i].min);
		sprintf (m2,tneural->m_dm->m_icoldesc[i].format,tneural->m_dm->m_icoldesc[i].max);
		printf ("Enter %8s (range %10s to %10s ) = ",tneural->m_dm->m_icoldesc[i].vlab,m1,m2);
		gets (buf);
		if ((buf[0]=='E') || (buf[0]=='e')) goto getout;
		sscanf (buf,"%f",&Ivec[i]);
	}
	printf ("\n");
	NInterrogate(tneural,Ivec,Ovec);
	for (i=0;i<tneural->m_noutputs;i++) {
		sprintf (m1,tneural->m_dm->m_ocoldesc[i].format,Ovec[i]);
		printf ("\n%8s = %10s",tneural->m_dm->m_ocoldesc[i].vlab,m1);
	}
	printf ("\n\n");
	
	goto loop;

getout:
	free (Ivec);
	free (Ovec);
    NDeleteNeural(tneural);
    exit(1);
    
}
