VERSION 2.00
Begin Form frmSapList 
   BackColor       =   &H00C0C0C0&
   Caption         =   "SAPList"
   ClientHeight    =   6750
   ClientLeft      =   1020
   ClientTop       =   1905
   ClientWidth     =   7995
   Height          =   7155
   Icon            =   SAPLIST.FRX:0000
   Left            =   960
   LinkTopic       =   "Form1"
   ScaleHeight     =   6750
   ScaleWidth      =   7995
   Top             =   1560
   Width           =   8115
   Begin Frame frStats 
      BackColor       =   &H00C0C0C0&
      Height          =   990
      Left            =   120
      TabIndex        =   8
      Top             =   5720
      Width           =   7815
      Begin CommandButton cmdConfig 
         Caption         =   "Config"
         Height          =   315
         Left            =   2325
         TabIndex        =   4
         Top             =   525
         Width           =   705
      End
      Begin ComboBox comShow 
         Height          =   300
         Left            =   600
         Style           =   2  'Dropdown List
         TabIndex        =   2
         Top             =   525
         Width           =   1440
      End
      Begin ComboBox comSort 
         Height          =   300
         Left            =   600
         Style           =   2  'Dropdown List
         TabIndex        =   1
         Top             =   180
         Width           =   1440
      End
      Begin CommandButton cmdAbout 
         Caption         =   "About"
         Height          =   315
         Left            =   2325
         TabIndex        =   3
         Top             =   150
         Width           =   705
      End
      Begin Timer tim 
         Enabled         =   0   'False
         Interval        =   900
         Left            =   75
         Top             =   825
      End
      Begin Label Label5 
         AutoSize        =   -1  'True
         BackColor       =   &H00C0C0C0&
         Caption         =   "Show:"
         Height          =   195
         Left            =   75
         TabIndex        =   6
         Top             =   540
         Width           =   540
      End
      Begin Label Label1 
         AutoSize        =   -1  'True
         BackColor       =   &H00C0C0C0&
         Caption         =   "Sort:"
         Height          =   195
         Left            =   120
         TabIndex        =   15
         Top             =   225
         Width           =   420
      End
      Begin Label Label3 
         AutoSize        =   -1  'True
         BackColor       =   &H00C0C0C0&
         Caption         =   "No Pkt Buff available:"
         Height          =   195
         Left            =   3675
         TabIndex        =   14
         Top             =   675
         Width           =   1890
      End
      Begin Label lblNoBuff 
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Height          =   225
         Left            =   5625
         TabIndex        =   13
         Top             =   675
         Width           =   1260
      End
      Begin Label Label2 
         AutoSize        =   -1  'True
         BackColor       =   &H00C0C0C0&
         Caption         =   "Packet Queue Len:"
         Height          =   195
         Left            =   3900
         TabIndex        =   12
         Top             =   450
         Width           =   1665
      End
      Begin Label lblQlen 
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Height          =   225
         Left            =   5625
         TabIndex        =   11
         Top             =   450
         Width           =   915
      End
      Begin Label label 
         AutoSize        =   -1  'True
         BackColor       =   &H00C0C0C0&
         Caption         =   "Total Address Count: "
         Height          =   195
         Left            =   3750
         TabIndex        =   10
         Top             =   150
         Width           =   1860
      End
      Begin Label lblAcount 
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   1  'Fixed Single
         Height          =   225
         Left            =   5625
         TabIndex        =   9
         Top             =   150
         Width           =   915
      End
   End
   Begin VScrollBar vs 
      Height          =   5370
      LargeChange     =   10
      Left            =   7620
      Min             =   1
      TabIndex        =   0
      Top             =   350
      Value           =   1
      Width           =   240
   End
   Begin PictureBox picText 
      BackColor       =   &H00808080&
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Courier New"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   5340
      Left            =   120
      ScaleHeight     =   354
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   494
      TabIndex        =   5
      TabStop         =   0   'False
      Top             =   360
      Width           =   7440
   End
   Begin Label lblHeader 
      BackColor       =   &H00C0C0C0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "  Age   Last  Num Type   Address                   Name"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Courier New"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00FFFFFF&
      Height          =   285
      Left            =   120
      TabIndex        =   7
      Top             =   40
      Width           =   7395
   End
End
Option Explicit


Dim InDisplay%
Dim statTopOff%, picHeightOff%

Dim curPicWidth%, curPicHeight%, curShow%, pichWnd%

Sub cmdAbout_Click ()
   frmAbout.Show 1
   vs.SetFocus
End Sub

Sub cmdConfig_Click ()
frmConfig.Show 1
vs.SetFocus
End Sub

Sub comShow_Click ()
   If Me.Visible Then
      Call UpdateVars
      If vs.Value <> vs.Min Then
         vs.Value = vs.Min
      Else
         Call doEntries(False)
      End If
      vs.SetFocus
   End If
End Sub

Sub comSort_Click ()
   If Not Me.Visible Then Exit Sub

   Screen.MousePointer = 11
   Me.MousePointer = 11
   DoEvents

   Call slSort(Int(comSort.ItemData(comSort.ListIndex)))

   If vs.Value <> vs.Min Then
      vs.Value = vs.Min
   Else
      Call doEntries(False)
   End If

   Screen.MousePointer = 0: Me.MousePointer = 0
   vs.SetFocus
End Sub

Sub doEntries (scroll%)
   If InDisplay Then Exit Sub
   InDisplay = True

   Dim nAddr%, qused%, nbuff%, cnbuff%, txt$, i%, j%
   
   i = slProcess(nAddr, qused, nbuff, cnbuff)
   If i <> 0 Then
      MsgBox "Out of Memory error in SAPList.  Now Terminating!", 48, "Out of Memory Error!"
      Unload Me
      Exit Sub
   End If
 
   If scroll Then
      i = Int(vs.Value)
   Else
      i = -1
   End If
   j = slShow(i, curPicHeight, curPicWidth, curShow, pichWnd)
   vs.Max = nAddr: vs.Value = j

   lblAcount.Caption = Str$(nAddr)
   lblQlen.Caption = Str$(qused)
   lblNoBuff.Caption = Str$(nbuff) + ", " + Str$(cnbuff)

   InDisplay = False
End Sub

Sub Form_Load ()
   Dim i&, a$, nsapecb%, npktbuff%
   
   Call GetConfigs(nsapecb, npktbuff)

   i = slInit(nsapecb, npktbuff, Int(picText.FontSize))
   If i <> 0 Then
      a$ = getErrText(i)
      MsgBox "Error: " + a$, 0, "SAPList Startup error!"
      Unload Me
      Exit Sub
   End If

   Me.Left = (Screen.Width / 2) - (Me.Width / 2)
   Me.Top = (Screen.Height / 2) - (Me.Height / 2)

   statTopOff = Me.ScaleHeight - frStats.Top
   picHeightOff = Me.ScaleHeight - (picText.Top + picText.Height)
   
   comSort.Clear
   comSort.AddItem "Address": comSort.ItemData(0) = SORT_NODE
   comSort.AddItem "Network": comSort.ItemData(1) = SORT_NET
   comSort.AddItem "Name": comSort.ItemData(2) = SORT_NAME
   comSort.AddItem "Server Type": comSort.ItemData(3) = SORT_TYPE
   comSort.ListIndex = 0

   comShow.Clear
   comShow.AddItem "All": comShow.ItemData(0) = SHOW_ALL
   comShow.AddItem "Good": comShow.ItemData(1) = SHOW_GOOD
   comShow.AddItem "Marginal": comShow.ItemData(2) = SHOW_MARGINAL
   comShow.AddItem "Bad": comShow.ItemData(3) = SHOW_BAD
   comShow.ListIndex = 0

   Call UpdateVars

   InDisplay = False
   tim.Enabled = True
End Sub

Sub Form_Paint ()
   Call doEntries(False)
End Sub

Sub Form_Resize ()

If Me.WindowState = 1 Then Exit Sub

If Me.Width < 8175 Then Me.Width = 8175: Exit Sub
If Me.Height < 6210 Then Me.Height = 6210: Exit Sub

picText.Height = Me.ScaleHeight - (picText.Top + picHeightOff)
picText.Width = Me.ScaleWidth - ((picText.Left * 2) + vs.Width)

frStats.Top = Me.ScaleHeight - statTopOff
frStats.Width = picText.Width + vs.Width

lblHeader.Width = picText.Width

vs.Top = picText.Top
vs.Left = picText.Left + picText.Width
vs.Height = picText.Height

vs.LargeChange = Int(picText.ScaleHeight / picText.TextHeight("X_")) - 2

Call UpdateVars
End Sub

Sub Form_Unload (Cancel As Integer)
   Call slDeInit
End Sub

Sub tim_Timer ()
   Call doEntries(False)
End Sub

Sub UpdateVars ()
   curPicHeight = Int(picText.ScaleHeight)
   curPicWidth = Int(picText.ScaleWidth)
   curShow = Int(comShow.ItemData(comShow.ListIndex))
   pichWnd = picText.hWnd
End Sub

Sub vs_Change ()
   Call doEntries(True)
End Sub

