Option Explicit

Declare Function slInit& Lib "saplist.dll" (ByVal nECBs%, ByVal nBuffs%, ByVal fontSize%)
Declare Sub slDeInit Lib "saplist.dll" ()

Declare Sub slSort Lib "saplist.dll" (ByVal sortOpt%)

Declare Function slProcess% Lib "saplist.dll" (numAddresses%, buffqlen%, nobuffcnt%, cumnobuffcnt%)
Declare Function slShow% Lib "saplist.dll" (ByVal ncurr%, ByVal height%, ByVal wide%, ByVal showOpt%, ByVal hWnd%)


Declare Function GetPrivateProfileString% Lib "kernel.exe" (ByVal sect$, ByVal ent$, ByVal def$, ByVal dat$, ByVal dlen%, ByVal iniFile$)
Declare Function WritePrivateProfileString% Lib "kernel.exe" (ByVal sect$, ByVal ent$, ByVal dat$, ByVal iniFile$)




Global Const SORT_NODE% = 0
Global Const SORT_NET% = 1
Global Const SORT_NAME% = 2
Global Const SORT_TYPE% = 3

Global Const SHOW_ALL% = 0
Global Const SHOW_GOOD% = 1
Global Const SHOW_MARGINAL% = 2
Global Const SHOW_BAD% = 3


Global Const MIN_SAP_ECB% = 2
Global Const DEF_SAP_ECB% = MIN_SAP_ECB% + 5
Global Const MAX_SAP_ECB% = 30

Global Const MIN_PKTBUFF% = 10
Global Const DEF_PKTBUFF% = MIN_PKTBUFF + 10
Global Const MAX_PKTBUFF% = 500

Global iniName$

Sub GetConfigs (nsapecb%, npktbuff%)

   iniName$ = App.Path + "\" + App.EXEName + ".ini"

   If Len(Dir$(iniName$)) = 0 Then
      Call iniPutString("Startup", "SapEcbs", Str$(DEF_SAP_ECB), iniName$)
      Call iniPutString("Startup", "PacketBuffs", Str$(DEF_PKTBUFF), iniName$)
   End If

   nsapecb = Val(iniGetString("Startup", "SapEcbs", Str$(DEF_SAP_ECB), iniName$))
   npktbuff = Val(iniGetString("Startup", "PacketBuffs", Str$(DEF_PKTBUFF), iniName$))
End Sub

Function getErrText$ (ByVal i&)
   Dim l%, h%, a$

   l = Int(i And 255)
   h = Int(i / 65536)

   Select Case l
      Case 1
         a$ = "Couldn't initialize IPX.  Novell Error=0x" + Hex$(h)
      Case 2
         a$ = "Couldn't open SAP socket.  Novell Error=0x" + Hex$(h)
      Case 3
         a$ = "Insufficient memory or ECB buffers would exceed 64k"
      Case 4
         a$ = "Insufficient memory or ECB fragment buffers would exceed 64k"
      Case 5
         a$ = "Insufficient memory for specified number of Packet Buffers"
      Case 6
         a$ = "Couldn't make ProcInstance for ECB Service routine"
      Case 7
         a$ = "Couldn't make ProcInstance for Timer Service routine"""
   End Select
   getErrText = a$
End Function

Function iniGetString$ (ByVal sect$, ByVal ent$, ByVal def$, ByVal iniFile$)
   Dim i%, dat$

   dat$ = Space(200)
   i = GetPrivateProfileString(sect$, ent$, def$, dat$, Len(dat$), iniFile$)
   i = InStr(dat$, Chr$(0)): dat$ = Trim(Left$(dat$, i - 1))

   iniGetString = dat$
End Function

Sub iniPutString (ByVal sect$, ByVal ent$, ByVal dat$, ByVal iniFile$)
   Dim i%
   i = WritePrivateProfileString(sect$, ent$, dat$, iniFile$)
End Sub

