
/*

saplist.c

*/

#define STRICT
#define VBEXPORT	_far _pascal _export

#include "saplist.h"





GLOBALS		glob;
LPGLOBALS	gl;







void	clearBools(void){
	gl->initCalled = FALSE;
	gl->Enabled = FALSE;
	
	gl->initIPX = FALSE;
   gl->openSock = FALSE;
   gl->allocECB = FALSE;
   gl->makeIpxProc = FALSE;
   gl->makeTimerProc = FALSE;
   gl->prepTimer = FALSE;
   gl->prepECB = FALSE;
   
   gl->myFont = NULL;
   gl->clrPen = NULL;
   gl->clrBrush = NULL;

	gl->nBuffs = gl->nSaps = gl->nSapBlocks = 0;
	
	gl->sortMode = SORT_NODE;
	return;
}








void far _loadds ecbTimer(void){
	if( gl->Enabled ) gl->currTime++;
	IPXScheduleIPXEvent( gl->tid, 18, &gl->timer );
	return;
}



void far _loadds ecbSAPservice(void){
	LPECB			e;
	LPPKTBUFF	p;

	_asm{
		mov	[word ptr e], si
		mov	[word ptr e+2], es
	}
	
	if( gl->Enabled ){
		p= (LPPKTBUFF)e->fragmentDescriptor[0].address;
		p->currTime = gl->currTime;

		if( gl->usepktb )
			(gl->usepktb)->nxt = p;
		else
			gl->usepktt = p;
				
		gl->usepktb = p;
		p->nxt = NULL;
	
				
		p = gl->freepkt;
		if( p ){
			gl->freepkt = p->nxt;
			gl->nBuffUsed++;
			e->fragmentDescriptor[0].address = (void far *)p;
			e->fragmentDescriptor[0].size = MAX_IPX_PACKET_SIZE;
			IPXListenForPacket( gl->tid, e );
		}
		else{
			e->linkAddress = (void far *)gl->noBuffECB;
			gl->noBuffECB = e;
			gl->noBuffer++;
		}
	}
	else{
		e->fragmentDescriptor[0].size = MAX_IPX_PACKET_SIZE;
		IPXListenForPacket( gl->tid, e );
	}
	
	return;
}










void	addEntry(LPSAPDAT	s, LPSAPDAT *top, LPSAPDAT *bottom){
	BOOL			beforeCurSap = TRUE;
	LPSAPDAT		ns,prv;
	int			i;
	
	ns = *top;
	
	s->prv = s->nxt = NULL;
	
	if( ns ){
		while(ns){
	   	switch(gl->sortMode){
	   		case SORT_NODE:
	   			if( (i = memcmp( ns->addr.node, s->addr.node, 6))==0 )
	   				i = stricmp(ns->name,s->name);
	   			break;
			      			
	   		case SORT_NET:
	   			if( (i=memcmp(ns->addr.network, s->addr.network,4))==0 )
	   				if( (i = memcmp(ns->addr.node, s->addr.node, 6))==0 )
	   					i = stricmp(ns->name,s->name);
	   			break;
			      				
	   		case SORT_NAME:
	   			if( (i = stricmp(ns->name,s->name))==0 )
	      			if( (i=memcmp(ns->addr.network, s->addr.network,4))==0 )
	      				i = memcmp(ns->addr.node, s->addr.node, 6);
	   			break;
			      			
	   		case SORT_TYPE:
	   			if( ns->svrType < s->svrType ) 
	   				i= -1;
	   			else if( ns->svrType == s->svrType ){
	      			if( (i = stricmp(ns->name,s->name))==0 )
		      			if( (i=memcmp(ns->addr.network, s->addr.network,4))==0 )
		      				i = memcmp(ns->addr.node, s->addr.node, 6);
	   			}
	   			else i = 1;
	   			break;
	   	}
			      	
	   	if( i > 0 ){
	   		prv = ns->prv;
			      		
	   		s->nxt = ns;
	   		s->prv = prv;
	   		ns->prv = s;
			      		
	   		if( prv ) prv->nxt = s;
			      		
	   		if( ns == (*top) ) (*top) = s;
	   		
	   		if( beforeCurSap ) gl->curSapNum++;
	   		break;
	   	}
	   	if( ns == gl->curSap ) beforeCurSap = FALSE;
	   	ns = ns->nxt;
	   }
	   if( !ns ){
			(*bottom)->nxt = s;
			s->prv = (*bottom);
			(*bottom) = s;
		}
	}	   
   else{
   	*top = *bottom = s;
   	gl->curSap = s;
   	gl->curSapNum = 1;
   }
	   
	return;
}








LPSAPDAT	selectEntry( LPPKTBUFF p ){
	SAPHeader far *pkt;
	
	LPEBLOCK		eb, lb, nb;
	LPSAPDAT		s, ns;
	WORD			v;
	int			i,j;

	pkt = (SAPHeader far *)p->dat;

	eb = gl->firstSapBlock;
	for(i=0; i< sizeof(IPXAddress); i++){
	
		if( !eb ){
			if( !gl->freeSapBlocks ){
				if( gl->nSapBlocks == MAX_BLOCK_GROUPS ) return NULL;
				
				j = gl->nSapBlocks;
				if( !(gl->hSapBlocks[j] = GlobalAlloc( GHND, NUM_BLOCKS_PER_GROUP * sizeof(EBLOCK))) )
					return NULL;
				gl->nSapBlocks++;
				if( !(nb = (LPEBLOCK)GlobalLock( gl->hSapBlocks[j])) )
					return NULL;
				
				for(j=0; j< NUM_BLOCKS_PER_GROUP; j++){
					nb[j].nxt = gl->freeSapBlocks;
					gl->freeSapBlocks = &nb[j];
				}
			}
			eb = gl->freeSapBlocks;
			gl->freeSapBlocks = eb->nxt;
			
			memset(eb,0,sizeof(EBLOCK));
			if( !gl->firstSapBlock )
				gl->firstSapBlock= eb;
			else
				lb->addrByte[v] = (LPBYTE)eb;
		}

		v = (BYTE) ((LPBYTE)&pkt->serverAddress)[i];
		lb = eb;
		eb = (LPEBLOCK)eb->addrByte[v];
	}
	
	eb = (LPEBLOCK)lb->addrByte[v];
	
	if( (s = (LPSAPDAT)eb) != NULL ){
		s->nSaps++;
		s->lastInterval = (p->currTime - s->lastSap);
	}
	else{
		if( !gl->freeSaps ){
			if( gl->nSaps == MAX_SAP_GROUPS ) return NULL;
			
			j = gl->nSaps;
			if( !(gl->hSaps[j] = GlobalAlloc( GHND, NUM_SAPS_PER_GROUP * sizeof(SAPDAT))) )
				return NULL;
			gl->nSaps++;
			if( !(ns = (LPSAPDAT)GlobalLock( gl->hSaps[j] )) )
				return NULL;
				
			for(j=0; j< NUM_SAPS_PER_GROUP; j++){
				ns[j].nxt = gl->freeSaps;
				gl->freeSaps = &ns[j];
			}
		}
		s = gl->freeSaps;
		gl->freeSaps = s->nxt;

		lb->addrByte[v] = (LPBYTE)s;
		memset(s,0,sizeof(SAPDAT));
				
		memcpy( (LPBYTE)&s->addr, (LPBYTE)&pkt->serverAddress, sizeof(IPXAddress));
		memset( s->name, 0, 50);
		memcpy( (LPBYTE)s->name, (LPBYTE)pkt->serverName, 48);
		s->svrType = NWWordSwap( pkt->serverType );
		s->nSaps = 1;
		s->lastInterval = 0;

		gl->nAddressCount++;

		addEntry(s,&gl->firstSap, &gl->lastSap);      
	}
	s->lastSap = p->currTime;
	return s;
}











int	VBEXPORT	slProcess( int far *nAddr, int far *buffQlen, int far *noBuffCount, int far *cumNoBuffCount ){
	LPPKTBUFF	p;
	LPECB			e;
	int			i;

	*noBuffCount = gl->noBuffer;
	
	gl->cnoBuffer += gl->noBuffer;
	*cumNoBuffCount = gl->cnoBuffer;

	*buffQlen = gl->nBuffUsed;
	
	i = gl->nBuffUsed;
	while( i-- ){
		_asm cli;
		p = gl->usepktt;
		if( p ){
			gl->usepktt = p->nxt;
			if( !gl->usepktt ) gl->usepktb = NULL;
		}
		_asm sti;
		
		if( p ){
			if( !selectEntry(p) ){
				gl->Enabled = FALSE;
				return -1;
			}
	
			if( !gl->noBuffECB ){
				_asm cli;
				p->nxt = gl->freepkt;
				gl->freepkt = p;
				gl->nBuffUsed--;			
				_asm sti;
			}
			else{
				_asm cli;
				e = gl->noBuffECB;
				gl->noBuffECB = (gl->noBuffECB)->linkAddress;
				_asm sti;
				
				e->fragmentDescriptor[0].address = (void far *)p;
				e->fragmentDescriptor[0].size = MAX_IPX_PACKET_SIZE;
				IPXListenForPacket( gl->tid, e );
			}
		}
		else break;
	}

	*nAddr = gl->nAddressCount;

	gl->noBuffer = 0;
	return 0;
}










int	VBEXPORT	slShow( int ncurr, int height, int width, int showOpt, HWND hWnd ){
	HDC			hdc;
	LPSAPDAT		s;
	DWORD			age;
	LPBYTE		p1;
	BYTE			buff[200];
	int			i,y,x, myHeight, oldbkmode, sapNum, cnt;
	HFONT			oldFont;
	HBRUSH		oldbrush;
	HPEN			oldpen;
	COLORREF		bkcol;
	
	if( !gl->firstSap ) return 0;
	
	hdc = GetDC( hWnd );
	oldbkmode = SetBkMode(hdc,OPAQUE);
	
	if( !gl->myFont ) {
	   gl->myFont = CreateFont(-gl->fontSize,0,0,0,0,0,0,0,0,0,0,0,0,"Courier New");
	   
		oldFont = SelectObject( hdc, gl->myFont );
	   gl->txtHeight = HIWORD(GetTextExtent(hdc,"X_",2));
	   
		bkcol = GetBkColor(hdc);
		gl->clrPen = CreatePen(PS_SOLID,0,bkcol);
		gl->clrBrush = CreateSolidBrush(bkcol);
	}
	else oldFont = SelectObject( hdc, gl->myFont );
	
	oldpen = SelectObject(hdc,gl->clrPen);
	oldbrush = SelectObject(hdc,gl->clrBrush);
	
	myHeight = (int)((float)gl->txtHeight);
	
	if( ! ncurr ){
		gl->curSap = gl->firstSap;
		gl->curSapNum = 1;
	}
	else{
		if( ncurr != -1 ){
			if( ncurr != gl->curSapNum ){
				s = gl->firstSap;
				sapNum = 1;
				while( sapNum != ncurr ) s= s->nxt,sapNum++;
				gl->curSap = s;
				gl->curSapNum = sapNum;
			}
		}
	}
	
	s= gl->curSap;
	sapNum = gl->curSapNum;
	
	y= 0;
	cnt = 0;
	while( y <= height ){
		age = (gl->currTime - s->lastSap);
		
		if( 	(showOpt == SHOW_ALL)	||
				(showOpt == SHOW_GOOD && age <=63 ) ||
				(showOpt == SHOW_MARGINAL && age > 63 && age <= 126 ) ||
				(showOpt == SHOW_BAD && age > 126 ) ){
			
			if( y==0 && cnt ){
				gl->curSap = s;
				gl->curSapNum = sapNum;
			}
			p1 = buff;
			wsprintf(p1," %5li  %5li  %4li  %04X   ", age, s->lastInterval,s->nSaps, s->svrType );
			p1 += strlen(p1);
			
			for(i=0; i<4; i++){
				wsprintf(p1,"%02X", (BYTE)s->addr.network[i] );	 p1 += 2;
			}
			wsprintf(p1,":"); p1++;
			for(i=0; i<6; i++){
				wsprintf(p1,"%02X", (BYTE)s->addr.node[i] );	p1 += 2;
			}
			wsprintf(p1,":"); p1++;
			for(i=0; i<2; i++){
				wsprintf(p1,"%02X", (BYTE)s->addr.socket[i] );	p1 += 2;
			}
			wsprintf(p1,"   [%s]", s->name );
			
			if( age <= 62 )
				SetTextColor(hdc, MYC_GREEN );
			else if( age<=125 )
				SetTextColor(hdc, MYC_YELLOW );
			else
				SetTextColor(hdc, MYC_RED );
			
			TextOut(hdc, 0, y, buff, strlen(buff));
			
			x = LOWORD(GetTextExtent(hdc,buff,strlen(buff)));
			if( x < width ) Rectangle(hdc,x,y,width+1,y+myHeight+1);
			
			y += myHeight;
		}
		else if( y==0 ) sapNum++;
		
		cnt++;
		s= s->nxt;
		if( !s ) break;
	}
	if( y < height ) 	Rectangle(hdc,0,y+1,width+1,height+1);
   
	SelectObject(hdc,oldpen);
	SelectObject(hdc,oldbrush);
	SelectObject( hdc, oldFont );
	SetBkMode(hdc,oldbkmode);
	ReleaseDC( hWnd, hdc );
	
	return gl->curSapNum;
}









void	VBEXPORT	slSort( int	sortMode ){
	LPSAPDAT		s,nfirst,nlast;
	
	gl->sortMode = sortMode;
	
	nfirst = nlast = NULL;
	
   while( gl->firstSap ){
   	s = gl->firstSap;
   	gl->firstSap = (gl->firstSap)->nxt;
   	addEntry(s,&nfirst,&nlast);
   }
   if( nfirst ){
   	gl->firstSap = nfirst;
   	gl->lastSap = nlast;
   }
	      
	return;
}







long	VBEXPORT	slInit( int nECBs, int numBuff, int fontSize ){
	int			i,j,rc;
	LPECB			e;
	LPPKTBUFF	t;
	IPXAddress	addr;
	BYTE			iaddr[6];
	
	if( gl->initCalled ) return -1;
	
   clearBools();
	gl->initCalled = TRUE;
   
   
   gl->fontSize = fontSize;
	gl->numECB = nECBs;

	
	gl->tid = 0;
	if( (rc = IPXInitialize( &gl->tid, gl->numECB+1, MAX_IPX_PACKET_SIZE )) != 0 ) 
		return ((((long)rc)<<16)+1);
	gl->initIPX = TRUE;


	   
	gl->sock = NWWordSwap( SAP_SOCKET );
	if( (rc = IPXOpenSocket(gl->tid, &gl->sock, 0)) != 0 ) 
		return ((((long)rc)<<16)+2);
	gl->openSock = TRUE;
	

	if( (long)gl->numECB * (long)sizeof(ECB) >= 65536L ) return 3;
	if( (gl->hECB = GlobalAlloc( GHND, gl->numECB * sizeof(ECB))) == NULL ) 
		return 3;
	gl->allocECB = TRUE;
	if( (gl->ecbList = (LPECB)GlobalLock( gl->hECB )) == NULL ) 
		return 3;


   

	gl->usepktb = gl->usepktt = NULL;
	gl->freepkt = NULL;
	
	gl->nBuffUsed = gl->cnoBuffer = gl->noBuffer = gl->nBuffs = 0;
	
	i=0;
	while( i<= numBuff + gl->numECB ){
		j = gl->nBuffs;
		if( (gl->hBUFF[j] = GlobalAlloc( GHND, NUM_BUFFS_PER_GROUP * sizeof( PKTBUFF )))== NULL ) 
			return 5;
		gl->nBuffs++;
		if( (t = (LPPKTBUFF)GlobalLock( gl->hBUFF[j] )) == NULL ) 
			return 5;
				
		for(j=0; j< NUM_BUFFS_PER_GROUP; j++){
			t[j].nxt = gl->freepkt;
			gl->freepkt = &t[j];
		}
		i += NUM_BUFFS_PER_GROUP;
	}
	



	
	if( (gl->lpecbSAPservice = MakeProcInstance( (FARPROC)ecbSAPservice, gl->myInst )) == NULL ) 
		return 6;
	gl->makeIpxProc = TRUE;
	
	gl->noBuffECB = NULL;
	
	IPXGetInternetworkAddress( gl->tid, (LPBYTE)&addr );
	*(LPWORD)addr.socket = NWWordSwap( gl->sock );
	IPXGetLocalTarget( gl->tid, (LPBYTE)&addr, (LPBYTE)iaddr, &i );
	
	for(i=0; i< gl->numECB; i++){
		e = &gl->ecbList[i];
		
		t = gl->freepkt;
		gl->freepkt = (gl->freepkt)->nxt;
		t->nxt = NULL;
		
		e->ESRAddress = (void far *)gl->lpecbSAPservice;
		e->socketNumber = gl->sock;
		memcpy( e->immediateAddress, iaddr, 6);
		e->fragmentCount = 1;
		e->fragmentDescriptor[0].address = (void far *)t;
		e->fragmentDescriptor[0].size = MAX_IPX_PACKET_SIZE;
		
		IPXListenForPacket( gl->tid, e );
	}
	gl->prepECB = TRUE;





   gl->currTime = 0;
	if( (gl->lpTimer = MakeProcInstance( (FARPROC)ecbTimer, gl->myInst )) == NULL )
		return 7;
	gl->makeTimerProc = TRUE;
	
	gl->timer.ESRAddress = (void far *)gl->lpTimer;
	gl->timer.socketNumber = gl->sock;
	IPXScheduleIPXEvent( gl->tid, 18, &gl->timer );
	gl->prepTimer = TRUE;



	gl->nAddressCount = 0;
   gl->nSaps = 0;
   gl->firstSap = NULL;
   gl->lastSap = NULL;
   gl->freeSaps = NULL;
	
	gl->nSapBlocks = 0;
	gl->firstSapBlock = NULL;	
	gl->freeSapBlocks = NULL;

	gl->Enabled = TRUE;
	return 0;
}







void	VBEXPORT	slDeInit(void){
	int		i;
	LPECB		e;
	
	if( !gl->initCalled ) return;

	gl->Enabled = FALSE;
	
	if( gl->myFont ) DeleteObject( gl->myFont );
	if( gl->clrPen ) DeleteObject( gl->clrPen );
	if( gl->clrBrush ) DeleteObject( gl->clrBrush );
	
	if( gl->prepECB ){	
		for(i=0; i< gl->numECB; i++){
			e = &gl->ecbList[i];
			IPXCancelEvent( gl->tid, e);
		}
	}
	if( gl->prepTimer )		IPXCancelEvent( gl->tid, &gl->timer );
	if( gl->openSock ) 		IPXCloseSocket( gl->tid, gl->sock );
	if( gl->initIPX )			IPXSPXDeinit( gl->tid );

	if( gl->makeTimerProc)	FreeProcInstance( gl->lpTimer );
	if( gl->makeIpxProc )	FreeProcInstance( gl->lpecbSAPservice );

	if( gl->allocECB )		GlobalUnlock( gl->hECB ), GlobalFree( gl->hECB);

	if( gl->nBuffs ){
		for(i=0; i< gl->nBuffs; i++) GlobalUnlock( gl->hBUFF[i] ),GlobalFree( gl->hBUFF[i] );
	}
	
	if( gl->nSapBlocks ){
		for(i=0; i< gl->nSapBlocks; i++) GlobalUnlock( gl->hSapBlocks[i] ), GlobalFree( gl->hSapBlocks[i] );
	}

	if( gl->nSaps ){
		for(i=0; i < gl->nSaps; i++) GlobalUnlock( gl->hSaps[i] ), GlobalFree( gl->hSaps[i] );
	}
	
	clearBools();
	return;
}













int CALLBACK WEP(int exitType){
	if( gl->initCalled ) slDeInit();
	return 1;
}




int _far _pascal _export LibMain(HANDLE hinst,int wDataSeg,int cbHeapSize,LPSTR lpszCmdLine){
	int RetVal= 1;
		
   // Avoid warnings on unused (but required) formal parameters

	gl = &glob;
	gl->myInst = hinst;
	
	clearBools();
	
   wDataSeg	= wDataSeg;
   cbHeapSize	= cbHeapSize;
   lpszCmdLine = lpszCmdLine;
   
   return RetVal;
}



/* eof, saplist.c */
