/*
 * This file forms part of CorVu dbCGI
 *
 * CorVu dbCGI is Copyright (C) 1995  CorVu Pty Ltd.
 * Written by Troy Rollo
 *
 * CorVu dbCGI is free software. It may be modified and redistributed under
 * the terms of the CorVu General Public License, either version 1, or, at
 * your option, any later version. Ensure that you read this license before
 * modifying or redistributing the software.
 *
 * THIS PROGRAM IS PROVIDED "AS IS" WITH NO WORRANTY OF ANY KIND. YOU USE
 * THIS PROGRAM ENTIRELY AT YOUR OWN RISK. NEITHER CORVU, NOR ANY OTHER
 * PARTY MAY BE HELD RESPONSIBLE FOR ANY DAMAGES ARISING FROM YOUR USE OR
 * MISUSE OF THIS PROGRAM.
 */

/* sqlcpp inserts a macro which can cause the prototype for exit to
 * fail compilation on some systems. Since we don't call exit from
 * this module, we can simply undef it.
 */
#ifdef exit
#undef exit
#endif
#include "dbcgi.h"

#ifndef MAXCOLUMNS
#define	MAXCOLUMNS 40
#endif
static	long	SQLCODE;

typedef struct __dbw_conninfo
{
	int	iDummy;
} dbw_conninfo;

static dbw_typemap atm[] =
{
 {  SQLDACHAR,	0,		SQLDACHAR,	DBWT_Char },
 {  SQLDADATE,	15,		SQLDACHAR,	DBWT_Char },
 {  SQLDASML,	sizeof(long),	SQLDAINT,	DBWT_Int },
 {  SQLDAINT,	sizeof(long),	SQLDAINT,	DBWT_Int },
 {  SQLDALOG,	sizeof(long),	SQLDAINT,	DBWT_Int },
 {  SQLDANUM,	sizeof(double),	SQLDADBL,	DBWT_Float },
 {  SQLDADEC,	sizeof(double),	SQLDADBL,	DBWT_Float },
 {  SQLDAFLT,	sizeof(double),	SQLDADBL,	DBWT_Float },
 {  SQLDAREAL,	sizeof(double),	SQLDADBL,	DBWT_Float },
 {  SQLDADBL,	sizeof(double),	SQLDADBL,	DBWT_Float }
};

void	SendErrorMessage(char *achSQL)
{
	char	*pchError;
	int	nMessages = 0;

	while ((pchError = sqlgetmsg()) != 0 || !nMessages)
	{
		if (pchError == 0 && nMessages == 0)
			pchError = "<Error Message Not Found>";
		FormatErrors(-1, pchError, achSQL);
		nMessages++;
	}
}

static	void	RunQuery(dbw_value *pval,
			int iGetResults)
{
	int	iColumn;
	int	nColumns;
	char	*pchCommand = GetValue(pval, "Query");
	dbw_result *prslt;
	long	*piIndicators;
	dbw_bindinfo *pbi;
	struct SQLDA_T *sqlda;
	char	*pchColumnName;

	if (!iGetResults)
	{
		EXEC SQL EXECUTE IMMEDIATE pchCommand;
		if (SQLCODE < 0)
			SendErrorMessage(pchCommand);
		FreeString(pchCommand);
		return;
	}

	EXEC SQL PREPARE s1 FROM pchCommand;
	if (SQLCODE < 0)
	{
		SendErrorMessage(pchCommand);
		FreeString(pchCommand);
		return;
	}

	EXEC SQL DECLARE c1 CURSOR FOR s1;
	if (SQLCODE < 0)
	{
		SendErrorMessage(pchCommand);
		FreeString(pchCommand);
		return;
	}

	sqlda = sqlald(MAXCOLUMNS);

	EXEC SQL DESCRIBE s1 USING SQL DESCRIPTOR sqlda;
	if (SQLCODE < 0)
	{
		SendErrorMessage(pchCommand);
		FreeString(pchCommand);
		sqldld(sqlda);
		EXEC SQL CLOSE c1;
		return;
	}

	EXEC SQL OPEN c1;
	if (SQLCODE < 0)
	{
		SendErrorMessage(pchCommand);
		FreeString(pchCommand);
		sqldld(sqlda);
		EXEC SQL CLOSE c1;
		return;
	}


	FreeString(pchCommand);
	nColumns = sqlda->COLCNT;

	prslt = new2(dbw_result, nColumns);
	piIndicators = new2(long, nColumns);

	for (iColumn = 0; iColumn < nColumns; iColumn++)
	{
		pchColumnName = (sqlda->SQLVAR[iColumn]->NAME &&
		 	    *sqlda->SQLVAR[iColumn]->NAME) ?
				sqlda->SQLVAR[iColumn]->NAME : "*";
		pbi = FindColInfo(atm,
				rangeof(atm),
				&prslt[iColumn],
				pchColumnName,
				sqlda->SQLVAR[iColumn]->TYPE,
				sqlda->SQLVAR[iColumn]->LENGTH,
				sqlda->SQLVAR[iColumn]->SCALE);
		sqlda->SQLVAR[iColumn]->LENGTH = pbi->iWidth;
		sqlda->SQLVAR[iColumn]->DATA = pbi->pchData;
		sqlda->SQLVAR[iColumn]->TYPE = pbi->iBindType;
		sqlda->SQLVAR[iColumn]->INDICATOR = piIndicators + iColumn;
	}

	FormatHeadings(prslt, nColumns);

	while (1)
	{
		EXEC SQL FETCH c1 INTO SQL DESCRIPTOR sqlda;
		if (SQLCODE != 0)
			break;

		for (iColumn = 0; iColumn < nColumns; iColumn++)
			prslt[iColumn].iIsNull = (piIndicators[iColumn] < 0);
		FormatOutput(prslt, nColumns);
	}

	EXEC SQL CLOSE c1;
	sqldld(sqlda);
	free(piIndicators);
}


void
DBQuery(dbw_value *pval)
{
	RunQuery(pval, 1);
}

void
DBExecute(dbw_value *pval)
{
	RunQuery(pval, 0);
}

void
DBDisconnect(dbw_value *pval)
{
	dbw_conninfo *pinfo = FindConnection(pval);
	char	*pchDatabase = GetValue(pval, "DATABASE");

	if (pinfo && pchDatabase)
	{
		if (sqldiscon(pchDatabase) == -1)
			SendErrorMessage("Disconnecting");
		else
			DropConnection(pval);
	}
	FreeString(pchDatabase);
}

void
DBInit(dbw_value *pval)
{
	char	*pchDir = GetValue(pval, "DLC");
	char	*pchArgs = GetValue(pval, "STARTUP");
	char	*pchAppName = GetValue(pval, "APPNAME");
	char	*pchWorkDir = GetValue(pval, "WRKDIR");

	chdir(pchWorkDir ? pchWorkDir : "/tmp");
	PutEnvVar("DLC", pchDir);
	if (sqllogin(0, (char *) 0, pchArgs,
		pchAppName ? pchAppName : "prodbcgi"))
	{
		FormatErrors(-1, "Login to Progress failed", "Login failed");
		SendErrorMessage("Logging in to progress");
	}
	FreeString(pchDir);
	FreeString(pchArgs);
	FreeString(pchAppName);
	FreeString(pchWorkDir);
}

void
DBUnInit(dbw_value *pval)
{
	sqllogout(0);
}

void
DBConnect(dbw_value *pval)
{
	char	*pchDatabase = GetValue(pval, "CONNSTR");
	dbw_conninfo	*pinfo = new(dbw_conninfo);

	if (!AddConnection(pval, pinfo))
		free(pinfo);
	else if (sqlconn(pchDatabase) == -1)
		SendErrorMessage("Connecting to database");
	FreeString(pchDatabase);
}

