/*
 * This file forms part of CorVu dbCGI
 *
 * CorVu dbCGI is Copyright (C) 1995  CorVu Pty Ltd.
 * Written by Troy Rollo
 *
 * CorVu dbCGI is free software. It may be modified and redistributed under
 * the terms of the CorVu General Public License, either version 1, or, at
 * your option, any later version. Ensure that you read this license before
 * modifying or redistributing the software.
 *
 * THIS PROGRAM IS PROVIDED "AS IS" WITH NO WORRANTY OF ANY KIND. YOU USE
 * THIS PROGRAM ENTIRELY AT YOUR OWN RISK. NEITHER CORVU, NOR ANY OTHER
 * PARTY MAY BE HELD RESPONSIBLE FOR ANY DAMAGES ARISING FROM YOUR USE OR
 * MISUSE OF THIS PROGRAM.
 */

#include "dbcgi.h"
#include "oracle.h"

typedef struct __dbw_conninfo
{
	struct	ldadef lda;
	struct	crsdef cursor;
} dbw_conninfo;

static dbw_typemap atm[] =
{
 {  ORA_CHARACTER,	0,		ORA_NTS,	DBWT_Char },
 {  ORA_NEW_CHAR,	0,		ORA_NTS,	DBWT_Char },
 {  ORA_MLSLABEL,	257,		ORA_NTS,	DBWT_Char },
 {  ORA_LONG,		-1,		ORA_NTS,	DBWT_Char },
 {  ORA_ROWID,		20,		ORA_NTS,	DBWT_Char },
 {  ORA_DATE,		9,		ORA_NTS,	DBWT_Char },
 {  ORA_RAW,		-1,		ORA_LONG_VARRAW,DBWT_Raw_Lidx },
 {  ORA_LONG_RAW,	-1,		ORA_LONG_VARRAW,DBWT_Raw_Lidx },
 {  ORA_NUMBER,		0,		ORA_DOUBLE,	DBWT_Float }
};

void	SendErrorMessage(char *achSQL,
			short iCode,
			dbw_conninfo *pinfo)
{
	static char achError[512];

	oerhms(&pinfo->lda, (sb2) iCode, achError, (sword) sizeof(achError));
	FormatErrors(iCode, achError, achSQL);
}

static	void	RunQuery(dbw_value *pval,
			int iGetResults)
{
	int	iColumn;
	int	nColumns;
	char	*pchCommand = GetValue(pval, "Query");
	sb4	iDummy4;
	sb4	iStrLen;
	sb4	iColumnWidth;
	sb2	iColType;
	sb2	iDummy2;
	char	achColumnName[256];
	dbw_result *prslt;
	short	*piIndicators;
	dbw_bindinfo *pbi;
	dbw_conninfo *pinfo = FindConnection(pval);

	if (!pinfo)
		return;
	oparse(&pinfo->cursor, pchCommand,
		(sb4) strlen(pchCommand),
		(sword) 0,
		(ub4) 1);
	if (!pinfo->cursor.Return_Code)
		oexec(&pinfo->cursor);
	if (pinfo->cursor.Return_Code)
	{
		SendErrorMessage(pchCommand, pinfo->cursor.Return_Code, pinfo);
		FreeString(pchCommand);
		return;
	}
	FreeString(pchCommand);

	if (!iGetResults)
		return;

	for (nColumns = 0;; nColumns++)
	{
		odescr(&pinfo->cursor, 
			nColumns + 1,
			&iDummy4,
			&iColType,
			(char *) 0,
			(sb4 *) 0,
			&iDummy4,
			&iDummy2,
			&iDummy2,
			&iDummy2);
		if (pinfo->cursor.Return_Code)
		{
			pinfo->cursor.Return_Code = 0;
			break;
		}
	}
	prslt = new2(dbw_result, nColumns);
	piIndicators = new2(short, nColumns);
	for (iColumn = 0; iColumn < nColumns; iColumn++)
	{
		iStrLen = sizeof(achColumnName) - 1;
		odescr(&pinfo->cursor,
			iColumn + 1,
			&iDummy4,
			&iColType,
			achColumnName,
			&iStrLen,
			&iColumnWidth,
			&iDummy2,
			&iDummy2,
			&iDummy2);
		achColumnName[iStrLen] = 0;
		pbi = FindColInfo(atm,
				rangeof(atm),
				&prslt[iColumn],
				achColumnName,
				iColType,
				iColumnWidth,
				-1);
		odefin(&pinfo->cursor,
			iColumn + 1,
			pbi->pchData,
			pbi->iWidth,
			pbi->iBindType,
			-1,
			piIndicators + iColumn,
			(char *) 0,
			-1,
			-1,
			(short *) 0,
			(short *) 0);
	}

	FormatHeadings(prslt, nColumns);
	while (!ofetch(&pinfo->cursor))
	{
		for (iColumn = 0; iColumn < nColumns; iColumn++)
			prslt[iColumn].iIsNull = (piIndicators[iColumn] < 0);
		FormatOutput(prslt, nColumns);
	}
	if (pinfo->cursor.Return_Code != 1403)
		SendErrorMessage("Fetching data", pinfo->cursor.Return_Code, pinfo);
	ocan(&pinfo->cursor);
}


void
DBQuery(dbw_value *pval)
{
	RunQuery(pval, 1);
}

void
DBExecute(dbw_value *pval)
{
	RunQuery(pval, 0);
}

static	char	hda[256];

void
DBDisconnect(dbw_value *pval)
{
	dbw_conninfo *pinfo = FindConnection(pval);

	if (!pinfo)
		return;
	ologof(&pinfo->lda);
	DropConnection(pval);
}

void
DBInit(dbw_value *pval)
{
	char	*pchSID = GetValue(pval, "ORACLE_SID");
	char	*pchTwoTask = GetValue(pval, "TWO_TASK");
	char	*pchOraHome = GetValue(pval, "ORACLE_HOME");
	int	i;

	PutEnvVar("ORACLE_SID", pchSID);
	PutEnvVar("TWO_TASK", pchTwoTask);
	PutEnvVar("ORACLE_HOME", pchOraHome);
	FreeString(pchSID);
	FreeString(pchTwoTask);
	FreeString(pchOraHome);
	for (i = 0; i < sizeof(atm); i++)
		if (atm[i].iSize == -1)
			atm[i].iSize = nMaxBlob;
}

void
DBUnInit(dbw_value *pval)
{
}

void
DBConnect(dbw_value *pval)
{
	char		*pchUser = GetValue(pval, "USER");
	char		*pchPass = GetValue(pval, "PASS");
	char		*pchConnString = GetValue(pval, "CONN_STR");
	char		achConnString[256];
	dbw_conninfo	*pinfo = new(dbw_conninfo);

	if (!AddConnection(pval, pinfo))
	{
		free(pinfo);
		return;
	}
	if (pchConnString)
	{
		sprintf(achConnString, "%s@%s", pchUser, pchConnString);
		orlon(&pinfo->lda, hda, achConnString, -1, pchPass, -1, -1);
	}
	else
	{
		olon(&pinfo->lda, pchUser, strlen(pchUser),
			pchPass, strlen(pchPass), -1);
	}
	if (pinfo->lda.Return_Code)
	{
		SendErrorMessage(pchUser, pinfo->lda.Return_Code, pinfo);
		DropConnection(pval);
	}
	else
	{
		oopen(&pinfo->cursor,
			&pinfo->lda,
			(char *) 0,
			-1,
			-1,
			(char *) 0,
			-1);

		if (pinfo->lda.Return_Code)
		{
			SendErrorMessage(pchUser, pinfo->lda.Return_Code, pinfo);
			DropConnection(pval);
		}
	}
	FreeString(pchConnString);
	FreeString(pchUser);
	FreeString(pchPass);
}

