/*
 * This file forms part of CorVu dbCGI
 *
 * CorVu dbCGI is Copyright (C) 1995  CorVu Pty Ltd.
 * Written by Troy Rollo
 *
 * CorVu dbCGI is free software. It may be modified and redistributed under
 * the terms of the CorVu General Public License, either version 1, or, at
 * your option, any later version. Ensure that you read this license before
 * modifying or redistributing the software.
 *
 * THIS PROGRAM IS PROVIDED "AS IS" WITH NO WORRANTY OF ANY KIND. YOU USE
 * THIS PROGRAM ENTIRELY AT YOUR OWN RISK. NEITHER CORVU, NOR ANY OTHER
 * PARTY MAY BE HELD RESPONSIBLE FOR ANY DAMAGES ARISING FROM YOUR USE OR
 * MISUSE OF THIS PROGRAM.
 */

EXEC SQL include sqlca;
EXEC SQL include sqlda;
EXEC SQL include sqlstype;
EXEC SQL include sqltypes;
EXEC SQL include decimal;
EXEC SQL include datetime;
EXEC SQL include locator;

EXEC SQL BEGIN DECLARE SECTION;
	static	char	*pchCommand;
	static	char	*pchDatabase;
EXEC SQL END DECLARE SECTION;

#include "dbcgi.h"

#ifndef MAXCOLUMNS
#define	MAXCOLUMNS 40
#endif

typedef struct __dbw_conninfo
{
	int	iDummy;
} dbw_conninfo;

static dbw_typemap atm[] =
{
 {  SQLCHAR,	0,		CCHARTYPE,	DBWT_Char },
 {  SQLVCHAR,	0,		CCHARTYPE,	DBWT_Char },
#if defined(SQLNCHAR) && defined(SQLNVCHAR)
 {  SQLNCHAR,	0,		CCHARTYPE,	DBWT_Char },
 {  SQLNVCHAR,	0,		CCHARTYPE,	DBWT_Char },
#endif
 {  SQLTEXT,	0,		CLOCATORTYPE,	DBWT_Char },
 {  SQLBYTES,	0,		CLOCATORTYPE,	DBWT_Raw_Lidx },
 {  SQLSMINT,	sizeof(long),	CLONGTYPE,	DBWT_Int },
 {  SQLINT,	sizeof(long),	CLONGTYPE,	DBWT_Int },
 {  SQLINTERVAL,sizeof(long),	CLONGTYPE,	DBWT_Char },
 {  SQLSERIAL,	sizeof(long),	CLONGTYPE,	DBWT_Int },
 {  SQLDECIMAL,	sizeof(double),	CDOUBLETYPE,	DBWT_Float },
 {  SQLSMFLOAT,	sizeof(double),	CDOUBLETYPE,	DBWT_Float },
 {  SQLFLOAT,	sizeof(double),	CDOUBLETYPE,	DBWT_Float },
 {  SQLMONEY,	sizeof(double),	CDOUBLETYPE,	DBWT_Float },
 {  SQLDATE,	SIZDATE,	SQLDATE,	DBWT_Char },
 {  SQLDTIME,	32,		SQLDTIME,	DBWT_Char }
};

void	SendErrorMessage(char *achSQL)
{
	static char achError[40];

	sprintf(achError,
		"An error occurred at or near character %d",
		(int) sqlca.sqlerrd[4]);
	FormatErrors(sqlca.sqlcode, achError, achSQL);
}

static	void	RunQuery(dbw_value *pval,
			int iGetResults)
{
	int	iColumn;
	int	nColumns;
	char	*pchCommand = GetValue(pval, "Query");
	dbw_result *prslt;
	short	*piIndicators;
	int	*piIsLocated;
	dbw_bindinfo *pbi;
	struct sqlda *sqlda;
	char	*pchColumnName;
	loc_t	*ploc;

	EXEC SQL PREPARE s1 FROM :pchCommand;
	if (sqlca.sqlcode < 0)
	{
		SendErrorMessage(pchCommand);
		FreeString(pchCommand);
		return;
	}
	sqlda = new(struct sqlda);
	sqlda->sqlvar = new2(struct sqlvar_struct, MAXCOLUMNS);

	EXEC SQL DESCRIBE s1 INTO sqlda;
	if (sqlca.sqlcode < 0)
	{
		SendErrorMessage(pchCommand);
		free(sqlda->sqlvar);
		free(sqlda);
		FreeString(pchCommand);
		return;
	}

	if (sqlda->sqld == 0)
	{
		EXEC SQL EXECUTE s1;
		if (sqlca.sqlcode < 0)
		{
			SendErrorMessage(pchCommand);
			free(sqlda->sqlvar);
			free(sqlda);
			FreeString(pchCommand);
			return;
		}
	}

	if (!iGetResults)
	{
		EXEC SQL FREE s1;
		free(sqlda->sqlvar);
		free(sqlda);
		FreeString(pchCommand);
		return;
	}

	FreeString(pchCommand);

	nColumns = sqlda->sqld;

	prslt = new2(dbw_result, nColumns);
	piIndicators = new2(short, nColumns);
	piIsLocated = new2(int, nColumns);
	ploc = new2(loc_t, nColumns);

	for (iColumn = 0; iColumn < nColumns; iColumn++)
	{
		pchColumnName = (sqlda->sqlvar[iColumn].sqlname &&
		 	    *sqlda->sqlvar[iColumn].sqlname) ?
				sqlda->sqlvar[iColumn].sqlname : "*";
		pbi = FindColInfo(atm,
				rangeof(atm),
				&prslt[iColumn],
				pchColumnName,
				sqlda->sqlvar[iColumn].sqltype,
				sqlda->sqlvar[iColumn].sqllen,
				-1);
		if (pbi->iBindType == CLOCATORTYPE)
		{
			sqlda->sqlvar[iColumn].sqldata =
					(char *) &ploc[iColumn];
			if (prslt[iColumn].type == DBWT_Char)
			{
				ploc[iColumn].loc_buffer = pbi->pchData;
				ploc[iColumn].loc_bufsize = pbi->iWidth;
			}
			else
			{
				ploc[iColumn].loc_buffer = pbi->pchData + 4;
				ploc[iColumn].loc_bufsize = pbi->iWidth - 4;
			}
			ploc[iColumn].loc_loctype = LOCMEMORY;
			ploc[iColumn].loc_type = sqlda->sqlvar[iColumn].sqltype;
			sqlda->sqlvar[iColumn].sqllen = sizeof(ploc[0]);
			piIsLocated[iColumn] = 1;
		}
		else
		{
			sqlda->sqlvar[iColumn].sqllen = pbi->iWidth;
			sqlda->sqlvar[iColumn].sqldata = pbi->pchData;
			piIsLocated[iColumn] = 0;
		}
		sqlda->sqlvar[iColumn].sqltype = pbi->iBindType;
		sqlda->sqlvar[iColumn].sqlind = piIndicators + iColumn;
	}

	FormatHeadings(prslt, nColumns);

	EXEC SQL DECLARE c1 CURSOR FOR s1;
	EXEC SQL OPEN c1;

	while (1)
	{
		EXEC SQL FETCH c1 USING DESCRIPTOR sqlda;
		if (sqlca.sqlcode != 0)
			break;

		for (iColumn = 0; iColumn < nColumns; iColumn++)
		{
			if (piIsLocated[iColumn])
			{
				prslt[iColumn].iIsNull = (ploc[iColumn].loc_indicator < 0);
				if (prslt[iColumn].type == DBWT_Char)
					ploc[iColumn].loc_buffer[ploc[iColumn].loc_size] = 0;
				else
					*(((long *) ploc[iColumn].loc_buffer) - 1) =
						ploc[iColumn].loc_size;
			}
			else
			{
				prslt[iColumn].iIsNull = (piIndicators[iColumn] < 0);
			}
		}
		FormatOutput(prslt, nColumns);
	}

	EXEC SQL CLOSE c1;
	EXEC SQL FREE s1;
	free(sqlda->sqlvar);
	free(sqlda);
	free(ploc);
	free(piIsLocated);
}


void
DBQuery(dbw_value *pval)
{
	RunQuery(pval, 1);
}

void
DBExecute(dbw_value *pval)
{
	RunQuery(pval, 0);
}

void
DBDisconnect(dbw_value *pval)
{
	dbw_conninfo *pinfo = FindConnection(pval);

	if (!pinfo)
		return;
	EXEC SQL CLOSE DATABASE;
	DropConnection(pval);
}

void
DBInit(dbw_value *pval)
{
	int		i;

	while (pval)
	{
		if (strcmp(pval->pchKey, "MAXBLOB"))
			PutEnvVar(pval->pchKey, pval->pchValue);
		pval = pval->pvalNext;
	}
	for (i = 0; i < rangeof(atm); i++)
		if (atm[i].iBindType == CLOCATORTYPE)
			atm[i].iSize = nMaxBlob;
}

void
DBUnInit(dbw_value *pval)
{
}

void
DBConnect(dbw_value *pval)
{
	char		*pchDatabase = GetValue(pval, "DATABASE");
	dbw_conninfo	*pinfo = new(dbw_conninfo);

	if (!AddConnection(pval, pinfo))
	{
		free(pinfo);
		return;
	}

	EXEC SQL DATABASE :pchDatabase;
	if (sqlca.sqlcode)
	{
		SendErrorMessage("Connecting to Database");
		DropConnection(pval);
		return;
	}

	FreeString(pchDatabase);
}

