/*
 * This file forms part of CorVu dbCGI
 *
 * CorVu dbCGI is Copyright (C) 1995  CorVu Pty Ltd.
 * Written by Troy Rollo
 *
 * CorVu dbCGI is free software. It may be modified and redistributed under
 * the terms of the CorVu General Public License, either version 1, or, at
 * your option, any later version. Ensure that you read this license before
 * modifying or redistributing the software.
 *
 * THIS PROGRAM IS PROVIDED "AS IS" WITH NO WORRANTY OF ANY KIND. YOU USE
 * THIS PROGRAM ENTIRELY AT YOUR OWN RISK. NEITHER CORVU, NOR ANY OTHER
 * PARTY MAY BE HELD RESPONSIBLE FOR ANY DAMAGES ARISING FROM YOUR USE OR
 * MISUSE OF THIS PROGRAM.
 */

#ifndef __DBCGI_H
#define	__DBCGI_H

#ifdef _Windows
#include <windows.h>
#endif
#include <stdio.h>
#include <errno.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

typedef	char	*dbw_buf;

#define	READ_SIZE 16384

extern	FILE *fpOutput;

/* Not bracketing the x below is safe because rangeof will
 * only work if supplied an array name as its argument
 */
#define	rangeof(x) (sizeof(x) / sizeof(x[0]))

typedef struct __dbw_value
{
	dbw_buf	pchKey;
	dbw_buf pchValue;
	struct __dbw_value *pvalNext;
} dbw_value;

/*
 * The datatypes we understand. Currently only Char, Int, Dec and
 * Float are understood.
 */
typedef	enum
{
	DBWT_Char,	/* Char, VarChar, long VarChar		*/
	DBWT_Int,	/* Int, Short, Byte, Boolean		*/
	DBWT_Dec,	/* Decimal, Packed, Zoned, Scaled	*/
	DBWT_Float,	/* Float, Double, Real, Number		*/
	DBWT_Raw,	/* Fixed length BLOBs			*/
	DBWT_Raw_Sidx,	/* Var length BLOBs, 2 byte length	*/
	DBWT_Raw_Lidx	/* Var length BLOBs, 4 byte length	*/
} dbw_type;

typedef struct __dbw_connection
{
	char	*pchConnID;
	struct __dbw_conninfo *pci;
	struct __dbw_connection *pconnNext;
} dbw_connection;

typedef	struct
{
	dbw_type type;
	dbw_buf	pchHeading;		/* The column heading		*/
	int	iIsNull;		/* Is the value NULL?		*/
	dbw_buf pchCharValue;		/* The value (char types)	*/
	long	iIntValue;		/* The value (int/dec types)	*/
	double	fValue;			/* The value (float types)	*/
	int	iScale;			/* The scale (dec/float types)  */
					/* The length (char types)	*/
} dbw_result;

typedef struct __dbw_bindinfo
{
	char	*pchData;
	long	iWidth;
	int	iBindType;
} dbw_bindinfo;

typedef struct	__dbw_typemap
{
	int	iOrigType;
	int	iSize;
	int	iBindType;
	dbw_type type;
} dbw_typemap;

#define	new(x)	(x *) malloc(sizeof(x))
#define	new2(x,n)	(x *) malloc(sizeof(x) * (n));

extern	void	FormatOutput(	dbw_result *prslt,
				int	iColumns);
extern	void	FormatHeadings(	dbw_result *prslt,
				int	iColumns);
extern	void	FormatErrors(	long	iErrNo,
				dbw_buf	pchErrMsg,
				dbw_buf	pchSQL);
extern	char	*GetValue(	dbw_value *pval,
				char const *pchKey);
extern	void	FreeString(char *pchString);
extern	void	PutEnvVar(char const *pchVar,
			char const *pchVal);
extern	dbw_bindinfo *FindColInfo(dbw_typemap *atm,
                                int iEntries,
				dbw_result *prslt,
				char const *pchColumn,
                                int iColType,
                                int iColumnWidth,
                                int iColumnPrec);
extern	struct __dbw_conninfo *FindConnection(dbw_value *pval);
extern	int AddConnection(dbw_value *pval,
			struct __dbw_conninfo *pinfo);
extern	void DropConnection(dbw_value *pval);	

#ifndef sys_errlist
extern	char	*sys_errlist[];
#endif


#ifdef _Windows
extern	void	FlushMessages(void);
#endif

extern	long	nMaxBlob;

#endif
