
Sub alarmend ()
  
  'say that were ending it all, disable timer
  alarm.status.Text = "Ending"
  alarm.alarmtimer.Enabled = False
  
  'free allocated memory
  freememory

  'switch the framegrabber off
  q% = pcv_disablevideo()

  'all done
  End

End Sub

Sub info ()
  
  'copyright notice and info/help
  lf$ = Chr$(10)
  message$ = lf$
  message$ = message$ & "Alarm Version 1.0" + lf$
  message$ = message$ & "Framegrabber DLL Copyright (C) P.J. Scholtz 1994" + lf$ + lf$
  message$ = message$ & "Status : Initialize, video on, scanning, ending" + lf$
  message$ = message$ & "Scan Delay : Seconds of live video before scanning" + lf$
  message$ = message$ & "Pixel Step : Smaller value takes longer but is more accurate" + lf$
  message$ = message$ & "What is Bad : If result is >= then set alarm on" + lf$
  message$ = message$ & "Scan Result : Luma difference of previous and current frame" + lf$
  message$ = message$ & "Alarm Alert : Is the alarm on or not" + lf$
  message$ = message$ & "Save to Disk : Save frame to disk in .MMP format" + lf$
  message$ = message$ & "Exit : Switch framegrabber off and free memory" + lf$
  alarm.Label7.Caption = message$
  alarm.Label7.Visible = True
  MsgBox "Please support shareware !", 0, "Information"
  alarm.Label7.Visible = False

End Sub

Sub initializealarm ()
  
  'called when form is loaded
  
  'maximize window, display window
  alarm.WindowState = 2
  alarm.Show
  alarm.Refresh
  
  'standard PC-Video DLL initialization for full-screen video
  q% = pcv_loadconfiguration()
  q% = pcv_initialize()
  If q% = 0 Then
    q% = MsgBox("The video capture adaptor was NOT found.", 48, "I have a problem !")
    End
  End If
  q% = pcv_setcolorkey(2) 'green
  q% = pcv_createwindow(0, 0, 640, 480, 1)
  q% = pcv_setwindowsize(640, 480, 0)
  q% = pcv_setwindowposition(0, 0)
  q% = pcv_setvideosource(0)
  q% = pcv_enablevideo()
  q% = pcv_unfreezevideo()
  
  'ask user which framegrabber is installed
  'the call to INITDLL needs to be told which card is installed
  message$ = "Select YES for" + Chr$(10) + Chr$(10)
  message$ = message$ + "PE-Von PV100" + Chr$(10)
  message$ = message$ + "Adda Aver 2000" + Chr$(10)
  message$ = message$ + "Aitech Pro PC-Video" + Chr$(10) + Chr$(10) + Chr$(10)
  message$ = message$ + "Select NO for" + Chr$(10) + Chr$(10)
  message$ = message$ + "Creative Labs VideoBlaster"
  card% = MsgBox(message$, 3, "Which framegrabber do you have installed ?")
  If card% <> 6 And card% <> 7 Then
    q% = MsgBox("You cancelled - ending program.", 0, "The End")
    End
  End If
  
  'set cursor to hourglass
  alarm.MousePointer = 11

  'initialize framegrabber DLL with one extra page (768KB each)
  'page 0 is the visible framegrabber memory, page 1 is the extra page -
  'to store the previous frame
  '2nd parameter indicates card type: 0 = PE-Von PV100, Adda Aver 2000, Aitech Pro PC-Video
  '                                   1 = Creative Labs VideoBlaster
  'a minimum of one additional page must be initialized
  Call initdll(1, card% - 6)
  
  'set framegrabber memory as the default active page
  Call setactivepage(0)
  
  'store a frame to page 1
  q% = pcv_freezevideo()
  Call copyblock(0, 0, 640, 480, 0, 1)
  q% = pcv_unfreezevideo()
  
  'say that video is on/initialization complete, start timer, set cursor normal
  alarm.status.Text = "Video On"
  alarm.alarmtimer.Enabled = True
  alarm.MousePointer = 0

End Sub

Sub scancaptures ()
  
  'Disable timer and say that we are busy scanning
  alarm.alarmtimer.Enabled = False
  alarm.status.Text = "Scanning"
  
  'freeze video
  q% = pcv_freezevideo()
  
  'step according to user changable control: alarm.pixelstep.Text
  'scan top to bottom, left to right
  For y% = 0 To 479 Step Val(alarm.pixelstep.Text)
    For x% = 0 To 639 Step Val(alarm.pixelstep.Text)
      
      'read from framegrabber memory (page 0)
      setactivepage (0)
      Call yuvgetpixel(x%, y%, luma0%, chroma1%, chroma2%)
      
      'read from previously stored frame (page 1)
      setactivepage (1)
      Call yuvgetpixel(x%, y%, luma1%, chroma1%, chroma2%)
      
      'check difference in black & white intensity (the luma)
      'we are ignoring the colour (the chroma)
      'if colour is important rather use RGBGETPIXEL
      diff& = diff& + Abs(luma0% - luma1%)

    Next x%
  Next y%
  
  'store current frame (page 0) to page 1
  Call copyblock(0, 0, 640, 480, 0, 1)
  
  'switch video back on
  q% = pcv_unfreezevideo()
  
  'display result of scan
  'total luma difference divided by total number of pixels checked
  alarm.scanresult.Text = LTrim$(Str$(diff& \ (307200 / (Val(alarm.pixelstep.Text) * Val(alarm.pixelstep.Text)))))

  'check if the alarm should be switched on
  If Val(alarm.scanresult.Text) >= Val(alarm.whatisbad.Text) Then
    'say that the alarm has been sounded
    alarm.alarmalert.Text = "Alarm !"
    Beep
    'alarm is on, must the frame be stored to disk?
    If alarm.saveornot(0).Value Then
      alarm.status.Text = "Saving"
      'filename = mmddhhmm.ss
      filename$ = Left$(Date$, 2) + Mid$(Date$, 4, 2) + Left$(Time$, 2) + Mid$(Time$, 4, 2) + "." + Right$(Time$, 2)
      q% = savemmp(filename$, 0, 0, 640, 480)
    End If
  Else
    'say that all is ok/alarm is off
    alarm.alarmalert.Text = "All Ok"
  End If
  
  'Say that video is live, switch on the timer
  alarm.status.Text = "Video On"
  alarm.alarmtimer.Enabled = True

End Sub

Sub setinterval ()
  
  'visual basic timer delays in milliseconds so multiply by 1000
  'a value of zero for timer.interval disables timer, so add one
  alarm.alarmtimer.Interval = Val(alarm.scandelay.Text) * 1000 + 1

End Sub

